/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.uma.ecore.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EStructuralFeature;

public class OppositeFeature {
    private String name;
    private EStructuralFeature targetFeature;
    private boolean isMany;
    private boolean resolveOwner = true;
    private Class ownerClass;
    public static final Map classOppositeFeaturesMap = new HashMap();
    public static final Map featureOppositeFeatureMap = new HashMap();

    public OppositeFeature(Class clazz, String string, EStructuralFeature eStructuralFeature, boolean bl, boolean bl2) {
        this.ownerClass = clazz;
        this.name = string;
        this.targetFeature = eStructuralFeature;
        this.isMany = bl;
        this.resolveOwner = bl2;
    }

    public OppositeFeature(Class clazz, String string, EStructuralFeature eStructuralFeature, boolean bl) {
        this(clazz, string, eStructuralFeature, bl, true);
    }

    public Class getOwnerClass() {
        return this.ownerClass;
    }

    public boolean isMany() {
        return this.isMany;
    }

    public String getName() {
        return this.name;
    }

    public EStructuralFeature getTargetFeature() {
        return this.targetFeature;
    }

    public int getFeatureID() {
        return -1 - this.targetFeature.getFeatureID();
    }

    public boolean resolveOwner() {
        return this.resolveOwner;
    }

    public String toString() {
        return String.valueOf(this.name) + "[targetFeature=" + this.targetFeature + ", isMany=" + this.isMany + "]";
    }

    public static final void registerOppositeFeature(OppositeFeature oppositeFeature) {
        Class clazz = oppositeFeature.getOwnerClass();
        HashSet<OppositeFeature> hashSet = (HashSet<OppositeFeature>)classOppositeFeaturesMap.get(clazz);
        if (hashSet == null) {
            hashSet = new HashSet<OppositeFeature>();
            classOppositeFeaturesMap.put(clazz, hashSet);
        }
        hashSet.add(oppositeFeature);
        featureOppositeFeatureMap.put(oppositeFeature.getTargetFeature(), oppositeFeature);
    }

    public static final OppositeFeature getOppositeFeature(EStructuralFeature eStructuralFeature) {
        return (OppositeFeature)featureOppositeFeatureMap.get(eStructuralFeature);
    }
}

