/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gmf.runtime.notation.Diagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramService {
    private Set<DiagramManager> diagramManagers = new HashSet<DiagramManager>();

    public void dispose() {
        for (DiagramManager diagramManager : this.diagramManagers) {
            diagramManager.removeConsumer(this);
        }
    }

    public DiagramManager getDiagramManager(Activity activity) {
        Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
        if (process != null) {
            DiagramManager diagramManager = DiagramManager.getInstance(TngUtil.getOwningProcess((BreakdownElement)activity), this);
            this.diagramManagers.add(diagramManager);
            return diagramManager;
        }
        return null;
    }

    public Collection<Diagram> getDiagrams(Activity activity) {
        DiagramManager diagramManager = this.getDiagramManager(activity);
        return diagramManager != null ? DiagramHelper.getDiagrams(activity, diagramManager) : Collections.EMPTY_LIST;
    }

    public Diagram getBaseDiagram(Activity activity, int n) {
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity)) {
            try {
                Activity activity2 = (Activity)activity.getVariabilityBasedOnElement();
                DiagramManager diagramManager = this.getDiagramManager(activity2);
                List<Diagram> list = diagramManager.getDiagrams(activity2, n);
                if (!list.isEmpty()) {
                    return list.get(0);
                }
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError("Error in getting base diagram: ", (Throwable)exception);
            }
        }
        return null;
    }

    public Diagram getDiagram(Activity activity, int n) {
        try {
            DiagramManager diagramManager = this.getDiagramManager(activity);
            List<Diagram> list = diagramManager.getDiagrams(activity, n);
            return list.isEmpty() ? null : list.get(0);
        }
        catch (Exception exception) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }
}

