/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.html;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.tidy.Tidy;

public class HTMLParser {
    private static final int BUFFER_SIZE = 4096;
    private static final String HTML_SCRIPT_TAG = "script";
    private static final String HTML_TITLE_TAG = "title";
    private static final String HTML_META_TAG = "meta";
    private Tidy tidy;
    private String title;
    private String summary;
    private String text;
    private Properties metaTags;
    private StringBuffer htmlText;

    public HTMLParser() {
        try {
            this.tidy = new Tidy();
            this.tidy.setXHTML(true);
            this.tidy.setDropEmptyParas(true);
            this.tidy.setDropFontTags(true);
            this.tidy.setQuiet(true);
            this.tidy.setShowWarnings(false);
            this.tidy.setSmartIndent(false);
            this.tidy.setTidyMark(false);
            this.tidy.setWraplen(132);
            this.tidy.setIndentAttributes(false);
            this.tidy.setIndentContent(false);
            this.tidy.setSpaces(2);
            this.tidy.setInputEncoding("UTF-8");
            this.tidy.setOutputEncoding("UTF-8");
        }
        catch (Exception exception) {
            this.tidy = null;
        }
    }

    public void parse(File file) throws Exception {
        int n;
        if (this.tidy == null || !file.exists() || !file.canRead()) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, "UTF-8");
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuffer stringBuffer = new StringBuffer(4096);
        char[] cArray = new char[4096];
        while ((n = bufferedReader.read(cArray, 0, 4096)) > 0) {
            stringBuffer.append(cArray, 0, n);
        }
        this.parse(stringBuffer.toString());
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
        }
    }

    protected void parse(String string) throws Exception {
        this.title = "";
        this.summary = "";
        this.text = "";
        this.metaTags = new Properties();
        Document document = this.getDocument(string);
        if (document != null) {
            this.htmlText = new StringBuffer(1024);
            this.extract(document.getChildNodes());
            this.text = this.htmlText.toString();
        }
    }

    public String getTitle() {
        return this.title;
    }

    public Properties getMetaTags() {
        return this.metaTags;
    }

    public String getSummary() {
        return this.summary;
    }

    public String getText() {
        return this.text;
    }

    protected Document getDocument(String string) throws Exception {
        if (string == null || string.length() == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.tidy.setErrout(printWriter);
        return this.tidy.parseDOM((InputStream)byteArrayInputStream, (OutputStream)byteArrayOutputStream);
    }

    protected void extract(NodeList nodeList) {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            String string = node.getNodeName();
            switch (node.getNodeType()) {
                case 1: {
                    if (string.equals(HTML_SCRIPT_TAG)) break;
                    NamedNodeMap namedNodeMap = node.getAttributes();
                    int n2 = 0;
                    while (n2 < namedNodeMap.getLength()) {
                        Node node2 = namedNodeMap.item(n2);
                        String string2 = node2.getNodeName();
                        String string3 = node2.getNodeValue();
                        if (string2.equals(HTML_TITLE_TAG)) {
                            this.title = string3;
                        } else if (string2.equals(HTML_META_TAG)) {
                            this.metaTags.put(string2, string3);
                        }
                        ++n2;
                    }
                    NodeList nodeList2 = node.getChildNodes();
                    if (nodeList2 == null || nodeList2.getLength() <= 0) break;
                    this.extract(nodeList2);
                    break;
                }
                case 3: {
                    this.htmlText.append(node.getNodeValue()).append(' ');
                }
            }
            ++n;
        }
    }
}

