/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.part;

import java.io.IOException;
import java.util.LinkedList;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.ad.part.ActivityDiagramEditorPlugin;
import org.eclipse.epf.diagram.ad.part.Messages;
import org.eclipse.epf.diagram.ad.part.ModelElementSelectionPage;
import org.eclipse.epf.diagram.ad.part.UMLDiagramEditorUtil;
import org.eclipse.epf.diagram.ad.part.UMLVisualIDRegistry;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.diagram.core.services.view.CreateDiagramViewOperation;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class UMLNewDiagramFileWizard
extends Wizard {
    private TransactionalEditingDomain myEditingDomain;
    private WizardNewFileCreationPage myFileCreationPage;
    private ModelElementSelectionPage diagramRootElementSelectionPage;

    public UMLNewDiagramFileWizard(URI uRI, EObject eObject, TransactionalEditingDomain transactionalEditingDomain) {
        Path path;
        assert (uRI != null) : "Domain model uri must be specified";
        assert (eObject != null) : "Doagram root element must be specified";
        assert (transactionalEditingDomain != null) : "Editing domain must be specified";
        this.myFileCreationPage = new WizardNewFileCreationPage(Messages.UMLNewDiagramFileWizard_CreationPageName, (IStructuredSelection)StructuredSelection.EMPTY);
        this.myFileCreationPage.setTitle(Messages.UMLNewDiagramFileWizard_CreationPageTitle);
        this.myFileCreationPage.setDescription(NLS.bind((String)Messages.UMLNewDiagramFileWizard_CreationPageDescription, (Object)"AD"));
        String string = uRI.trimFileExtension().lastSegment();
        if (uRI.isPlatformResource()) {
            path = new Path(uRI.trimSegments(1).toPlatformString(true));
        } else if (uRI.isFile()) {
            path = new Path(uRI.trimSegments(1).toFileString());
        } else {
            throw new IllegalArgumentException("Unsupported URI: " + uRI);
        }
        this.myFileCreationPage.setContainerFullPath((IPath)path);
        this.myFileCreationPage.setFileName(UMLDiagramEditorUtil.getUniqueFileName((IPath)path, string, "xmi"));
        this.diagramRootElementSelectionPage = new DiagramRootElementSelectionPage(Messages.UMLNewDiagramFileWizard_RootSelectionPageName);
        this.diagramRootElementSelectionPage.setTitle(Messages.UMLNewDiagramFileWizard_RootSelectionPageTitle);
        this.diagramRootElementSelectionPage.setDescription(Messages.UMLNewDiagramFileWizard_RootSelectionPageDescription);
        this.diagramRootElementSelectionPage.setModelElement(eObject);
        this.myEditingDomain = transactionalEditingDomain;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.myFileCreationPage);
        this.addPage((IWizardPage)this.diagramRootElementSelectionPage);
    }

    public boolean performFinish() {
        LinkedList<IFile> linkedList = new LinkedList<IFile>();
        IFile iFile = this.myFileCreationPage.createNewFile();
        UMLDiagramEditorUtil.setCharset(iFile);
        linkedList.add(iFile);
        URI uRI = URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)true);
        ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
        final Resource resource = resourceSet.createResource(uRI);
        AbstractTransactionalCommand abstractTransactionalCommand = new AbstractTransactionalCommand(this.myEditingDomain, Messages.UMLNewDiagramFileWizard_InitDiagramCommand, linkedList){

            protected CommandResult doExecuteWithResult(IProgressMonitor iProgressMonitor, IAdaptable iAdaptable) throws ExecutionException {
                int n = UMLVisualIDRegistry.getDiagramVisualID(UMLNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement());
                if (n != 79) {
                    return CommandResult.newErrorCommandResult((String)Messages.UMLNewDiagramFileWizard_IncorrectRootError);
                }
                Diagram diagram = ViewService.createDiagram((EObject)UMLNewDiagramFileWizard.this.diagramRootElementSelectionPage.getModelElement(), (String)"AD", (PreferencesHint)ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                resource.getContents().add((Object)diagram);
                resource.getContents().add((Object)diagram.getElement());
                return CommandResult.newOKCommandResult();
            }
        };
        try {
            OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)abstractTransactionalCommand, (IProgressMonitor)new NullProgressMonitor(), null);
            resource.save(UMLDiagramEditorUtil.getSaveOptions());
            UMLDiagramEditorUtil.openDiagram(resource);
        }
        catch (ExecutionException executionException) {
            ActivityDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", executionException);
        }
        catch (IOException iOException) {
            ActivityDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + uRI, iOException);
        }
        catch (PartInitException partInitException) {
            ActivityDiagramEditorPlugin.getInstance().logError("Unable to open editor", partInitException);
        }
        return true;
    }

    private static class DiagramRootElementSelectionPage
    extends ModelElementSelectionPage {
        protected DiagramRootElementSelectionPage(String string) {
            super(string);
        }

        protected String getSelectionTitle() {
            return Messages.UMLNewDiagramFileWizard_RootSelectionPageSelectionTitle;
        }

        protected boolean validatePage() {
            if (this.selectedModelElement == null) {
                this.setErrorMessage(Messages.UMLNewDiagramFileWizard_RootSelectionPageNoSelectionMessage);
                return false;
            }
            boolean bl = ViewService.getInstance().provides((IOperation)new CreateDiagramViewOperation((IAdaptable)new EObjectAdapter(this.selectedModelElement), "AD", ActivityDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT));
            this.setErrorMessage(bl ? null : Messages.UMLNewDiagramFileWizard_RootSelectionPageInvalidSelectionMessage);
            return bl;
        }
    }
}

