/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.verifier;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.StorageHook;
import org.eclipse.osgi.framework.util.KeyedElement;
import org.eclipse.osgi.internal.provisional.verifier.CertificateChain;
import org.eclipse.osgi.internal.verifier.PKCS7Processor;
import org.eclipse.osgi.internal.verifier.SignedBundleFile;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class SignedStorageHook
implements StorageHook {
    static final String KEY;
    static final int HASHCODE;
    private static final int STORAGE_VERSION = 2;
    private static ArrayList saveChainCache;
    private static long firstIDSaved;
    private static long lastIDSaved;
    private static ArrayList loadChainCache;
    private static long lastIDLoaded;
    private BaseData bundledata;
    SignedBundleFile signedBundleFile;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.osgi.internal.verifier.SignedStorageHook");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        KEY = clazz.getName();
        HASHCODE = KEY.hashCode();
        saveChainCache = new ArrayList(5);
        firstIDSaved = -1L;
        lastIDSaved = -1L;
        loadChainCache = new ArrayList(5);
    }

    public int getStorageVersion() {
        return 2;
    }

    public StorageHook create(BaseData bundledata) throws BundleException {
        SignedStorageHook hook = new SignedStorageHook();
        hook.bundledata = bundledata;
        return hook;
    }

    public void initialize(Dictionary manifest) throws BundleException {
    }

    public StorageHook load(BaseData target, DataInputStream is) throws IOException {
        if (lastIDLoaded > target.getBundleID()) {
            loadChainCache.clear();
        }
        lastIDLoaded = target.getBundleID();
        SignedStorageHook hook = new SignedStorageHook();
        hook.bundledata = target;
        boolean signed = is.readBoolean();
        if (!signed) {
            return hook;
        }
        int numChains = is.readInt();
        CertificateChain[] chains = new CertificateChain[numChains];
        int i = 0;
        while (i < numChains) {
            int chainIdx = is.readInt();
            if (chainIdx >= 0) {
                chains[i] = (CertificateChain)loadChainCache.get(chainIdx);
                if (chains[i] == null) {
                    throw new IOException("Invalid chain cache.");
                }
            } else {
                String chain = is.readUTF();
                boolean trusted = is.readBoolean();
                int numCerts = is.readInt();
                byte[][] certsBytes = new byte[numCerts][];
                int j = 0;
                while (j < certsBytes.length) {
                    int numBytes = is.readInt();
                    certsBytes[j] = new byte[numBytes];
                    is.readFully(certsBytes[j]);
                    ++j;
                }
                long signingTime = is.readLong();
                try {
                    chains[i] = new PKCS7Processor(chain, trusted, certsBytes, signingTime);
                }
                catch (CertificateException e) {
                    throw new IOException(e.getMessage());
                }
                loadChainCache.add(chains[i]);
            }
            ++i;
        }
        int numEntries = is.readInt();
        Hashtable<String, String> digests = null;
        Hashtable<String, byte[]> results = null;
        if (numEntries >= 0) {
            digests = new Hashtable<String, String>(numEntries);
            results = new Hashtable<String, byte[]>(numEntries);
            int i2 = 0;
            while (i2 < numEntries) {
                String entry = is.readUTF();
                String md = is.readInt() == 0 ? "MD5" : "SHA1";
                byte[] result = new byte[is.readInt()];
                is.readFully(result);
                digests.put(entry, md);
                results.put(entry, result);
                ++i2;
            }
        }
        String md5Result = null;
        String shaResult = null;
        if (is.readBoolean()) {
            md5Result = is.readUTF();
        }
        if (is.readBoolean()) {
            shaResult = is.readUTF();
        }
        hook.signedBundleFile = new SignedBundleFile(chains, digests, results, md5Result, shaResult);
        return hook;
    }

    public void save(DataOutputStream os) throws IOException {
        this.getFirstLastID();
        if (firstIDSaved == this.bundledata.getBundleID()) {
            saveChainCache.clear();
        }
        if (lastIDSaved == this.bundledata.getBundleID()) {
            lastIDSaved = -1L;
            firstIDSaved = -1L;
        }
        BundleFile bundleFile = this.bundledata.getBundleFile();
        CertificateChain[] chains = null;
        String md5Result = null;
        String shaResult = null;
        Hashtable digests = null;
        Hashtable results = null;
        if (bundleFile instanceof SignedBundleFile) {
            SignedBundleFile signedFile = (SignedBundleFile)bundleFile;
            chains = signedFile.chains;
            md5Result = signedFile.manifestMD5Result;
            shaResult = signedFile.manifestSHAResult;
            digests = signedFile.digests4entries;
            results = signedFile.results4entries;
        }
        os.writeBoolean(chains != null);
        if (chains == null) {
            return;
        }
        os.writeInt(chains.length);
        int i = 0;
        while (i < chains.length) {
            int cacheIdx = saveChainCache.indexOf(chains[i]);
            os.writeInt(cacheIdx);
            if (cacheIdx < 0) {
                saveChainCache.add(chains[i]);
                os.writeUTF(chains[i].getChain());
                os.writeBoolean(chains[i].isTrusted());
                Certificate[] certs = chains[i].getCertificates();
                os.writeInt(certs == null ? 0 : certs.length);
                if (certs != null) {
                    int j = 0;
                    while (j < certs.length) {
                        byte[] certBytes;
                        try {
                            certBytes = certs[j].getEncoded();
                        }
                        catch (CertificateEncodingException e) {
                            throw new IOException(e.getMessage());
                        }
                        os.writeInt(certBytes.length);
                        os.write(certBytes);
                        ++j;
                    }
                }
                os.writeLong(chains[i].getSigningTime() != null ? chains[i].getSigningTime().getTime() : Long.MIN_VALUE);
            }
            ++i;
        }
        if (digests == null) {
            os.writeInt(-1);
        } else {
            os.writeInt(digests.size());
            Enumeration entries = digests.keys();
            while (entries.hasMoreElements()) {
                String entry = (String)entries.nextElement();
                String md = (String)digests.get(entry);
                byte[] result = (byte[])results.get(entry);
                os.writeUTF(entry);
                if (md == "MD2") {
                    os.writeInt(0);
                } else {
                    os.writeInt(1);
                }
                os.writeInt(result.length);
                os.write(result);
            }
        }
        os.writeBoolean(md5Result != null);
        if (md5Result != null) {
            os.writeUTF(md5Result);
        }
        os.writeBoolean(shaResult != null);
        if (shaResult != null) {
            os.writeUTF(shaResult);
        }
    }

    private void getFirstLastID() {
        if (firstIDSaved >= 0L) {
            return;
        }
        Bundle[] bundles = this.bundledata.getAdaptor().getContext().getBundles();
        if (bundles.length > 1) {
            firstIDSaved = bundles[1].getBundleId();
            lastIDSaved = bundles[bundles.length - 1].getBundleId();
        }
    }

    public void copy(StorageHook storageHook) {
    }

    public void validate() throws IllegalArgumentException {
    }

    public Dictionary getManifest(boolean firstLoad) throws BundleException {
        return null;
    }

    public boolean forgetStatusChange(int status) {
        return false;
    }

    public boolean forgetStartLevelChange(int startlevel) {
        return false;
    }

    public boolean matchDNChain(String pattern) {
        BundleFile base = this.bundledata.getBundleFile();
        if (!(base instanceof SignedBundleFile)) {
            return false;
        }
        return ((SignedBundleFile)base).matchDNChain(pattern);
    }

    public int getKeyHashCode() {
        return HASHCODE;
    }

    public boolean compare(KeyedElement other) {
        return other.getKey() == KEY;
    }

    public Object getKey() {
        return KEY;
    }
}

