/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.validation.constraints;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.validation.service.AbstractTraversalStrategy;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryTraversalStrategy
extends AbstractTraversalStrategy {
    public static final String TRAVERSAL_TYPE = "TRAVERSAL_TYPE";
    public static final int SHADOW = 0;
    public static final int DEEP = 1;
    public static final ITraversalStrategy deepTraversalStrategy = new LibraryTraversalStrategy(1);
    private Collection roots;
    private boolean contextChanged = true;
    private int type = 1;

    public static int countElements(Collection collection, int n) {
        return LibraryTraversalStrategy.countElements(collection, true, n);
    }

    private static int countElements(Collection collection, boolean bl, int n) {
        int n2 = 0;
        LibraryIterator libraryIterator = new LibraryIterator(collection, true, n, bl);
        while (libraryIterator.hasNext()) {
            libraryIterator.next();
            ++n2;
        }
        return n2;
    }

    public LibraryTraversalStrategy() {
    }

    public LibraryTraversalStrategy(int n) {
        this.type = n;
    }

    public void startTraversal(Collection collection, IProgressMonitor iProgressMonitor) {
        this.roots = LibraryTraversalStrategy.makeTargetsDisjoint(collection);
        super.startTraversal(collection, iProgressMonitor);
    }

    private Collection getRoots() {
        return this.roots;
    }

    protected int countElements(Collection collection) {
        return LibraryTraversalStrategy.countElements(this.getRoots(), false, this.type);
    }

    protected Iterator createIterator(Collection collection) {
        return new LibraryIterator(this.getRoots(), true, this.type, false){
            private static final long serialVersionUID = -5653134989235663973L;

            public Iterator getChildren(Object object) {
                if (object == LibraryTraversalStrategy.this.getRoots()) {
                    return new Iterator(){
                        private final Iterator delegate;
                        {
                            this.delegate = LibraryTraversalStrategy.this.getRoots().iterator();
                        }

                        public boolean hasNext() {
                            return this.delegate.hasNext();
                        }

                        public Object next() {
                            LibraryTraversalStrategy.this.contextChanged = true;
                            return this.delegate.next();
                        }

                        public void remove() {
                            this.delegate.remove();
                        }
                    };
                }
                return super.getChildren(object);
            }

            public Object next() {
                LibraryTraversalStrategy.this.contextChanged = false;
                return super.next();
            }
        };
    }

    public boolean isClientContextChanged() {
        return this.contextChanged;
    }

    public static Set makeTargetsDisjoint(Collection collection) {
        HashSet<EObject> hashSet = new HashSet<EObject>();
        for (EObject eObject : collection) {
            for (EObject eObject2 : hashSet) {
                if (!EcoreUtil.isAncestor((EObject)eObject2, (EObject)eObject)) continue;
                eObject = null;
                break;
            }
            if (eObject == null) continue;
            hashSet.add(eObject);
        }
        return hashSet;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LibraryIterator
    extends EcoreUtil.ContentTreeIterator {
        private static final long serialVersionUID = -1175428027503440970L;
        private int traversalType = 1;

        protected LibraryIterator(Collection collection) {
            super(collection);
        }

        public LibraryIterator(Collection collection, boolean bl, int n, boolean bl2) {
            super((Object)(bl2 ? LibraryTraversalStrategy.makeTargetsDisjoint(collection) : collection), bl);
            this.traversalType = n;
        }

        protected Iterator<?> getEObjectChildren(EObject eObject) {
            if (this.traversalType == 1) {
                if (!(eObject instanceof MethodElement) || eObject instanceof Constraint || eObject instanceof DiagramElement) {
                    return Collections.EMPTY_LIST.iterator();
                }
                return super.getEObjectChildren(eObject);
            }
            if (eObject instanceof CustomCategory) {
                return this.getEObjectChildren((EObject)((CustomCategory)eObject), UmaPackage.Literals.CUSTOM_CATEGORY__CATEGORIZED_ELEMENTS, UmaPackage.Literals.CUSTOM_CATEGORY);
            }
            if (eObject instanceof ProcessComponent || eObject instanceof MethodConfiguration || eObject instanceof ContentElement) {
                return Collections.EMPTY_LIST.iterator();
            }
            if (eObject instanceof MethodPackage) {
                MethodPackage methodPackage = (MethodPackage)eObject;
                if (TngUtil.isPredefined((MethodElement)methodPackage) && "CustomCategories".equals(methodPackage.getName())) {
                    ContentPackage contentPackage = UmaUtil.findContentPackage((List)methodPackage.getChildPackages(), (String)"Hidden");
                    if (contentPackage != null && !contentPackage.getContentElements().isEmpty()) {
                        return contentPackage.getContentElements().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
                return this.getEObjectChildren((EObject)methodPackage, UmaPackage.Literals.METHOD_PACKAGE__CHILD_PACKAGES, null);
            }
            if (eObject instanceof MethodLibrary) {
                return this.getEObjectChildren((EObject)((MethodLibrary)eObject), new EStructuralFeature[]{UmaPackage.Literals.METHOD_LIBRARY__METHOD_PLUGINS, UmaPackage.Literals.METHOD_LIBRARY__PREDEFINED_CONFIGURATIONS});
            }
            if (eObject instanceof MethodPlugin) {
                return this.getEObjectChildren(eObject, UmaPackage.Literals.METHOD_PLUGIN__METHOD_PACKAGES, null);
            }
            if (eObject == this.object) {
                return ((Collection)eObject).iterator();
            }
            return Collections.EMPTY_LIST.iterator();
        }

        private Iterator getEObjectChildren(EObject eObject, EStructuralFeature[] eStructuralFeatureArray) {
            EContentsEList eContentsEList = new EContentsEList(eObject, eStructuralFeatureArray);
            return this.isResolveProxies() ? eContentsEList.iterator() : eContentsEList.basicIterator();
        }

        private Iterator getEObjectChildren(EObject eObject, EReference eReference, EClass eClass) {
            Iterator<Object> iterator;
            Object object;
            if (eReference.isMany()) {
                boolean bl = this.isResolveProxies();
                object = (List)eObject.eGet((EStructuralFeature)eReference, bl);
                iterator = !bl && object instanceof InternalEList ? ((InternalEList)object).basicIterator() : object.iterator();
            } else {
                Object object2 = eObject.eGet((EStructuralFeature)eReference, this.isResolveProxies());
                Iterator<Object> iterator2 = iterator = object2 != null ? Collections.singletonList(object2).iterator() : Collections.EMPTY_LIST.iterator();
            }
            if (eClass == null) {
                return iterator;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (!eClass.isInstance(object)) continue;
                arrayList.add(object);
            }
            if (arrayList.isEmpty()) {
                return Collections.EMPTY_LIST.iterator();
            }
            return arrayList.iterator();
        }
    }
}

