/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IAddMemoryRenderingsTarget;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.memory.IMemoryRenderingType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class AddMemoryRenderingActionDelegate
extends Action
implements IViewActionDelegate,
IEditorActionDelegate,
IObjectActionDelegate,
IActionDelegate2 {
    private IAction fAction;
    private IWorkbenchPart fPart;
    private ISelection fCurrentSelection;
    private IAddMemoryRenderingsTarget fActionDelegate;
    private IMenuCreator fMenuCreator;
    private IAdaptable fDebugContext;
    private IWorkbenchWindow fWindow;
    private DebugContextListener fDebugContextListener = new DebugContextListener();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    private void setupActionDelegate(ISelection context) {
        IMemoryBlockRetrieval retrieval;
        IAdaptable debugContext = null;
        if (context instanceof IStructuredSelection && ((IStructuredSelection)context).getFirstElement() instanceof IAdaptable) {
            debugContext = (IAdaptable)((IStructuredSelection)context).getFirstElement();
        }
        if (debugContext == null) {
            this.fActionDelegate = null;
        }
        if (debugContext == this.fDebugContext) {
            return;
        }
        this.fDebugContext = debugContext;
        if (this.fDebugContext == null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IMemoryBlockRetrieval");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((retrieval = (IMemoryBlockRetrieval)this.fDebugContext.getAdapter((Class)clazz)) == null && this.fDebugContext instanceof IDebugElement) {
            retrieval = ((IDebugElement)this.fDebugContext).getDebugTarget();
        }
        if (retrieval == null) {
            return;
        }
        IAddMemoryRenderingsTarget target = null;
        if (this.fCurrentSelection instanceof IStructuredSelection) {
            IStructuredSelection strucSel = (IStructuredSelection)this.fCurrentSelection;
            Object obj = strucSel.getFirstElement();
            target = this.getAddMemoryRenderingTarget(obj);
        }
        if (target == null) {
            target = this.getAddMemoryRenderingTarget(this.fDebugContext);
        }
        if (target == null) {
            target = this.getAddMemoryRenderingTarget(retrieval);
        }
        this.fActionDelegate = target;
    }

    public void init(IViewPart view) {
        this.bindPart((IWorkbenchPart)view);
    }

    public void run(IAction action) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.bindAction(action);
        this.fCurrentSelection = selection;
        this.updateAction(action, selection);
    }

    private void updateAction(IAction action, ISelection selection) {
        if (this.fActionDelegate != null) {
            action.setEnabled(this.fActionDelegate.canAddMemoryRenderings(this.fPart, selection));
            this.bindAction(action);
        } else {
            action.setEnabled(false);
        }
    }

    private void bindAction(IAction action) {
        if (action == null) {
            return;
        }
        if (action != this.fAction) {
            if (this.fMenuCreator == null) {
                this.fMenuCreator = new AddMemoryRenderingMenuCreator();
            }
            action.setMenuCreator(this.fMenuCreator);
            this.fAction = action;
        }
    }

    private IAddMemoryRenderingsTarget getAddMemoryRenderingTarget(Object elmt) {
        IAddMemoryRenderingsTarget target = null;
        if (elmt instanceof IAddMemoryRenderingsTarget) {
            target = (IAddMemoryRenderingsTarget)elmt;
        } else if (elmt instanceof IAdaptable) {
            IAdaptable iAdaptable = (IAdaptable)elmt;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.debug.ui.actions.IAddMemoryRenderingsTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            target = (IAddMemoryRenderingsTarget)iAdaptable.getAdapter((Class)clazz);
        }
        return target;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.bindPart((IWorkbenchPart)targetEditor);
        this.bindAction(action);
        this.updateAction(action, this.fCurrentSelection);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.bindPart(targetPart);
        this.bindAction(action);
        this.updateAction(action, this.fCurrentSelection);
    }

    public void init(IAction action) {
        this.bindAction(action);
        if (action != null) {
            action.setText(ActionMessages.AddMemoryRenderingActionDelegate_2);
            action.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_MONITOR_EXPRESSION"));
            action.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_MONITOR_EXPRESSION"));
            action.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_MONITOR_EXPRESSION"));
        }
    }

    public void dispose() {
        this.fAction = null;
        this.fPart = null;
        this.fCurrentSelection = null;
        this.fActionDelegate = null;
        this.bindPart(null);
    }

    public void runWithEvent(IAction action, Event event) {
    }

    private void bindPart(IWorkbenchPart part) {
        IWorkbenchWindow window = null;
        if (part != null) {
            window = part.getSite().getWorkbenchWindow();
        }
        if (window != this.fWindow) {
            if (this.fWindow != null) {
                DebugUITools.getDebugContextManager().getContextService(this.fWindow).removeDebugContextListener(this.fDebugContextListener);
            }
            if (window != null) {
                DebugUITools.getDebugContextManager().getContextService(window).addDebugContextListener(this.fDebugContextListener);
            }
            this.fWindow = window;
        }
        if (part != this.fPart) {
            this.fPart = part;
        }
        if (this.fWindow != null) {
            this.setupActionDelegate(DebugUITools.getDebugContextManager().getContextService(this.fWindow).getActiveContext());
        }
    }

    private class AddMemoryRenderingAction
    extends Action {
        private IMemoryRenderingType fRenderingType;

        AddMemoryRenderingAction(IMemoryRenderingType renderingType) {
            super(renderingType.getLabel());
            this.fRenderingType = renderingType;
        }

        public void runWithEvent(Event event) {
            if (AddMemoryRenderingActionDelegate.this.fActionDelegate != null) {
                try {
                    AddMemoryRenderingActionDelegate.this.fActionDelegate.addMemoryRenderings(AddMemoryRenderingActionDelegate.this.fPart, AddMemoryRenderingActionDelegate.this.fCurrentSelection, new IMemoryRenderingType[]{this.fRenderingType});
                }
                catch (CoreException e) {
                    DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.AddMemoryRenderingActionDelegate_0, ActionMessages.AddMemoryRenderingActionDelegate_1, e);
                }
            }
        }
    }

    private class AddMemoryRenderingMenuCreator
    implements IMenuCreator {
        private AddMemoryRenderingMenuCreator() {
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            return null;
        }

        public Menu getMenu(Menu parent) {
            Menu menu = new Menu(parent);
            menu.addMenuListener((MenuListener)new MenuAdapter(this){
                final /* synthetic */ AddMemoryRenderingMenuCreator this$1;
                {
                    this.this$1 = addMemoryRenderingMenuCreator;
                }

                public void menuShown(MenuEvent e) {
                    Menu m = (Menu)e.widget;
                    MenuItem[] items = m.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].dispose();
                        ++i;
                    }
                    AddMemoryRenderingMenuCreator.access$0(this.this$1, m);
                }
            });
            return menu;
        }

        private void fillMenu(Menu parent) {
            if (AddMemoryRenderingActionDelegate.this.fActionDelegate != null) {
                IMemoryRenderingType[] types = AddMemoryRenderingActionDelegate.this.fActionDelegate.getMemoryRenderingTypes(AddMemoryRenderingActionDelegate.this.fPart, AddMemoryRenderingActionDelegate.this.fCurrentSelection);
                int i = 0;
                while (i < types.length) {
                    AddMemoryRenderingAction action = new AddMemoryRenderingAction(types[i]);
                    ActionContributionItem item = new ActionContributionItem((IAction)action);
                    item.fill(parent, -1);
                    ++i;
                }
            }
        }

        static /* synthetic */ void access$0(AddMemoryRenderingMenuCreator addMemoryRenderingMenuCreator, Menu menu) {
            addMemoryRenderingMenuCreator.fillMenu(menu);
        }
    }

    private class DebugContextListener
    implements IDebugContextListener {
        private DebugContextListener() {
        }

        private void contextActivated(ISelection selection) {
            AddMemoryRenderingActionDelegate.this.setupActionDelegate(selection);
            AddMemoryRenderingActionDelegate.this.updateAction(AddMemoryRenderingActionDelegate.this.fAction, AddMemoryRenderingActionDelegate.this.fCurrentSelection);
        }

        public void debugContextChanged(DebugContextEvent event) {
            this.contextActivated(event.getContext());
        }
    }
}

