/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit;

import java.util.Comparator;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;

public class PresentationContext {
    public static final PresentationContext INSTANCE = new PresentationContext();
    private boolean showPresentationNames = false;
    private Comparator comparator = Comparators.DEFAULT_COMPARATOR;
    private Comparator reverseComparator = Comparators.REVERSE_DEFAULT_COMPARATOR;
    private Comparator methodElementTypeComparator = Comparators.METHOD_TYPE_COMPARATOR;
    private Comparator guidanceTypeComparator = new Comparators.TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.this.comparator;
        }

        protected int getOrderId(Object object) {
            if (object instanceof Guidance) {
                int n = ((Guidance)object).eClass().getClassifierID();
                if (n == 82) {
                    n = Integer.MAX_VALUE;
                }
                return n;
            }
            return -1;
        }
    };
    private Comparator processPackageComparator = new Comparators.TypeComparator(){

        protected Comparator getDefaultComparator() {
            return PresentationContext.this.comparator;
        }

        protected int getOrderId(Object object) {
            if (object instanceof ProcessComponent) {
                return Integer.MAX_VALUE;
            }
            if (object instanceof ProcessPackage) {
                return 0;
            }
            return -1;
        }
    };

    private PresentationContext() {
    }

    public boolean isShowPresentationNames() {
        return this.showPresentationNames;
    }

    public void setShowPresentationNames(boolean bl) {
        this.showPresentationNames = bl;
        this.comparator = bl ? Comparators.PRESENTATION_NAME_COMPARATOR : Comparators.DEFAULT_COMPARATOR;
        this.reverseComparator = bl ? Comparators.REVERSE_PRESENTATION_NAME_COMPARATOR : Comparators.REVERSE_DEFAULT_COMPARATOR;
        this.methodElementTypeComparator = bl ? Comparators.METHOD_TYPE_PRES_NAME_COMPARATOR : Comparators.METHOD_TYPE_COMPARATOR;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public Comparator getReverseComparator() {
        return this.reverseComparator;
    }

    public Comparator getGuidanceTypeComparator() {
        return this.guidanceTypeComparator;
    }

    public Comparator getProcessPackageComparator() {
        return this.processPackageComparator;
    }

    public Comparator getMethodElementTypeComparator() {
        return this.methodElementTypeComparator;
    }

    public Comparator getPresNameComparator() {
        return Comparators.PRESENTATION_NAME_COMPARATOR;
    }

    public Comparator getPresNameReverseComparator() {
        return Comparators.REVERSE_PRESENTATION_NAME_COMPARATOR;
    }

    public Comparator getPresNameMethodElementTypeComparator() {
        return Comparators.METHOD_TYPE_PRES_NAME_COMPARATOR;
    }
}

