/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class MethodConfigurationElementList {
    private MethodConfiguration methodConfig;
    private List filterList;

    public MethodConfigurationElementList(MethodConfiguration methodConfiguration, List list) {
        this.methodConfig = methodConfiguration;
        this.filterList = list;
    }

    protected boolean checkAcceptance() {
        return true;
    }

    protected boolean accept(Object object) {
        int n = this.filterList.size();
        int n2 = 0;
        while (n2 < n) {
            IFilter iFilter = (IFilter)this.filterList.get(n2);
            if (!iFilter.accept(object)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    protected Iterator newIterator(ContentPackage contentPackage) {
        return new ElementIterator(contentPackage);
    }

    private void getAllElements(ContentPackage contentPackage, List list) {
        Iterator iterator = this.newIterator(contentPackage);
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof ContentPackage) continue;
            list.add(e);
        }
    }

    public List getList() {
        ArrayList arrayList = new ArrayList();
        for (MethodPlugin methodPlugin : this.methodConfig.getMethodPluginSelection()) {
            ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
            if (contentPackage == null) continue;
            this.getAllElements(contentPackage, arrayList);
        }
        return arrayList;
    }

    protected class ElementIterator
    extends AbstractTreeIterator {
        private static final long serialVersionUID = -2291438970123985906L;

        protected ElementIterator(ContentPackage contentPackage) {
            super((Object)contentPackage, false);
        }

        protected List getChildrenList(Object object) {
            ArrayList arrayList = new ArrayList();
            if (object instanceof ContentPackage) {
                ContentPackage contentPackage = (ContentPackage)object;
                List list = contentPackage.getChildPackages();
                int n = list.size();
                int n2 = 0;
                while (n2 < n) {
                    Object e = list.get(n2);
                    if (e instanceof ContentPackage && MethodConfigurationElementList.this.methodConfig.getMethodPackageSelection().contains(e)) {
                        arrayList.add(e);
                    }
                    ++n2;
                }
                if (MethodConfigurationElementList.this.checkAcceptance()) {
                    List list2 = contentPackage.getContentElements();
                    n = list2.size();
                    int n3 = 0;
                    while (n3 < n) {
                        Object e = list2.get(n3);
                        if (MethodConfigurationElementList.this.accept(e)) {
                            arrayList.add(e);
                        }
                        ++n3;
                    }
                } else {
                    arrayList.addAll(contentPackage.getContentElements());
                }
            }
            return arrayList;
        }

        protected Iterator getChildren(Object object) {
            return this.getChildrenList(object).iterator();
        }
    }
}

