/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.itemsfilter;

import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterInitializer;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;

public class FilterHelper {
    private String pattern;
    private String type;
    private Pattern regex;
    private String tabStr;
    private Object contentElement;
    private List existingElements = new ArrayList();
    private boolean showPresentationName = false;
    private String contentCategoryTabStr;

    public FilterHelper(Object object, String string, String string2, String string3, List list) {
        this.contentElement = object;
        this.tabStr = string;
        this.type = string3;
        this.existingElements = list;
        this.pattern = string2;
        this.showPresentationName = PresentationContext.INSTANCE.isShowPresentationNames();
    }

    public void setContentCategoryTabStr(String string) {
        this.contentCategoryTabStr = string;
    }

    public String getContentCategoryTabStr() {
        return this.contentCategoryTabStr;
    }

    public List getAlreadySelectedList() {
        return this.existingElements;
    }

    public void setAlreadySelectedList(List list) {
        this.existingElements = list;
    }

    public boolean matchPattern(Object object) {
        return this.match(object);
    }

    private boolean hasMatchedChildCustomCategory(CustomCategory customCategory) {
        List list = customCategory.getCategorizedElements();
        for (Object e : list) {
            if (!(e instanceof CustomCategory)) continue;
            CustomCategory customCategory2 = (CustomCategory)e;
            if (this.matcher(customCategory2)) {
                return true;
            }
            if (!this.hasMatchedChildCustomCategory(customCategory2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedArtifact(Artifact artifact) {
        List list = artifact.getContainedArtifacts();
        for (Object e : list) {
            if (!(e instanceof Artifact)) continue;
            Artifact artifact2 = (Artifact)e;
            if (this.matcher(artifact2)) {
                return true;
            }
            if (!this.hasMatchedArtifact(artifact2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedArtifact(Artifact artifact, List list) {
        List list2 = artifact.getContainedArtifacts();
        for (Object e : list2) {
            Artifact artifact2;
            if (!(e instanceof Artifact) || list.contains(artifact2 = (Artifact)e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedChild(ContentPackage contentPackage) {
        for (Object e : contentPackage.getChildPackages()) {
            if (!(e instanceof ContentPackage)) continue;
            ContentPackage contentPackage2 = (ContentPackage)e;
            if (this.matcher(contentPackage2)) {
                return true;
            }
            if (!this.hasMatchedChild(contentPackage2)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedSubDomains(Domain domain) {
        List list = domain.getSubdomains();
        for (Object e : list) {
            if (this.matcher(e)) {
                return true;
            }
            if (!this.hasMatchedSubDomains((Domain)e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedSubDiscipline(Discipline discipline) {
        List list = discipline.getSubdiscipline();
        for (Object e : list) {
            if (this.matcher(e)) {
                return true;
            }
            if (!this.hasMatchedSubDiscipline((Discipline)e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedDisciplines(DisciplineGrouping disciplineGrouping) {
        List list = disciplineGrouping.getDisciplines();
        for (Object e : list) {
            if (this.matcher(e)) {
                return true;
            }
            if (!this.hasMatchedSubDiscipline((Discipline)e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedActivities(Activity activity) {
        List list = activity.getBreakdownElements();
        for (Object e : list) {
            if (!(e instanceof Activity)) continue;
            if (this.matcher(e)) {
                return true;
            }
            if (!this.hasMatchedActivities((Activity)e)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedActivities(ProcessPackage processPackage) {
        List list = processPackage.getProcessElements();
        for (Object e : list) {
            if (!(e instanceof Activity)) continue;
            if (this.matcher(e)) {
                return true;
            }
            if (!this.hasMatchedActivities((Activity)e)) continue;
            return true;
        }
        list = processPackage.getChildPackages();
        for (Object e : list) {
            if (!(e instanceof ProcessPackage) || !this.hasMatchedActivities((ProcessPackage)e)) continue;
            return true;
        }
        return false;
    }

    public String getFilterTypeStr() {
        while (this.type != null && this.type.indexOf("-") > -1 && !this.type.equals(FilterConstants.METHO_PLUGINS)) {
            this.type = this.type.substring(this.type.indexOf("-") + 1, this.type.length());
        }
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getRegexPattern() {
        return this.regex;
    }

    public String getTabStr() {
        return this.tabStr;
    }

    public boolean checkVariability(Object object) {
        VariabilityElement variabilityElement;
        return this.contentElement instanceof ContentElement && (variabilityElement = ((ContentElement)this.contentElement).getVariabilityBasedOnElement()) != null && object.equals(variabilityElement);
    }

    public Object getContentElement() {
        return this.contentElement;
    }

    public void setContentElement(Object object) {
        this.contentElement = object;
    }

    public void setFilterTypeStr(String string) {
        this.type = string;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public void setRegexPattern(Pattern pattern) {
        this.regex = pattern;
    }

    public void setTabStr(String string) {
        this.tabStr = string;
    }

    public String[] getPathBasedOnTabString(String string) {
        if (FilterConstants.contentElementStrs.contains(string)) {
            return ModelStructure.DEFAULT.coreContentPath;
        }
        if (string.equals(FilterConstants.ROLESETS) || string.equals(FilterConstants.ROLE_SET_GROUPINGS)) {
            return ModelStructure.DEFAULT.roleSetPath;
        }
        if (string.equals(FilterConstants.DISCIPLINES) || string.equals(FilterConstants.DISCIPLINE_GROUPINGS)) {
            return ModelStructure.DEFAULT.disciplineDefinitionPath;
        }
        if (string.equals(FilterConstants.TOOLS)) {
            return ModelStructure.DEFAULT.toolPath;
        }
        if (string.equals(FilterConstants.WORKPRODUCTTYPES)) {
            return ModelStructure.DEFAULT.workProductTypePath;
        }
        if (string.equals(FilterConstants.DOMAINS)) {
            return ModelStructure.DEFAULT.domainPath;
        }
        if (string.equals(FilterConstants.CUSTOM_CATEGORIES)) {
            return ModelStructure.DEFAULT.customCategoryPath;
        }
        return ModelStructure.DEFAULT.coreContentPath;
    }

    public boolean checkObjectAccepted(Object object) {
        if (!this.match(object)) {
            return false;
        }
        if (this.getAlreadySelectedList() != null && this.getAlreadySelectedList().contains(object)) {
            if (object instanceof Artifact) {
                if (!this.hasMatchedArtifact((Artifact)object, this.getAlreadySelectedList())) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (this.checkVariability(object)) {
            return false;
        }
        return object instanceof MethodPlugin || this.contentElement == null || !object.equals(this.contentElement);
    }

    public boolean acceptMethodPlugin(Object object) {
        if (this.contentElement != null) {
            return MethodElementUtil.getAllModels(this.contentElement).contains(object);
        }
        return true;
    }

    public boolean acceptContentPackage(Object object) {
        return !((ContentPackage)object).getChildPackages().isEmpty() || !((ContentPackage)object).getContentElements().isEmpty();
    }

    public boolean isObjectInSelectedItems(Object object) {
        return this.getAlreadySelectedList() == null || !this.getAlreadySelectedList().contains(object);
    }

    public boolean isContributor(ContentElement contentElement) {
        return false;
    }

    public boolean matchPatternBasedOnType(Object object) {
        return this.match(object);
    }

    public boolean matchPatternOnPresentationName(Object object) {
        return this.match(object);
    }

    public boolean isShowPresentationName() {
        return this.showPresentationName;
    }

    public void setShowPresentationName(boolean bl) {
        this.showPresentationName = bl;
    }

    private boolean match(Object object) {
        if (this.type == null || this.pattern == null || this.pattern.equalsIgnoreCase("")) {
            return true;
        }
        if (this.type.equals(FilterConstants.CONTENT_PACKAGES)) {
            DataObject dataObject;
            if (object instanceof ContentPackage) {
                return this.matcher(object) || this.hasMatchedChild((ContentPackage)object);
            }
            return !(object instanceof ContentElement) || !((dataObject = ((ContentElement)object).getContainer()) instanceof ContentPackage) || this.matcher(dataObject);
        }
        if (this.type.equals(FilterConstants.METHO_PLUGINS)) {
            if (object instanceof MethodPlugin) {
                return this.matcher(object);
            }
            return true;
        }
        if (this.type.equals(FilterConstants.ACTIVITIES)) {
            if (object instanceof Activity) {
                if (this.matcher(object)) {
                    return true;
                }
                return this.hasMatchedActivities((Activity)object);
            }
            if (object instanceof ProcessPackage) {
                return this.hasMatchedActivities((ProcessPackage)object);
            }
            return true;
        }
        if (this.type != null) {
            if (object instanceof ContentElement || object instanceof ProcessComponent || object instanceof Process) {
                Class clazz;
                if (this.type.indexOf("-") > -1) {
                    this.type = this.type.substring(this.type.indexOf("-"), this.type.length());
                }
                if ((clazz = FilterInitializer.getInstance().getClassForType(this.type)) != null && !clazz.isInstance(object)) {
                    return true;
                }
                if (this.matcher(object)) {
                    return true;
                }
                if (object instanceof CustomCategory) {
                    return this.hasMatchedChildCustomCategory((CustomCategory)object);
                }
                if (object instanceof Artifact) {
                    return this.hasMatchedArtifact((Artifact)object);
                }
                if (object instanceof Domain) {
                    return this.hasMatchedSubDomains((Domain)object);
                }
                if (object instanceof Discipline) {
                    return this.hasMatchedSubDiscipline((Discipline)object);
                }
                if (object instanceof DisciplineGrouping) {
                    return this.hasMatchedDisciplines((DisciplineGrouping)object);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean matcher(Object object) {
        if (this.regex != null) {
            Matcher matcher = this.regex.matcher(((MethodElement)object).getName());
            if (this.showPresentationName && object instanceof DescribableElement && ((DescribableElement)object).getPresentationName() != null) {
                matcher = this.regex.matcher(((DescribableElement)object).getPresentationName());
            }
            return matcher.matches();
        }
        return true;
    }
}

