/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.ComposedBreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TeamProfileWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.OBSDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.AssociationHelper;

public class OBSActivityItemProvider
extends BSActivityItemProvider {
    private Disposable rolledUpWrappers;

    public OBSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createPhase()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createIteration()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createActivity()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createRoleDescriptor()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createTeamProfile()));
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createMilestone()));
    }

    protected boolean acceptAsChild(Object object) {
        if ((object = TngUtil.unwrap(object)) instanceof Activity || object instanceof RoleDescriptor || object instanceof TeamProfile || object instanceof Milestone) {
            return super.acceptAsChild(object);
        }
        return false;
    }

    protected Object getObject(Descriptor descriptor) {
        try {
            return ((RoleDescriptor)descriptor).getRole();
        }
        catch (ClassCastException classCastException) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)classCastException);
            throw classCastException;
        }
    }

    public IResourceAwareCommand createDropCommand(Object object, List list) {
        return new OBSDropCommand((Activity)object, list);
    }

    protected Command createDragAndDropCommand(EditingDomain editingDomain, Object object, float f, int n, int n2, Collection collection) {
        OBSDragAndDropCommand oBSDragAndDropCommand = new OBSDragAndDropCommand(editingDomain, object, f, n, n2, collection);
        return oBSDragAndDropCommand;
    }

    protected boolean isNewDescriptor(List list, Object object) {
        Object object2 = TngUtil.unwrap(object);
        if (object2 instanceof RoleDescriptor) {
            return true;
        }
        return super.isNewDescriptor(list, object2);
    }

    public Collection getChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        if (this.isRolledUp()) {
            Object object2;
            ArrayList arrayList = new ArrayList();
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            HashSet<Object> hashSet = new HashSet<Object>();
            HashSet<Object> hashSet2 = new HashSet<Object>();
            ArrayList<Object> arrayList3 = super.getChildren(object);
            HashSet<Object> hashSet3 = new HashSet<Object>();
            for (Object e : arrayList3) {
                object2 = TngUtil.unwrap(e);
                if (!(object2 instanceof TeamProfile) || !hashSet3.add(object2)) continue;
                arrayList.add(e);
            }
            for (Object e : arrayList3) {
                TeamProfile teamProfile;
                Object object3;
                Object object4;
                Object object5;
                List list;
                Iterator iterator;
                object2 = TngUtil.unwrap(e);
                if (!(object2 instanceof RoleDescriptor)) continue;
                RoleDescriptor roleDescriptor = (RoleDescriptor)object2;
                ArrayList<Role> arrayList4 = null;
                ComposedBreakdownElementWrapperItemProvider composedBreakdownElementWrapperItemProvider = null;
                if (e instanceof RoleDescriptorWrapperItemProvider && (iterator = ((RoleDescriptorWrapperItemProvider)e).getValue()) instanceof ComposedBreakdownElementWrapperItemProvider) {
                    composedBreakdownElementWrapperItemProvider = (ComposedBreakdownElementWrapperItemProvider)((Object)iterator);
                }
                if (composedBreakdownElementWrapperItemProvider != null) {
                    list = new UniqueEList();
                    arrayList4 = new ArrayList<Role>();
                    iterator = composedBreakdownElementWrapperItemProvider.getValues().iterator();
                    while (iterator.hasNext()) {
                        object5 = iterator.next();
                        object4 = TngUtil.unwrap(object5);
                        if (!(object4 instanceof RoleDescriptor)) continue;
                        object3 = AssociationHelper.getTeamProfiles((RoleDescriptor)((RoleDescriptor)object4));
                        teamProfile = object3.iterator();
                        while (teamProfile.hasNext()) {
                            Object e2 = teamProfile.next();
                            if (!list.add(e2)) continue;
                            arrayList4.add((Role)object5);
                        }
                    }
                } else {
                    list = AssociationHelper.getTeamProfiles((RoleDescriptor)roleDescriptor);
                }
                int n = list.size();
                if (n > 1) {
                    if (this.rolledUpWrappers == null) {
                        this.rolledUpWrappers = new Disposable();
                    }
                    boolean bl = false;
                    if (e instanceof BreakdownElementWrapperItemProvider) {
                        bl = ((BreakdownElementWrapperItemProvider)e).isReadOnly();
                    }
                    int n2 = 0;
                    while (n2 < n) {
                        object3 = new TeamRoleDescriptorItemProvider(arrayList4.get(n2), object, this.adapterFactory);
                        ((TeamRoleDescriptorItemProvider)object3).readOnly = bl;
                        teamProfile = (TeamProfile)list.get(n2);
                        ((TeamRoleDescriptorItemProvider)object3).team = teamProfile;
                        this.rolledUpWrappers.add(object3);
                        arrayList2.add(object3);
                        hashSet.add(new RoleTeamPair((Role)this.getObject((Descriptor)roleDescriptor), teamProfile));
                        ++n2;
                    }
                    continue;
                }
                object5 = (Role)this.getObject((Descriptor)roleDescriptor);
                object4 = n == 1 ? list.get(0) : null;
                if (object5 == null) {
                    if (hashSet2.contains(object2)) continue;
                    arrayList2.add(e);
                    hashSet2.add(object2);
                    continue;
                }
                object3 = new RoleTeamPair((Role)object5, (TeamProfile)object4);
                if (hashSet.contains(object3)) continue;
                arrayList2.add(e);
                hashSet.add(object3);
            }
            hashSet.clear();
            hashSet = null;
            Collections.sort(arrayList, Comparators.PRESENTATION_NAME_COMPARATOR);
            Collections.sort(arrayList2, Comparators.PRESENTATION_NAME_COMPARATOR);
            arrayList3 = new ArrayList<Object>(arrayList);
            arrayList3.addAll(arrayList2);
            this.updateCachedChildren(arrayList3);
            return arrayList3;
        }
        Collection collection = super.getChildren(object);
        this.updateCachedChildren(collection);
        return collection;
    }

    public Collection getEClasses() {
        return ProcessUtil.getOBSEclasses();
    }

    private void addTeamProfiles(Object object, Collection collection, TeamProfile teamProfile) {
        if (!TngUtil.checkExist(collection, teamProfile)) {
            TeamProfileWrapperItemProvider teamProfileWrapperItemProvider = new TeamProfileWrapperItemProvider(teamProfile, object, this.adapterFactory){

                public Collection getChildren(Object object) {
                    Collection collection = super.getChildren(object);
                    return collection;
                }
            };
            IBSItemProvider iBSItemProvider = (IBSItemProvider)this.adapterFactory.adapt((Notifier)teamProfile, ITreeItemContentProvider.class);
            teamProfileWrapperItemProvider.readOnly = this.getTopItem() != iBSItemProvider.getTopItem();
            collection.add(teamProfileWrapperItemProvider);
        }
    }

    protected boolean isWrappingRollupNeeded(Object object) {
        if (TngUtil.unwrap(object) instanceof RoleDescriptor) {
            return true;
        }
        return super.isWrappingRollupNeeded(object);
    }

    protected Object createRollupWrapper(Object object, Object object2, AdapterFactory adapterFactory) {
        Object object3 = super.createRollupWrapper(object, object2, adapterFactory);
        return new RoleDescriptorWrapperItemProvider(object3, object2, adapterFactory);
    }

    private static class RoleTeamPair {
        private Role role;
        private TeamProfile team;

        RoleTeamPair(Role role, TeamProfile teamProfile) {
            this.role = role;
            this.team = teamProfile;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof RoleTeamPair) {
                RoleTeamPair roleTeamPair = (RoleTeamPair)object;
                return this.role == roleTeamPair.role && (this.team == roleTeamPair.team || this.team == null && roleTeamPair.team == null);
            }
            return false;
        }

        public int hashCode() {
            String string = this.role.getGuid();
            if (this.team != null) {
                string = String.valueOf(string) + this.team.getGuid();
            }
            return string.hashCode();
        }
    }

    private static class TeamRoleDescriptorItemProvider
    extends RoleDescriptorWrapperItemProvider {
        private TeamProfile team;

        public TeamRoleDescriptorItemProvider(Object object, Object object2, AdapterFactory adapterFactory) {
            super(object, object2, adapterFactory);
        }

        public TeamRoleDescriptorItemProvider(RoleDescriptor roleDescriptor, Object object, AdapterFactory adapterFactory) {
            super(roleDescriptor, object, adapterFactory);
            this.readOnly = false;
        }

        public String getAttribute(Object object, String string) {
            if (string == "teams" && this.team != null) {
                return TngUtil.getPresentationName(this.team);
            }
            return super.getAttribute(object, string);
        }

        protected IWrapperItemProvider createWrapper(Object object, Object object2, AdapterFactory adapterFactory) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)super.createWrapper(object, object2, adapterFactory);
            breakdownElementWrapperItemProvider.readOnly = this.readOnly;
            return breakdownElementWrapperItemProvider;
        }
    }
}

