/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.command.ProcessElementAddCommand;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;

public class ActivityAddCommand
extends ProcessElementAddCommand {
    private List procPackages;

    public ActivityAddCommand(Command command) {
        super(command);
    }

    private Map getCopyToOriginalMap() {
        EditingDomain editingDomain = this.addCommand.getDomain();
        if (editingDomain instanceof TraceableAdapterFactoryEditingDomain) {
            return ((TraceableAdapterFactoryEditingDomain)editingDomain).getCopyToOriginalMap();
        }
        return null;
    }

    private void copyProcessPackages() {
        if (this.procPackages == null && this.hasCopyToOriginalMap()) {
            Collection collection;
            boolean bl = false;
            this.procPackages = new ArrayList();
            ArrayList<Activity> arrayList = new ArrayList<Activity>();
            if (this.addCommand.getCollection() != null && this.addCommand.getCollection().size() > 0 && this.getOriginal(this.addCommand.getCollection().toArray()[0]) != null) {
                for (ArrayList arrayList2 : this.addCommand.getCollection()) {
                    if (!(arrayList2 instanceof Activity)) continue;
                    collection = (Activity)this.getOriginal(arrayList2);
                    if (collection != null) {
                        if (collection.eContainer() == null) continue;
                        this.procPackages.add(collection.eContainer());
                        arrayList.add((Activity)arrayList2);
                        continue;
                    }
                    bl = true;
                }
            }
            if (bl) {
                Messenger.INSTANCE.showWarning(this.getLabel(), LibraryEditResources.ActivityAddCommand_originalNotFoundWarning_msg);
            }
            if (!this.procPackages.isEmpty()) {
                Command command = CopyCommand.create((EditingDomain)this.addCommand.getDomain(), (Collection)this.procPackages);
                try {
                    ArrayList arrayList2;
                    command.execute();
                    arrayList2 = new ArrayList(this.addCommand.getCollection());
                    collection = this.addCommand.getCollection();
                    collection.clear();
                    Collection collection2 = command.getResult();
                    ArrayList arrayList3 = new ArrayList(collection2);
                    for (Object object : arrayList2) {
                        int n = arrayList.indexOf(object);
                        if (n != -1) {
                            ProcessPackage processPackage = (ProcessPackage)arrayList3.get(n);
                            object = this.getActivityCopy(processPackage);
                        }
                        if (object == null) continue;
                        collection.add(object);
                    }
                }
                finally {
                    if (command != null) {
                        command.dispose();
                    }
                }
            }
        }
    }

    private Activity getActivityCopy(ProcessPackage processPackage) {
        if (processPackage instanceof ProcessComponent) {
            Process process = ((ProcessComponent)processPackage).getProcess();
            ProcessPackage processPackage2 = UmaFactory.eINSTANCE.createProcessPackage();
            processPackage2.setName(process.getName());
            processPackage2.getProcessElements().add(process);
            processPackage2.getProcessElements().addAll(processPackage.getProcessElements());
            processPackage2.getDiagrams().addAll(processPackage.getDiagrams());
            processPackage2.getChildPackages().addAll(processPackage.getChildPackages());
            return process;
        }
        for (Object e : processPackage.getProcessElements()) {
            if (!(e instanceof Activity)) continue;
            return (Activity)e;
        }
        return null;
    }

    public void execute() {
        this.prepareAddList();
        this.copyProcessPackages();
        super.execute();
    }

    private static boolean isChildOf(Object object, Object object2) {
        if (object instanceof Activity) {
            Activity activity = (Activity)object;
            for (Object e : activity.getBreakdownElements()) {
                if (object2 == e) {
                    return true;
                }
                if (!ActivityAddCommand.isChildOf(e, object2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isChildOf(Collection collection, Object object) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (!ActivityAddCommand.isChildOf(iterator.next(), object)) continue;
            return true;
        }
        return false;
    }

    private boolean hasCopyToOriginalMap() {
        EditingDomain editingDomain = this.addCommand.getDomain();
        if (editingDomain instanceof TraceableAdapterFactoryEditingDomain) {
            TraceableAdapterFactoryEditingDomain traceableAdapterFactoryEditingDomain = (TraceableAdapterFactoryEditingDomain)editingDomain;
            return traceableAdapterFactoryEditingDomain.getCopyToOriginalMap() != null && !traceableAdapterFactoryEditingDomain.getCopyToOriginalMap().isEmpty() || traceableAdapterFactoryEditingDomain.getClipboardToOriginalMap() != null && !traceableAdapterFactoryEditingDomain.getClipboardToOriginalMap().isEmpty();
        }
        return false;
    }

    private Object getOriginal(Object object) {
        TraceableAdapterFactoryEditingDomain traceableAdapterFactoryEditingDomain = (TraceableAdapterFactoryEditingDomain)this.addCommand.getDomain();
        Object v = traceableAdapterFactoryEditingDomain.getCopyToOriginalMap().get(object);
        if (v == null && traceableAdapterFactoryEditingDomain.getClipboardToOriginalMap() != null) {
            v = traceableAdapterFactoryEditingDomain.getClipboardToOriginalMap().get(object);
        }
        return v;
    }

    private void prepareAddList() {
        if (this.hasCopyToOriginalMap()) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
            for (Object object : this.addCommand.getCollection()) {
                Object object2 = this.getOriginal(object);
                if (object2 == null) continue;
                arrayList.add(object2);
                hashMap.put(object2, object);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Object object2 : arrayList) {
                if (!ActivityAddCommand.isChildOf(arrayList, object2)) continue;
                arrayList2.add(hashMap.get(object2));
            }
            this.addCommand.getCollection().removeAll(arrayList2);
        }
    }
}

