/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.command.CreateCopyCommand;
import org.eclipse.emf.edit.command.InitializeCopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.DescribableElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.ConfigurationSetter;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.library.edit.util.DepthLevelAdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.IDiagramManager;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityDeepCopyCommand
extends CopyCommand {
    private static final AdapterFactory[] adapterFactories = new AdapterFactory[]{TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()};
    private static final int[] diagramTypes;
    protected ProcessPackage pkgCopy;
    protected MethodConfiguration config;
    protected IDiagramManager diagramMgr;
    protected Process targetProcess;
    protected IProgressMonitor monitor;
    protected Activity activity;
    private LinkedList<String> guidList;
    private BreakdownElementWrapperItemProvider wrapper;
    private IConfigurator activityDeepCopyConfigurator;
    private boolean copyExternalVariations = true;
    private boolean copyContributors = true;

    static {
        int[] nArray = new int[3];
        nArray[0] = 2;
        nArray[2] = 1;
        diagramTypes = nArray;
    }

    public static AdapterFactory[] getAdapterFactories() {
        return adapterFactories;
    }

    protected void addCreateCopyCommands(CompoundCommand compoundCommand, EObject eObject) {
        if (this.copyExternalVariations && eObject instanceof ProcessPackage && eObject != this.activity.eContainer()) {
            ProcessPackage processPackage = (ProcessPackage)eObject;
            boolean bl = false;
            Activity activity = null;
            Activity activity2 = null;
            for (Object object : processPackage.getProcessElements()) {
                Activity activity3;
                if (!(object instanceof Activity) || (activity3 = (Activity)object).getSuperActivities() != this.activity) continue;
                activity = this.getReplacer((Activity)object);
                if (activity == null) break;
                bl = true;
                activity2 = (Activity)object;
                break;
            }
            if (bl) {
                Object object;
                this.copyHelper.decrementDeferredInitializationCount();
                object = new ActivityDeepCopyCommand(activity, (CopyHelper)this.copyHelper, this.config, this.targetProcess, this.monitor, false, this.activityDeepCopyConfigurator);
                ((ActivityDeepCopyCommand)((Object)object)).guidList = new LinkedList<String>(this.guidList);
                ((ActivityDeepCopyCommand)((Object)object)).guidList.addAll(ProcessUtil.getGuidList(this.activity, activity2));
                try {
                    ((ActivityDeepCopyCommand)((Object)object)).execute();
                    ProcessPackage processPackage2 = ((ActivityDeepCopyCommand)((Object)object)).pkgCopy;
                    ((CopyHelper)this.copyHelper).basicPut(eObject, (EObject)processPackage2);
                    ((CopyHelper)this.copyHelper).basicPut((EObject)activity2, (EObject)this.copyHelper.get((Object)activity));
                }
                finally {
                    object.dispose();
                }
                this.copyHelper.incrementDeferredInitializationCount();
                return;
            }
        }
        super.addCreateCopyCommands(compoundCommand, eObject);
    }

    protected Activity getReplacer(Activity activity) {
        ConfigurationSetter configurationSetter = new ConfigurationSetter(this.getAdapterFactory());
        try {
            if (this.activityDeepCopyConfigurator != null) {
                MethodConfiguration methodConfiguration = configurationSetter.getOldConfiguration();
                MethodConfiguration methodConfiguration2 = this.config == null ? (methodConfiguration != null ? methodConfiguration : this.targetProcess.getDefaultContext()) : this.config;
                this.activityDeepCopyConfigurator.setMethodConfiguration(methodConfiguration2);
                VariabilityInfo variabilityInfo = this.activityDeepCopyConfigurator.getVariabilityInfo((VariabilityElement)activity);
                if (variabilityInfo != null && !variabilityInfo.getInheritanceList().isEmpty()) {
                    Activity activity2 = (Activity)variabilityInfo.getInheritanceList().get(0);
                    Activity activity3 = activity2 == activity ? null : activity2;
                    return activity3;
                }
            }
            return null;
        }
        finally {
            if (configurationSetter != null) {
                configurationSetter.restore();
            }
        }
    }

    protected List getContributors(Activity activity) {
        ConfigurationSetter configurationSetter = new ConfigurationSetter(this.getAdapterFactory());
        try {
            if (this.activityDeepCopyConfigurator != null) {
                MethodConfiguration methodConfiguration = configurationSetter.getOldConfiguration();
                MethodConfiguration methodConfiguration2 = this.config == null ? (methodConfiguration != null ? methodConfiguration : this.targetProcess.getDefaultContext()) : this.config;
                this.activityDeepCopyConfigurator.setMethodConfiguration(methodConfiguration2);
                VariabilityInfo variabilityInfo = this.activityDeepCopyConfigurator.getVariabilityInfo((VariabilityElement)activity);
                if (variabilityInfo != null) {
                    List list = variabilityInfo.getContributors();
                    return list;
                }
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (configurationSetter != null) {
                configurationSetter.restore();
            }
        }
    }

    private ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration methodConfiguration, Process process, IProgressMonitor iProgressMonitor, boolean bl, IConfigurator iConfigurator) {
        super(null, activity.eContainer(), (CopyCommand.Helper)copyHelper);
        Assert.isTrue((boolean)(activity.eContainer() instanceof ProcessPackage), (String)"Activity's container must be a ProcessPackage");
        this.activity = activity;
        this.domain = new EditingDomain();
        this.config = methodConfiguration;
        this.targetProcess = process;
        this.diagramMgr = ExtensionManager.getDiagramManager();
        Assert.isNotNull((Object)this.diagramMgr, (String)"Could not load diagram manager");
        this.monitor = iProgressMonitor;
        if (bl) {
            this.guidList = ProcessUtil.getGuidList(null, this.activity);
        }
        this.activityDeepCopyConfigurator = iConfigurator;
    }

    public ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration methodConfiguration, Process process, IProgressMonitor iProgressMonitor, IConfigurator iConfigurator) {
        this(activity, copyHelper, methodConfiguration, process, iProgressMonitor, true, iConfigurator);
    }

    public ActivityDeepCopyCommand(Object object, CopyHelper copyHelper, MethodConfiguration methodConfiguration, Process process, IProgressMonitor iProgressMonitor, IConfigurator iConfigurator) {
        this((Activity)TngUtil.unwrap(object), copyHelper, methodConfiguration, process, iProgressMonitor, object instanceof Activity, iConfigurator);
        if (object instanceof BreakdownElementWrapperItemProvider) {
            this.wrapper = (BreakdownElementWrapperItemProvider)object;
            this.guidList = ProcessUtil.getGuidList(this.wrapper);
        }
    }

    public void setCopyExternalVariations(boolean bl) {
        this.copyExternalVariations = bl;
    }

    public AdapterFactory getAdapterFactory() {
        return ((AdapterFactoryEditingDomain)this.domain).getAdapterFactory();
    }

    public void execute() {
        this.monitor.subTask(NLS.bind((String)LibraryEditResources.copyingActivities_msg, (Object)ProcessUtil.getPresentationName((BreakdownElement)this.activity)));
        super.execute();
        Collection collection = super.getResult();
        if (!collection.isEmpty()) {
            this.pkgCopy = (ProcessPackage)collection.iterator().next();
            this.fixProcessComponent();
            this.replaceTextReferences();
        }
    }

    protected void fixProcessComponent() {
        if (this.pkgCopy instanceof ProcessComponent) {
            ProcessPackage processPackage = UmaFactory.eINSTANCE.createProcessPackage();
            ArrayList arrayList = new ArrayList(this.pkgCopy.eClass().getEAllStructuralFeatures());
            arrayList.retainAll((Collection<?>)processPackage.eClass().getEAllStructuralFeatures());
            for (EStructuralFeature eStructuralFeature : arrayList) {
                Object object = this.pkgCopy.eGet(eStructuralFeature);
                processPackage.eSet(eStructuralFeature, object);
            }
            Process process = ((ProcessComponent)this.pkgCopy).getProcess();
            if (process != null) {
                processPackage.getProcessElements().add(0, process);
            }
            this.pkgCopy = processPackage;
        }
    }

    protected void replaceTextReferences() {
        ITextReferenceReplacer iTextReferenceReplacer = ExtensionManager.getTextReferenceReplacer();
        if (iTextReferenceReplacer == null) {
            return;
        }
        Map map = ((CopyHelper)this.copyHelper).getObjectToCopyMap();
        TreeIterator treeIterator = this.pkgCopy.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
                String string;
                if (!eAttribute.isChangeable() || eAttribute.isDerived() || !eAttribute.isMany() && !eObject.eIsSet((EStructuralFeature)eAttribute) || eAttribute.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass() || (string = (String)eObject.eGet((EStructuralFeature)eAttribute)) == null) continue;
                string = iTextReferenceReplacer.replace(string, (EObject)this.targetProcess, map);
                eObject.eSet((EStructuralFeature)eAttribute, (Object)string);
            }
        }
    }

    public Collection<?> getResult() {
        Activity activity;
        if (this.pkgCopy != null && (activity = ProcessUtil.findActivity(this.pkgCopy)) != null) {
            return Collections.singletonList(activity);
        }
        return Collections.EMPTY_LIST;
    }

    private static void moveContent(ProcessPackage processPackage, Activity activity) {
        ProcessPackage processPackage2 = (ProcessPackage)activity.eContainer();
        for (EObject eObject : new ArrayList(processPackage.eContents())) {
            EStructuralFeature eStructuralFeature = eObject.eContainingFeature();
            if (!eStructuralFeature.isMany()) continue;
            ((List)processPackage2.eGet(eStructuralFeature)).add(eObject);
        }
        if (processPackage instanceof ProcessComponent) {
            Process process = ((ProcessComponent)processPackage).getProcess();
            processPackage2.getProcessElements().add(process);
        }
    }

    private static BreakdownElement getTopElement(BreakdownElement breakdownElement) {
        if (breakdownElement == null) {
            return null;
        }
        BreakdownElement breakdownElement2 = breakdownElement;
        Activity activity = breakdownElement.getSuperActivities();
        while (activity != null) {
            breakdownElement2 = activity;
            activity = activity.getSuperActivities();
        }
        return breakdownElement2;
    }

    public void copySuppressionStates() {
        Collection<?> collection = this.getResult();
        if (collection.isEmpty()) {
            return;
        }
        String string = this.wrapper != null ? ProcessUtil.toGuidPath(this.guidList) : null;
        int n = 0;
        while (n < adapterFactories.length) {
            AdapterFactory adapterFactory = adapterFactories[n];
            boolean bl = adapterFactory == TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            IFilter iFilter = ProcessUtil.getFilter(adapterFactory);
            IConfigurator iConfigurator = null;
            MethodConfiguration methodConfiguration = null;
            if (iFilter instanceof IConfigurator) {
                iConfigurator = (IConfigurator)iFilter;
                methodConfiguration = iConfigurator.getMethodConfiguration();
                iConfigurator.setMethodConfiguration(this.config);
            }
            try {
                Object object;
                Object object2;
                Object object3;
                Object object5;
                Object object6;
                Activity activity = ProcessUtil.findActivity((ProcessPackage)this.owner);
                ProcessUtil.initializeItemProviderPath(activity, adapterFactory);
                Process process = TngUtil.getOwningProcess((BreakdownElement)activity);
                Suppression suppression = Suppression.getSuppression(process);
                DepthLevelAdapterFactoryTreeIterator<Process> depthLevelAdapterFactoryTreeIterator = new DepthLevelAdapterFactoryTreeIterator<Process>(adapterFactory, process);
                int n2 = -1;
                while (depthLevelAdapterFactoryTreeIterator.hasNext()) {
                    object6 = depthLevelAdapterFactoryTreeIterator.next();
                    if (this.wrapper == null) {
                        if (object6 != this.activity) continue;
                        n2 = depthLevelAdapterFactoryTreeIterator.getDepthLevel();
                        break;
                    }
                    if (!(object6 instanceof BreakdownElementWrapperItemProvider) || !string.equals(object5 = Suppression.getPathWithoutViewType((BreakdownElementWrapperItemProvider)object6).toString())) continue;
                    n2 = depthLevelAdapterFactoryTreeIterator.getDepthLevel();
                    break;
                }
                object6 = (CopyHelper)this.copyHelper;
                object5 = ((CopyHelper)((Object)object6)).getObjectToCopyMap();
                HashMap<BreakdownElementWrapperItemProvider, Object> hashMap = null;
                if (bl) {
                    hashMap = new HashMap<BreakdownElementWrapperItemProvider, Object>();
                    Activity activity2 = (Activity)collection.iterator().next();
                    hashMap.put(this.wrapper != null ? this.wrapper : this.activity, activity2);
                }
                while (depthLevelAdapterFactoryTreeIterator.hasNext()) {
                    Process process2 = depthLevelAdapterFactoryTreeIterator.next();
                    if (depthLevelAdapterFactoryTreeIterator.getDepthLevel() <= n2) break;
                    Object object4 = TngUtil.unwrap(process2);
                    if (!(object4 instanceof BreakdownElement) || !bl && object4 instanceof Activity) continue;
                    object3 = null;
                    boolean bl2 = suppression.isSuppressed(process2);
                    if (!bl2 && !bl) continue;
                    if (process2 == object4) {
                        object3 = (BreakdownElement)object5.get(object4);
                    } else if (process2 instanceof BreakdownElementWrapperItemProvider && ((DescribableElementWrapperItemProvider)(object2 = (BreakdownElementWrapperItemProvider)process2)).isInherited()) {
                        object = Suppression.getPathWithoutViewType((BreakdownElementWrapperItemProvider)object2).toString();
                        object3 = ((CopyHelper)((Object)object6)).getWrapperCopy((String)object);
                    }
                    if (object3 == null) continue;
                    if (bl2) {
                        object3.setSuppressed(Boolean.TRUE);
                    }
                    if (!bl) continue;
                    hashMap.put((BreakdownElementWrapperItemProvider)process2, object3);
                }
                if (bl) {
                    for (Map.Entry entry : hashMap.entrySet()) {
                        object3 = entry.getKey();
                        Object v = entry.getValue();
                        if (!(v instanceof Activity)) continue;
                        object2 = (ITreeItemContentProvider)adapterFactory.adapt(object3, ITreeItemContentProvider.class);
                        object = object2.getChildren(object3);
                        EList eList = (EList)((Activity)v).getBreakdownElements();
                        List list = object instanceof List ? (List)object : new ArrayList(object);
                        int n3 = list.size();
                        int n4 = 0;
                        while (n4 < n3) {
                            Object e = list.get(n4);
                            Object v2 = hashMap.get(e);
                            if (v2 != null) {
                                if (n4 < n3 - 1) {
                                    Object e2 = list.get(n4 + 1);
                                    Object v3 = hashMap.get(e2);
                                    if (v3 != null) {
                                        int n5;
                                        int n6 = eList.indexOf(v3);
                                        if (n6 != -1 && (n5 = eList.indexOf(v2)) != n6 - 1) {
                                            if (n5 < n6) {
                                                eList.move(n6 - 1, n5);
                                            } else {
                                                eList.move(n5, n6);
                                            }
                                        }
                                    } else if (TngUtil.DEBUG) {
                                        System.err.println("Element does not have copy: " + e2);
                                    }
                                }
                            } else if (TngUtil.DEBUG) {
                                System.err.println("Element does not have copy: " + e);
                            }
                            ++n4;
                        }
                    }
                }
            }
            finally {
                if (iConfigurator != null) {
                    iConfigurator.setMethodConfiguration(methodConfiguration);
                }
            }
            ++n;
        }
    }

    public CopyHelper getCopyHelper() {
        return (CopyHelper)this.copyHelper;
    }

    /* synthetic */ ActivityDeepCopyCommand(Activity activity, CopyHelper copyHelper, MethodConfiguration methodConfiguration, Process process, IProgressMonitor iProgressMonitor, boolean bl, IConfigurator iConfigurator, ActivityDeepCopyCommand activityDeepCopyCommand) {
        this(activity, copyHelper, methodConfiguration, process, iProgressMonitor, bl, iConfigurator);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CreateDeepCopyCommand
    extends CreateCopyCommand {
        public CreateDeepCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
            super((org.eclipse.emf.edit.domain.EditingDomain)editingDomain, eObject, helper);
        }

        public Collection<?> doGetChildrenToCopy() {
            ConfigurationSetter configurationSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
            try {
                configurationSetter.set(ActivityDeepCopyCommand.this.config);
                IConfigurator iConfigurator = configurationSetter.getConfigurator();
                ArrayList arrayList = new ArrayList();
                for (Object e : this.owner.eContents()) {
                    if (e instanceof Activity) {
                        if (iConfigurator != null && !iConfigurator.accept(e)) continue;
                        arrayList.add(0, e);
                        continue;
                    }
                    arrayList.add(e);
                }
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            finally {
                configurationSetter.restore();
            }
        }
    }

    private class EditingDomain
    extends AdapterFactoryEditingDomain {
        public EditingDomain() {
            super((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
        }

        public Command createCommand(Class clazz, CommandParameter commandParameter) {
            if (clazz == CreateCopyCommand.class) {
                return new CreateDeepCopyCommand(this, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
            }
            if (clazz == InitializeCopyCommand.class) {
                return new InitializeDeepCopyCommand(this, commandParameter.getEOwner(), (CopyCommand.Helper)commandParameter.getValue());
            }
            return super.createCommand(clazz, commandParameter);
        }
    }

    private class InitializeDeepCopyCommand
    extends MethodElementInitializeCopyCommand {
        private List<String> guidList;

        public InitializeDeepCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
            super((org.eclipse.emf.edit.domain.EditingDomain)editingDomain, eObject, helper);
            this.copy = (EObject)helper.get((Object)eObject);
        }

        protected void copyReferences() {
            Object object;
            Activity activity;
            Activity activity2 = null;
            Activity activity3 = null;
            HashSet<VariabilityElement> hashSet = new HashSet<VariabilityElement>();
            ConfigurationSetter configurationSetter = null;
            IConfigurator iConfigurator = null;
            boolean bl = false;
            try {
                Object object2;
                Object object3;
                Object object42;
                ArrayList<Object> arrayList;
                MethodConfiguration methodConfiguration;
                if (this.owner instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)(activity = (Activity)this.owner))) {
                    configurationSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
                    configurationSetter.set(ActivityDeepCopyCommand.this.config);
                    iConfigurator = configurationSetter.getConfigurator();
                    activity2 = (Activity)activity.getVariabilityBasedOnElement();
                    boolean bl2 = bl = iConfigurator == null || iConfigurator.accept(activity2);
                    if (bl) {
                        VariabilityElement variabilityElement;
                        object = (CopyHelper)this.copyHelper;
                        methodConfiguration = (Activity)object.get((Object)activity2);
                        ((CopyHelper)((Object)object)).putVariabilityElement((VariabilityElement)activity2, (VariabilityElement)activity);
                        arrayList = new ArrayList();
                        for (Object object42 : activity.getBreakdownElements()) {
                            VariabilityElement variabilityElement2;
                            if (!(object42 instanceof VariabilityElement) || (variabilityElement2 = (variabilityElement = (VariabilityElement)object42).getVariabilityBasedOnElement()) == null || variabilityElement.getVariabilityType() != VariabilityType.LOCAL_CONTRIBUTION_LITERAL && variabilityElement.getVariabilityType() != VariabilityType.LOCAL_REPLACEMENT_LITERAL) continue;
                            ((CopyHelper)((Object)object)).putVariabilityElement(variabilityElement2, variabilityElement);
                            arrayList.add(variabilityElement2);
                        }
                        object3 = new ActivityDeepCopyCommand(activity2, (CopyHelper)((Object)object), ActivityDeepCopyCommand.this.config, ActivityDeepCopyCommand.this.targetProcess, ActivityDeepCopyCommand.this.monitor, false, ActivityDeepCopyCommand.this.activityDeepCopyConfigurator, null);
                        ((ActivityDeepCopyCommand)((Object)object3)).copyExternalVariations = ActivityDeepCopyCommand.this.copyExternalVariations;
                        ((ActivityDeepCopyCommand)((Object)object3)).guidList = new LinkedList(ActivityDeepCopyCommand.this.guidList);
                        ((ActivityDeepCopyCommand)((Object)object3)).guidList.addAll(ProcessUtil.getGuidList(ActivityDeepCopyCommand.this.activity, activity));
                        try {
                            ((ActivityDeepCopyCommand)((Object)object3)).execute();
                            activity3 = (Activity)object.get((Object)activity2);
                            if (activity.getVariabilityType() == VariabilityType.EXTENDS_LITERAL) {
                                ((CopyHelper)((Object)object)).removeVariabilityElement((VariabilityElement)activity2);
                                ((CopyHelper)((Object)object)).putBackupCopy((VariabilityElement)activity2, (VariabilityElement)activity);
                                if (methodConfiguration != null) {
                                    ((CopyHelper)((Object)object)).basicPut((EObject)activity2, (EObject)methodConfiguration);
                                }
                            }
                            object.remove((Object)activity2);
                            object42 = arrayList.iterator();
                            while (object42.hasNext()) {
                                variabilityElement = object.remove(object42.next());
                                if (variabilityElement == null) continue;
                                hashSet.add(variabilityElement);
                                EcoreUtil.remove((EObject)variabilityElement.eContainer());
                            }
                            object42 = (Activity)this.copy;
                            int n = 0;
                            while (n < diagramTypes.length) {
                                int n2 = diagramTypes[n];
                                if (ActivityDeepCopyCommand.this.diagramMgr.getDiagram(activity, n2) != null && (object2 = ActivityDeepCopyCommand.this.diagramMgr.getDiagram((Activity)object42, n2)) != null) {
                                    EcoreUtil.remove((EObject)object2);
                                }
                                ++n;
                            }
                            ActivityDeepCopyCommand.moveContent(((ActivityDeepCopyCommand)((Object)object3)).pkgCopy, (Activity)object42);
                            for (BreakdownElement breakdownElement : activity3.getBreakdownElements()) {
                                if (hashSet.contains(breakdownElement)) continue;
                                object2 = (BreakdownElement)((CopyHelper)((Object)object)).getOriginal(breakdownElement);
                                ArrayList<String> arrayList2 = new ArrayList<String>(((ActivityDeepCopyCommand)((Object)object3)).guidList);
                                arrayList2.add(object2.getGuid());
                                ((CopyHelper)((Object)object)).putWrapperCopy(ProcessUtil.toGuidPath(arrayList2), breakdownElement);
                            }
                        }
                        finally {
                            object3.dispose();
                        }
                    }
                }
                super.copyReferences();
                if (activity2 != null) {
                    activity = (Activity)this.owner;
                    object = (Activity)this.copy;
                    if (bl) {
                        methodConfiguration = configurationSetter.getOldConfiguration();
                        arrayList = new ArrayList<Object>();
                        for (Object object42 : activity3.getBreakdownElements()) {
                            if (hashSet.contains(object42) || iConfigurator != null && !iConfigurator.accept(object42)) continue;
                            arrayList.add(object42);
                        }
                        object.getBreakdownElements().addAll(0, arrayList);
                        activity3.setSuperActivities(null);
                        EcoreUtil.remove(activity3);
                        object3 = ActivityDeepCopyCommand.this.config == null ? (methodConfiguration != null ? methodConfiguration : ActivityDeepCopyCommand.this.targetProcess.getDefaultContext()) : ActivityDeepCopyCommand.this.config;
                        for (Object object42 : this.getAttributesToCopy()) {
                            if (!object42.isChangeable() || object42.isDerived()) continue;
                            Object object5 = Providers.getConfigurationApplicator().getAttribute((VariabilityElement)activity, (EAttribute)object42, (MethodConfiguration)object3);
                            object.eSet((EStructuralFeature)object42, object5);
                        }
                        object42 = activity.getPresentation();
                        for (Object object6 : object42.eClass().getEAllAttributes()) {
                            if (!object6.isChangeable() || object6.isDerived() || object6.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass()) continue;
                            object2 = Providers.getConfigurationApplicator().getAttribute((ContentDescription)object42, (DescribableElement)activity, (EAttribute)object6, (MethodConfiguration)object3);
                            object.getPresentation().eSet((EStructuralFeature)object6, object2);
                        }
                    }
                    object.setPresentationName(ProcessUtil.getPresentationName((BreakdownElement)activity));
                }
                if (ActivityDeepCopyCommand.this.copyExternalVariations && this.owner instanceof Activity && (ActivityDeepCopyCommand.this.copyContributors || this.owner != ActivityDeepCopyCommand.this.activity) && !(object = ActivityDeepCopyCommand.this.getContributors(activity = (Activity)this.owner)).isEmpty()) {
                    this.doCopyContributors((List)object, activity);
                }
                if (this.copy instanceof Activity) {
                    activity = (Activity)this.copy;
                    activity.setVariabilityBasedOnElement(null);
                    activity.setVariabilityType(null);
                }
            }
            finally {
                if (configurationSetter != null) {
                    configurationSetter.restore();
                }
            }
            if (this.copy instanceof Activity && (object = ConstraintManager.getConstraint((MethodElement)(activity = (Activity)this.copy), "", false)) != null) {
                EcoreUtil.remove((EObject)object);
            }
        }

        protected void doCopyContributors(List list, Activity activity) {
            ConfigurationSetter configurationSetter = new ConfigurationSetter(ActivityDeepCopyCommand.this.getAdapterFactory());
            try {
                MethodConfiguration methodConfiguration = configurationSetter.getOldConfiguration();
                MethodConfiguration methodConfiguration2 = ActivityDeepCopyCommand.this.config == null ? (methodConfiguration != null ? methodConfiguration : ActivityDeepCopyCommand.this.targetProcess.getDefaultContext()) : ActivityDeepCopyCommand.this.config;
                configurationSetter.set(methodConfiguration2);
                IConfigurator iConfigurator = configurationSetter.getConfigurator();
                for (Activity activity2 : list) {
                    CopyHelper copyHelper = (CopyHelper)this.copyHelper;
                    Activity activity3 = (Activity)copyHelper.get(activity2);
                    ActivityDeepCopyCommand activityDeepCopyCommand = new ActivityDeepCopyCommand(activity2, copyHelper, ActivityDeepCopyCommand.this.config, ActivityDeepCopyCommand.this.targetProcess, ActivityDeepCopyCommand.this.monitor, false, ActivityDeepCopyCommand.this.activityDeepCopyConfigurator, null);
                    activityDeepCopyCommand.copyContributors = false;
                    activityDeepCopyCommand.guidList = new LinkedList(ActivityDeepCopyCommand.this.guidList);
                    activityDeepCopyCommand.guidList.addAll(ProcessUtil.getGuidList(ActivityDeepCopyCommand.this.activity, activity));
                    try {
                        activityDeepCopyCommand.execute();
                        activity3 = (Activity)copyHelper.get(activity2);
                        Activity activity4 = (Activity)this.copy;
                        int n = 0;
                        while (n < diagramTypes.length) {
                            BreakdownElement breakdownElement;
                            int n2 = diagramTypes[n];
                            if (ActivityDeepCopyCommand.this.diagramMgr.getDiagram(ActivityDeepCopyCommand.this.activity, n2) != null && (breakdownElement = ActivityDeepCopyCommand.this.diagramMgr.getDiagram(activity4, n2)) != null) {
                                EcoreUtil.remove((EObject)breakdownElement);
                            }
                            ++n;
                        }
                        ActivityDeepCopyCommand.moveContent(activityDeepCopyCommand.pkgCopy, activity4);
                        ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>();
                        for (BreakdownElement breakdownElement : activity3.getBreakdownElements()) {
                            if (iConfigurator != null && !iConfigurator.accept(breakdownElement)) continue;
                            arrayList.add(breakdownElement);
                        }
                        activity4.getBreakdownElements().addAll(arrayList);
                        activity3.setSuperActivities(null);
                        EcoreUtil.remove((EObject)activity3);
                    }
                    finally {
                        activityDeepCopyCommand.dispose();
                    }
                }
            }
            finally {
                if (configurationSetter != null) {
                    configurationSetter.restore();
                }
            }
        }
    }
}

