/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.IConfigurationApplicator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.BatchCommand;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.process.command.DescriptorUpdateBatchCommand;
import org.eclipse.epf.library.edit.process.command.ProcessCommandUtil;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BSDropCommand
extends AbstractCommand
implements IResourceAwareCommand {
    public static final Set<EStructuralFeature> DEFAULT_SYNCH_FEATURES = Collections.unmodifiableSet(new HashSet(Arrays.asList(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), UmaPackage.eINSTANCE.getTask_OptionalInput(), UmaPackage.eINSTANCE.getTask_MandatoryInput(), UmaPackage.eINSTANCE.getTask_Output(), UmaPackage.eINSTANCE.getTask_Steps(), UmaPackage.eINSTANCE.getTask_PerformedBy(), UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), UmaPackage.eINSTANCE.getRole_ResponsibleFor(), UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts(), UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts())));
    public static final Map<EStructuralFeature, EStructuralFeature> FEATURE_MAP = new HashMap<EStructuralFeature, EStructuralFeature>();
    protected Activity activity;
    protected List<Object> dropElements;
    protected List<Object> unwrappedDropElements;
    private Set<Resource> modifiedResources;
    protected List<Object> elementsToAddToDefaultConfig;
    protected Set<Object> addedObjects;
    private Process process;
    private boolean addedToDefaultConfig = false;
    protected boolean synchronize = false;
    protected ArrayList<TaskDescriptor> taskDescList;
    protected ArrayList<Descriptor> taskDescriptorsToUpdate;
    private Map<Descriptor, Map<?, ?>> descriptorToOldRefreshableFeaturesMap;
    protected DescriptorUpdateBatchCommand batchCommand;
    private Map taskDescToNewStepsMap;
    private Map taskDescToOldEstimateMap;
    protected boolean canceled;
    private MethodConfiguration config;
    protected Set synchFeatures = DEFAULT_SYNCH_FEATURES;
    private BatchCommand refreshResponsibleForCommand;
    protected boolean executed;
    protected boolean runAsJob;
    private IProgressMonitor monitor;
    private int workedUnits;
    private NestedCommandExcecutor nestedCommandExcecutor;

    static {
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_OptionalInput());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_MandatoryInput());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor(), (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getDeliverable_DeliveredWorkProducts(), (EStructuralFeature)UmaPackage.eINSTANCE.getWorkProductDescriptor_DeliverableParts());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_AdditionallyPerformedBy());
        FEATURE_MAP.put((EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy(), (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy());
    }

    public BSDropCommand(Activity activity, List<Object> list) {
        this(activity, list, null, null, false);
    }

    public BSDropCommand(Activity activity, List<Object> list, boolean bl) {
        this(activity, list, null, null, bl);
    }

    public BSDropCommand(Activity activity, List<Object> list, MethodConfiguration methodConfiguration, Set set) {
        this(activity, list, methodConfiguration, set, true);
    }

    public BSDropCommand(Activity activity, List<Object> list, MethodConfiguration methodConfiguration, Set set, boolean bl) {
        this.activity = activity;
        this.process = TngUtil.getOwningProcess((BreakdownElement)activity);
        this.synchronize = bl;
        this.config = methodConfiguration;
        this.synchFeatures = set == null ? DEFAULT_SYNCH_FEATURES : set;
        this.dropElements = list;
        this.nestedCommandExcecutor = this.createNestedCommandExcecutor();
    }

    protected NestedCommandExcecutor createNestedCommandExcecutor() {
        return new NestedCommandExcecutor(this){

            public void executeNestedCommands() {
                List<INestedCommandProvider> list;
                if (BSDropCommand.this.taskDescList != null && !BSDropCommand.this.taskDescList.isEmpty() && !(list = ExtensionManager.getNestedCommandProviders()).isEmpty()) {
                    for (INestedCommandProvider iNestedCommandProvider : list) {
                        try {
                            Command command = iNestedCommandProvider.createRelatedObjects(BSDropCommand.this.taskDescList, BSDropCommand.this);
                            if (command == null || !command.canExecute()) continue;
                            command.execute();
                            this.getNestedCommands().add(command);
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                        }
                    }
                }
                super.executeNestedCommands();
            }
        };
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        return this.monitor;
    }

    protected void prepareDropElements() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.getMethodConfiguration();
        this.unwrappedDropElements = new ArrayList<Object>();
        for (Object object : this.dropElements) {
            Object object2 = TngUtil.unwrap(object);
            object2 = Providers.getConfigurationApplicator().resolve(object2, this.config);
            if (arrayList.contains(object2) || object2 instanceof EObject && ((EObject)object2).eIsProxy()) continue;
            arrayList.add(object2);
            this.unwrappedDropElements.add(object);
        }
        this.dropElements = arrayList;
    }

    public MethodConfiguration getMethodConfiguration() {
        if (this.config == null) {
            this.config = TngUtil.getOwningProcess((BreakdownElement)this.activity).getDefaultContext();
        }
        return this.config;
    }

    public void dispose() {
        if (this.dropElements != null) {
            this.dropElements.clear();
        }
        if (this.unwrappedDropElements != null) {
            this.unwrappedDropElements.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        if (this.elementsToAddToDefaultConfig != null) {
            this.elementsToAddToDefaultConfig.clear();
        }
        if (this.addedObjects != null) {
            this.addedObjects.clear();
        }
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            this.descriptorToOldRefreshableFeaturesMap.clear();
        }
        if (this.taskDescList != null) {
            this.taskDescList.clear();
        }
        if (this.taskDescToNewStepsMap != null) {
            this.taskDescToNewStepsMap.clear();
        }
        if (this.taskDescToOldEstimateMap != null) {
            this.taskDescToOldEstimateMap.clear();
        }
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.dispose();
        }
        if (this.taskDescriptorsToUpdate != null) {
            this.taskDescriptorsToUpdate.clear();
        }
        if (this.batchCommand != null) {
            this.batchCommand.dispose();
        }
        this.process = null;
        this.activity = null;
        if (this.nestedCommandExcecutor != null) {
            this.nestedCommandExcecutor.dispose();
        }
        super.dispose();
    }

    @Override
    public Collection<Resource> getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet<Resource>();
            if (this.activity.eResource() != null) {
                this.modifiedResources.add(this.activity.eResource());
            }
        }
        this.modifiedResources.addAll(this.nestedCommandExcecutor.getModifiedResources());
        return this.modifiedResources;
    }

    private boolean clearDescriptor(Descriptor descriptor) {
        HashSet<Object> hashSet;
        HashSet<EStructuralFeature> hashSet2 = new HashSet<EStructuralFeature>(DEFAULT_SYNCH_FEATURES);
        hashSet2.removeAll(this.synchFeatures);
        if (hashSet2.isEmpty()) {
            hashSet = hashSet2;
        } else {
            hashSet = new HashSet();
            Iterator iterator = hashSet2.iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature = BSDropCommand.getDescriptorFeature((EStructuralFeature)iterator.next());
                if (eStructuralFeature == null) continue;
                hashSet.add(eStructuralFeature);
            }
        }
        boolean bl = ProcessCommandUtil.clearDescriptor(descriptor, this.descriptorToOldRefreshableFeaturesMap, hashSet);
        if (bl && descriptor instanceof TaskDescriptor) {
            if (this.taskDescriptorsToUpdate == null) {
                this.taskDescriptorsToUpdate = new ArrayList();
            }
            this.taskDescriptorsToUpdate.add(descriptor);
        }
        return bl;
    }

    private static EStructuralFeature getDescriptorFeature(EStructuralFeature eStructuralFeature) {
        return FEATURE_MAP.get(eStructuralFeature);
    }

    protected boolean preExecute() {
        boolean bl;
        this.prepareDropElements();
        boolean bl2 = bl = !this.dropElements.isEmpty();
        if (bl) {
            this.batchCommand = new DescriptorUpdateBatchCommand(false, this.synchFeatures, this.config);
        }
        return bl;
    }

    protected boolean collectElementsToAddToDefaultConfig() {
        if (this.elementsToAddToDefaultConfig == null) {
            this.elementsToAddToDefaultConfig = new ArrayList<Object>();
            Iterator<Object> iterator = this.dropElements.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                switch (UserInteractionHelper.checkAgainstDefaultConfiguration(this.process, object)) {
                    case 0: {
                        iterator.remove();
                        break;
                    }
                    case 2: {
                        this.elementsToAddToDefaultConfig.add(object);
                        break;
                    }
                    case -1: {
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private boolean addToDefaultConfiguration() {
        if (!this.addedToDefaultConfig && this.elementsToAddToDefaultConfig != null && !this.elementsToAddToDefaultConfig.isEmpty()) {
            if (this.addedObjects == null) {
                this.addedObjects = new HashSet<Object>();
            } else {
                this.addedObjects.clear();
            }
            for (EObject eObject : this.elementsToAddToDefaultConfig) {
                ProcessUtil.addToDefaultConfiguration(this.process, eObject, this.addedObjects);
            }
            if (!this.addedObjects.isEmpty()) {
                this.getModifiedResources().add(this.process.getDefaultContext().eResource());
                return true;
            }
            this.addedToDefaultConfig = true;
        }
        return false;
    }

    protected int getTotalWork() {
        return 20;
    }

    protected void worked(int n) {
        this.monitor.worked(n);
        this.workedUnits += n;
    }

    protected int getRemainingWork() {
        int n = this.getTotalWork() - this.workedUnits;
        if (n < 0) {
            n = 0;
        }
        return n;
    }

    protected boolean updateDefaultConfigurationNeeded() {
        return !this.synchronize;
    }

    public void execute() {
        if (this.updateDefaultConfigurationNeeded() && !this.collectElementsToAddToDefaultConfig()) {
            return;
        }
        final String string = this.label == null ? "" : this.label;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iProgressMonitor.beginTask(string, BSDropCommand.this.getTotalWork());
                    BSDropCommand.this.monitor = iProgressMonitor;
                    BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                    BSDropCommand.this.addToDefaultConfiguration();
                    BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                    if (BSDropCommand.this.preExecute()) {
                        BSDropCommand.this.worked(BSDropCommand.this.getRemainingWork() / 3);
                        BSDropCommand.this.redo();
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        if (this.runAsJob) {
            UserInteractionHelper.runAsJob(iRunnableWithProgress, string);
        } else {
            UserInteractionHelper.runWithProgress(iRunnableWithProgress, null);
        }
    }

    public void redo() {
        try {
            this.addToDefaultConfiguration();
            this.doExecute();
            this.updateDescriptors();
            long l = 0L;
            if (TngUtil.DEBUG) {
                l = System.currentTimeMillis();
            }
            this.nestedCommandExcecutor.executeNestedCommands();
            if (TngUtil.DEBUG) {
                System.out.println("BSDropCommand.redo(): executeNestedCommands(). " + (System.currentTimeMillis() - l));
            }
            this.executed = true;
        }
        catch (RuntimeException runtimeException) {
            if (TngUtil.DEBUG) {
                runtimeException.printStackTrace();
            }
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
            throw runtimeException;
        }
    }

    protected void updateDescriptors() {
        if (this.synchronize) {
            this.clearDescriptors();
        }
        this.batchCommand.execute();
        this.updateTaskDescriptors();
        this.setResponsibleRoles();
    }

    protected void undoUpdateDescriptors() {
        this.undoSetResponsibleRole();
        this.undoUpdateTaskDescriptors();
        this.batchCommand.undo();
        if (this.synchronize) {
            this.undoClearDescriptors();
        }
    }

    private void clearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap == null) {
            this.descriptorToOldRefreshableFeaturesMap = new HashMap();
            if (!this.batchCommand.getDescriptorsToRefresh().isEmpty()) {
                Iterator iterator = this.batchCommand.getDescriptorsToRefresh().iterator();
                while (iterator.hasNext()) {
                    this.clearDescriptor((Descriptor)iterator.next());
                }
            }
        }
    }

    private void updateTaskDescriptors() {
        if (this.taskDescriptorsToUpdate != null && this.synchFeatures.contains(UmaPackage.eINSTANCE.getTask_Steps())) {
            if (this.taskDescToNewStepsMap == null) {
                this.taskDescToNewStepsMap = new HashMap();
            }
            IConfigurationApplicator iConfigurationApplicator = Providers.getConfigurationApplicator();
            for (TaskDescriptor taskDescriptor : this.taskDescriptorsToUpdate) {
                Task task = taskDescriptor.getTask();
                if (task == null || task.eIsProxy()) continue;
                List list = (List)iConfigurationApplicator.getReference(task.getPresentation(), (DescribableElement)task, UmaPackage.eINSTANCE.getContentDescription_Sections(), this.config);
                ArrayList arrayList = new ArrayList();
                taskDescriptor.getSelectedSteps().retainAll(list);
                for (Object e : list) {
                    if (taskDescriptor.getSelectedSteps().contains(e)) continue;
                    arrayList.add(e);
                }
                if (arrayList.isEmpty()) continue;
                taskDescriptor.getSelectedSteps().addAll(arrayList);
                this.taskDescToNewStepsMap.put(taskDescriptor, arrayList);
            }
        }
    }

    private void undoUpdateTaskDescriptors() {
        if (this.taskDescToNewStepsMap != null) {
            for (Map.Entry entry : this.taskDescToNewStepsMap.entrySet()) {
                TaskDescriptor taskDescriptor = (TaskDescriptor)entry.getKey();
                taskDescriptor.getSelectedSteps().removeAll((Collection)entry.getValue());
            }
        }
    }

    private void setResponsibleRoles() {
        if (!this.synchFeatures.contains(UmaPackage.eINSTANCE.getRole_ResponsibleFor())) {
            return;
        }
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.dispose();
        }
        this.refreshResponsibleForCommand = new BatchCommand(true);
        List list = this.activity.getBreakdownElements();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        for (Object object : list) {
            if (object instanceof WorkProductDescriptor) {
                arrayList.add(object);
                continue;
            }
            if (!(object instanceof RoleDescriptor)) continue;
            arrayList2.add(object);
        }
        for (Object object : arrayList2) {
            Role role = object.getRole();
            if (role == null) continue;
            List list2 = (List)Providers.getConfigurationApplicator().getReference((VariabilityElement)role, UmaPackage.eINSTANCE.getRole_ResponsibleFor(), this.config);
            ArrayList<WorkProductDescriptor> arrayList3 = new ArrayList<WorkProductDescriptor>();
            int n = arrayList.size() - 1;
            while (n > -1) {
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)arrayList.get(n);
                if (list2.contains(workProductDescriptor.getWorkProduct())) {
                    arrayList3.add(workProductDescriptor);
                }
                --n;
            }
            if (object.getResponsibleFor().equals(arrayList3)) continue;
            this.refreshResponsibleForCommand.addFeatureValues((EObject)object, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), arrayList3);
        }
        this.refreshResponsibleForCommand.execute();
    }

    public void undo() {
        this.nestedCommandExcecutor.undoNestedCommands();
        if (this.addedObjects != null && !this.addedObjects.isEmpty()) {
            MethodConfiguration methodConfiguration = this.process.getDefaultContext();
            for (Object object : this.addedObjects) {
                if (object instanceof MethodPlugin) {
                    methodConfiguration.getMethodPluginSelection().remove(object);
                    continue;
                }
                if (!(object instanceof MethodPackage)) continue;
                methodConfiguration.getMethodPackageSelection().remove(object);
            }
            this.addedToDefaultConfig = false;
        }
        this.undoUpdateDescriptors();
        this.doUndo();
    }

    private void undoClearDescriptors() {
        if (this.descriptorToOldRefreshableFeaturesMap != null) {
            for (Map.Entry<Descriptor, Map<?, ?>> entry : this.descriptorToOldRefreshableFeaturesMap.entrySet()) {
                Descriptor descriptor = entry.getKey();
                Map<?, ?> map = entry.getValue();
                for (Map.Entry<?, ?> entry2 : map.entrySet()) {
                    descriptor.eSet((EStructuralFeature)entry2.getKey(), entry2.getValue());
                }
            }
        }
    }

    private void undoSetResponsibleRole() {
        if (this.refreshResponsibleForCommand != null) {
            this.refreshResponsibleForCommand.undo();
        }
    }

    protected boolean prepare() {
        return true;
    }

    protected abstract void doExecute();

    protected abstract void doUndo();

    public static interface IExecutor {
        public boolean preExecute();

        public void doExcecute();

        public void doUndo();
    }
}

