/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.TngUtil;

public class GenericDropCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection dropElements;
    private ArrayList featureElements;
    private Collection modifiedResources;
    private EObject target;
    private EStructuralFeature feature;
    private ElementAdapter dropAdapter;

    public GenericDropCommand(EObject eObject, EStructuralFeature eStructuralFeature, Collection collection, ElementAdapter elementAdapter) {
        this.target = eObject;
        this.feature = eStructuralFeature;
        this.dropElements = collection;
        this.dropAdapter = elementAdapter;
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
        }
        return this.modifiedResources;
    }

    public void execute() {
        this.featureElements = new ArrayList();
        Iterator iterator = this.dropElements.iterator();
        while (iterator.hasNext()) {
            Object object = TngUtil.unwrap(iterator.next());
            if ((object = this.dropAdapter.adapt(object)) == null) continue;
            this.featureElements.add(object);
        }
        this.redo();
    }

    public void redo() {
        if (!this.featureElements.isEmpty()) {
            ((List)this.target.eGet(this.feature)).addAll(this.featureElements);
            if (this.target.eResource() != null) {
                this.getModifiedResources().add(this.target.eResource());
            }
        }
    }

    public void undo() {
        ((List)this.target.eGet(this.feature)).removeAll(this.featureElements);
    }

    public Collection getAffectedObjects() {
        return this.featureElements;
    }

    public static interface ElementAdapter {
        public Object adapt(Object var1);
    }
}

