/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.library.AbstractLibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryAlreadyExistsException;
import org.eclipse.epf.library.LibraryNotFoundException;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.PersistenceService;
import org.eclipse.epf.library.project.MethodLibraryProject;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.library.xmi.XMILibraryResourceManager;
import org.eclipse.epf.library.xmi.XMILibraryResources;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.migration.MappingUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMILibraryManager
extends AbstractLibraryManager {
    public static final String LIBRARY_TYPE = "xmi";
    public static final String LIBRARY_XMI = "library.xmi";
    public static final String exportFile = "export.xmi";
    public static final String ARG_LIBRARY_PATH = "library.path";
    protected String path;
    private ILibraryResourceManager resourceMgr = new XMILibraryResourceManager();
    private IProject project;
    private String registerType = "Default";

    public MethodLibrary createMethodLibrary(final String string, final Map<String, Object> map) throws LibraryServiceException {
        final MethodLibrary[] methodLibraryArray = new MethodLibrary[1];
        final LibraryServiceException[] libraryServiceExceptionArray = new LibraryServiceException[1];
        IWorkspaceRunnable iWorkspaceRunnable = new IWorkspaceRunnable(){

            public void run(IProgressMonitor iProgressMonitor) throws CoreException {
                try {
                    methodLibraryArray[0] = XMILibraryManager.this.doCreateMethodLibrary(string, map);
                }
                catch (LibraryServiceException libraryServiceException) {
                    libraryServiceExceptionArray[0] = libraryServiceException;
                }
            }
        };
        try {
            IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
            iWorkspace.run(iWorkspaceRunnable, iWorkspace.getRuleFactory().createRule((IResource)iWorkspace.getRoot()), 1, null);
        }
        catch (CoreException coreException) {
            XMILibraryPlugin.getDefault().getLogger().logError((Throwable)coreException);
            throw new LibraryServiceException((Throwable)coreException);
        }
        if (libraryServiceExceptionArray[0] != null) {
            throw libraryServiceExceptionArray[0];
        }
        return methodLibraryArray[0];
    }

    private MethodLibrary doCreateMethodLibrary(String string, Map<String, Object> map) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"createMethodLibrary", (String)("name=" + string));
        }
        if (string == null || string.length() == 0 || map == null) {
            throw new IllegalArgumentException();
        }
        String string2 = (String)map.get(ARG_LIBRARY_PATH);
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException();
        }
        File file = new File(string2);
        File file2 = new File(file, LIBRARY_XMI);
        if (file2.exists()) {
            String string3 = NLS.bind((String)XMILibraryResources.libraryAlreadyExistsError_msg, (Object)file.getAbsolutePath());
            throw new LibraryAlreadyExistsException(string3);
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        try {
            String string4;
            this.skipEventProcessing = true;
            String string5 = (String)map.get("libraryRegisterType");
            if (string5 != null && string5.equals("ConfigExport")) {
                string4 = Long.toHexString(Calendar.getInstance().getTimeInMillis());
                MethodLibraryProject.openProject((String)file.getAbsolutePath(), (String)("ExportLib" + string4), null);
            } else {
                this.project = MethodLibraryProject.openProject((String)file.getAbsolutePath(), null);
            }
            string4 = (ILibraryResourceSet)this.editingDomain.getResourceSet();
            ModelStorage.newLibrary((ILibraryResourceSet)string4, (String)string, (String)file.getAbsolutePath(), (boolean)true);
            this.library = string4.getFirstMethodLibrary();
            this.addResourceChangedListeners();
            if (debug) {
                DebugTrace.print((Object)((Object)this), (String)"createMethodLibrary", (String)("library=" + this.library));
            }
            MethodLibrary methodLibrary = this.library;
            return methodLibrary;
        }
        catch (Exception exception) {
            throw new LibraryServiceException((Throwable)exception);
        }
        finally {
            this.skipEventProcessing = false;
        }
    }

    public MethodLibrary openMethodLibrary(java.net.URI uRI) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary");
        }
        if (uRI == null) {
            throw new IllegalArgumentException();
        }
        try {
            File file = new File(uRI);
            this.library = this.openMethodLibrary(file);
        }
        catch (LibraryServiceException libraryServiceException) {
            throw libraryServiceException;
        }
        catch (Exception exception) {
            this.library = null;
        }
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    protected MethodLibrary openMethodLibrary(File file) throws LibraryServiceException {
        File file2 = new File(file, LIBRARY_XMI);
        if (!file2.exists()) {
            throw new LibraryNotFoundException();
        }
        VersionUtil.VersionCheckInfo versionCheckInfo = VersionUtil.checkLibraryVersion((File)file2);
        IStatus iStatus = XMILibraryUtil.checkVersion(file2, versionCheckInfo);
        if (!iStatus.isOK()) {
            throw new LibraryServiceException(iStatus.getMessage());
        }
        if (MappingUtil.conversionRequired((String)file2.getAbsolutePath(), (VersionUtil.VersionCheckInfo)versionCheckInfo)) {
            throw new LibraryServiceException(LibraryResources.libUpgradeRequired_err_msg);
        }
        try {
            this.skipEventProcessing = true;
            this.project = MethodLibraryProject.openProject((String)file.getAbsolutePath(), null);
            ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)this.editingDomain.getResourceSet();
            iLibraryResourceSet.loadMethodLibraries(URI.createFileURI((String)file2.getAbsolutePath()), Collections.EMPTY_MAP);
            this.library = iLibraryResourceSet.getFirstMethodLibrary();
            this.addResourceChangedListeners();
            System.gc();
            MethodLibrary methodLibrary = this.library;
            return methodLibrary;
        }
        catch (Exception exception) {
            if (debug) {
                DebugTrace.print((Throwable)exception);
            }
            throw new LibraryServiceException((Throwable)exception);
        }
        finally {
            this.firePropertyChange(this.library, 1);
            this.skipEventProcessing = false;
        }
    }

    public MethodLibrary openMethodLibrary(Map map) throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary");
        }
        if (map == null) {
            throw new IllegalArgumentException();
        }
        String string = (String)map.get(ARG_LIBRARY_PATH);
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        this.library = this.openMethodLibrary(new File(string));
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"openMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    public MethodLibrary reopenMethodLibrary() throws LibraryServiceException {
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"reopenMethodLibrary");
        }
        this.library = this.openMethodLibrary(new File(this.getMethodLibraryLocation()));
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"reopenMethodLibrary", (String)("library=" + this.library));
        }
        return this.library;
    }

    protected String getLibraryPersisterType() {
        return LIBRARY_TYPE;
    }

    protected ILibraryResourceSet createResourceSet() {
        return PersistenceService.INSTANCE.createResourceSet(LIBRARY_TYPE);
    }

    public String getMethodLibraryLocation() {
        java.net.URI uRI;
        if (debug) {
            DebugTrace.print((Object)((Object)this), (String)"getMethodLibraryPath");
        }
        if ((uRI = this.getMethodLibraryURI()) != null) {
            File file = new File(uRI);
            if (file.getName().equalsIgnoreCase(LIBRARY_XMI)) {
                file = file.getParentFile();
            }
            return file.getAbsolutePath();
        }
        return null;
    }

    public IProject getMethodLibraryProject() {
        return this.project;
    }

    public void handleLibraryMoved() {
        if (this.library == null) {
            return;
        }
        String string = this.getMethodLibraryLocation();
        if (!this.project.isOpen() || this.project.getLocation().equals((Object)new Path(string))) {
            return;
        }
        Resource resource = this.library.eResource();
        if (resource == null || resource.getResourceSet() == null) {
            return;
        }
        String string2 = this.project.getLocation().toOSString();
        if (resource.getResourceSet() instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resource.getResourceSet()).handleLibraryMoved(string2);
        } else {
            PersistenceUtil.replaceURIPrefix(new ArrayList(resource.getResourceSet().getResources()), (String)string, (String)string2);
        }
    }

    public ILibraryResourceManager getResourceManager() {
        return this.resourceMgr;
    }

    public void backupMethodLibrary(String string) {
        String string2 = this.getMethodLibraryLocation();
        File file = new File(string2);
        String string3 = ".lock";
        LayoutResources.copyDir((File)file, (File)new File(string), (String)"**", (String)string3);
    }

    private String getRegisterType() {
        return this.registerType;
    }

    private void setRegisterType(String string) {
        this.registerType = string;
    }

    public void registerMethodLibrary(MethodLibrary methodLibrary, Map<String, Object> map) throws LibraryServiceException {
        String string = (String)map.get("libraryRegisterType");
        if (string != null) {
            this.setRegisterType(string);
        }
        if ((string = this.getRegisterType()).equals("ConfigExport")) {
            String string2 = LIBRARY_XMI;
            this.createMethodLibrary(string2, map);
            this.setMethodLibrary(methodLibrary);
            return;
        }
        this.library = methodLibrary;
    }

    public void unRegisterMethodLibrary() throws LibraryServiceException {
        if (this.getRegisterType().equals("ConfigExport")) {
            this.closeMethodLibrary();
            return;
        }
        this.library = null;
    }
}

