/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.xmi.internal.migration;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.xmi.XMILibraryPlugin;
import org.eclipse.epf.persistence.migration.MigratorImpl;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public abstract class MigratorBase
extends MigratorImpl {
    protected static final boolean DEBUG = XMILibraryPlugin.getDefault().isDebugging();

    protected static void updateStatus(IProgressMonitor iProgressMonitor, String string) {
        if (iProgressMonitor != null) {
            iProgressMonitor.subTask(string);
            iProgressMonitor.worked(1);
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        } else {
            System.out.println(string);
        }
    }

    protected void updateAllContents(IProgressMonitor iProgressMonitor, MethodLibrary methodLibrary) throws Exception {
        TreeIterator treeIterator = methodLibrary.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject;
            block4: {
                eObject = (EObject)treeIterator.next();
                if (!(eObject instanceof MethodElement)) continue;
                try {
                    Iterator iterator = eObject.eCrossReferences().iterator();
                    while (iterator.hasNext()) {
                        iterator.next();
                    }
                }
                catch (Exception exception) {
                    CommonPlugin.INSTANCE.log((Object)exception);
                    if (!DEBUG) break block4;
                    System.err.println("Error iterate thru cross references of element: " + eObject);
                }
            }
            this.updateElement((MethodElement)eObject, iProgressMonitor);
        }
    }

    protected abstract void updateElement(MethodElement var1, IProgressMonitor var2) throws Exception;

    public abstract void migrate(String var1, IProgressMonitor var2) throws Exception;

    public abstract void migrate(String var1, IProgressMonitor var2, UpgradeCallerInfo var3) throws Exception;
}

