/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp.ui;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.rcp.ui.MainWorkbenchAdvisor;
import org.eclipse.epf.rcp.ui.RCPUIPlugin;
import org.eclipse.epf.rcp.ui.RCPUIResources;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class MainApplication
implements IApplication {
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";

    public Object start(IApplicationContext iApplicationContext) {
        Display display = PlatformUI.createDisplay();
        Shell shell = new Shell(display, 16384);
        try {
            boolean bl = false;
            String[] stringArray = Platform.getApplicationArgs();
            int n = 0;
            while (n < stringArray.length) {
                String string;
                if (stringArray[n].equalsIgnoreCase("-library") && n < stringArray.length - 1) {
                    string = stringArray[n + 1];
                    if ((string = this.buildLocation(string)) != null) {
                        LibraryUIManager.setCommandLineLibrary((String)string);
                    }
                } else if (stringArray[n].equalsIgnoreCase("-defaultlibrary") && n < stringArray.length - 1) {
                    string = stringArray[n + 1];
                    if ((string = this.buildLocation(string)) != null) {
                        LibraryUIManager.setCommandLineDefaultLibrary((String)string);
                    }
                } else if (stringArray[n].equalsIgnoreCase("-nolock")) {
                    bl = true;
                } else if (stringArray[n].equalsIgnoreCase("-batch")) {
                    CommandLineRunUtil.getInstance().setNeedToRun(true);
                }
                ++n;
            }
            if (!bl && !this.checkWorkspaceLock(shell)) {
                Platform.endSplash();
                Integer n2 = IApplication.EXIT_OK;
                return n2;
            }
            n = this.createWorkbenchAdvisor(display);
            if (n == 1) {
                Integer n3 = IApplication.EXIT_RESTART;
                return n3;
            }
            Integer n4 = IApplication.EXIT_OK;
            return n4;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench iWorkbench = PlatformUI.getWorkbench();
        if (iWorkbench == null) {
            return;
        }
        final Display display = iWorkbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    iWorkbench.close();
                }
            }
        });
    }

    protected int createWorkbenchAdvisor(Display display) {
        return PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new MainWorkbenchAdvisor());
    }

    protected boolean checkWorkspaceLock(Shell shell) {
        String string;
        block3: {
            Location location = Platform.getInstanceLocation();
            string = Platform.getProduct().getName();
            if (!location.lock()) break block3;
            return true;
        }
        try {
            MessageDialog.openInformation((Shell)shell, (String)NLS.bind((String)RCPUIResources.workspaceCannotLockTitle, (Object)string), (String)NLS.bind((String)RCPUIResources.workspaceCannotLockMessage, (Object)string));
        }
        catch (IOException iOException) {
            RCPUIPlugin.getDefault().getLogger().logError(NLS.bind((String)RCPUIResources.workspaceCannotLockMessage, (Object)string), (Throwable)iOException);
            MessageDialog.openInformation((Shell)shell, (String)NLS.bind((String)RCPUIResources.workspaceCannotLockTitle, (Object)string), (String)iOException.getMessage());
        }
        return false;
    }

    private String buildLocation(String string) {
        String string2;
        String string3 = string2 = string.trim();
        if (string2.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (string2.equalsIgnoreCase(NO_DEFAULT)) {
            return null;
        }
        if (string2.startsWith(USER_HOME)) {
            String string4 = MainApplication.substituteVar(string, USER_HOME, PROP_USER_HOME);
            string3 = new File(string4).getAbsolutePath();
        } else if (string2.startsWith(USER_DIR)) {
            String string5 = MainApplication.substituteVar(string, USER_DIR, PROP_USER_DIR);
            string3 = new File(string5).getAbsolutePath();
        }
        return string3;
    }

    private static String substituteVar(String string, String string2, String string3) {
        String string4 = System.getProperty(string3, "");
        return String.valueOf(string4) + string.substring(string2.length());
    }
}

