/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.dataexchange.util;

import java.io.File;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.dataexchange.util.IResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.uma.MethodPlugin;

public class ContentProcessor {
    protected static final Pattern p_src_ref = Pattern.compile("src\\s*=\\s*\"(.*?)\"", 34);
    protected static final Pattern p_href_ref = Pattern.compile("href\\s*=\\s*\"(.*?)\"", 34);
    IResourceHandler handler;
    ILogger logger;

    public ContentProcessor(IResourceHandler iResourceHandler, ILogger iLogger) {
        this.handler = iResourceHandler;
        this.logger = iLogger;
    }

    public String resolveResourceFiles(Object object, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            String string2;
            String string3;
            Matcher matcher = p_src_ref.matcher(string);
            while (matcher.find()) {
                string3 = matcher.group(1);
                string2 = this.processResourceUrl(object, string3);
                String string4 = "src=\"" + string2 + "\"";
                matcher.appendReplacement(stringBuffer, this.fixReplacementStr(string4));
            }
            matcher.appendTail(stringBuffer);
            matcher = p_href_ref.matcher(stringBuffer.toString());
            stringBuffer.setLength(0);
            while (matcher.find()) {
                string3 = matcher.group(1);
                string2 = "";
                int n = string3.indexOf("#");
                if (n >= 0) {
                    string2 = string3.substring(n);
                    string3 = string3.substring(0, n);
                }
                if (string3.length() > 0) {
                    string3 = this.processResourceUrl(object, string3);
                }
                matcher.appendReplacement(stringBuffer, this.fixReplacementStr("href=\"" + string3 + string2 + "\""));
            }
            matcher.appendTail(stringBuffer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private String fixReplacementStr(String string) {
        try {
            int n = string.indexOf("$");
            if (n < 0) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n >= 0) {
                stringBuffer.append(string.substring(n2, n)).append("\\$");
                n2 = n + 1;
                n = string.indexOf("$", n2);
            }
            stringBuffer.append(string.substring(n2));
            return stringBuffer.toString();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            return string;
        }
    }

    protected boolean isFileUrl(String string) {
        return string != null && string.length() != 0 && !string.startsWith("http") && !string.startsWith("www.") && !string.startsWith("mailto:") && string.toLowerCase().indexOf("javascript:") < 0;
    }

    protected boolean isValidFilePath(File file) {
        return file != null && file.exists();
    }

    public String processResourceUrl(Object object, String string) {
        if (!this.isFileUrl(string)) {
            return string;
        }
        UrlInfo urlInfo = null;
        try {
            urlInfo = this.handler.resolveFileUrl(object, string);
        }
        catch (Exception exception) {
            this.logger.logWarning("error processing url '" + string + "'");
            return string;
        }
        if (urlInfo.sourceFile == null || urlInfo.targetFile == null) {
            return string;
        }
        if (urlInfo.sourceFile.isFile() && urlInfo.sourceFile.exists()) {
            FileUtil.copyFile((File)urlInfo.sourceFile, (File)urlInfo.targetFile);
            return urlInfo.targetUrl;
        }
        return string;
    }

    protected void processUrlText(Object object, String string) {
        String string2;
        Matcher matcher = p_href_ref.matcher(string);
        if (matcher.find() && (string2 = matcher.group(1)).toLowerCase().indexOf("javaScript:") < 0) {
            int n = string2.indexOf("#");
            if (n >= 0) {
                string2 = string2.substring(0, n);
            }
            if (string2.length() > 0) {
                this.processResourceUrl(object, string2);
            }
        }
    }

    public void copyResource(String string) {
        this.handler.copyResource(string);
    }

    public void copyResource(String string, EObject eObject, MethodPlugin methodPlugin) {
        this.handler.copyResource(string, eObject, methodPlugin);
    }

    public String resolveAttachmentResources(Object object, String string) {
        if (string != null && string.length() != 0) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                string2 = this.processResourceUrl(object, string2);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append("|");
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        return "";
    }
}

