/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration.closure;

import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.configuration.closure.ElementError;
import org.eclipse.epf.library.configuration.closure.ElementReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;

public class ConfigurationErrorMatrix {
    public static ElementError getError(MethodConfiguration methodConfiguration, ElementReference elementReference) {
        if (elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement())) {
            return ConfigurationErrorMatrix.getVariabilityError(methodConfiguration, elementReference);
        }
        int n = 4;
        String string = LibraryResources.ElementError_missing_element;
        MethodElement methodElement = elementReference.getElement();
        MethodElement methodElement2 = elementReference.getRefElement();
        if (elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_MandatoryInput())) {
            n = 1;
            string = LibraryResources.ElementError_missing_mandatory_input;
        } else if (elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output())) {
            n = 1;
            string = LibraryResources.ElementError_missing_output;
        } else if (elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy())) {
            n = 2;
            string = LibraryResources.ElementError_missing_primary_performer;
        } else if (!(elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_AdditionallyPerformedBy()) || elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getTask_OptionalInput()) || elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRole_ResponsibleFor()) || elementReference.hasFeature((EStructuralFeature)UmaPackage.eINSTANCE.getRole_Modifies()))) {
            if (ConfigurationErrorMatrix.isBreakdownReference(methodElement, methodElement2)) {
                n = 4;
            } else if (!ConfigurationErrorMatrix.isGuidanceReference(methodElement, methodElement2)) {
                return null;
            }
        }
        String string2 = LibraryResources.bind((String)string, (Object[])new String[]{LibraryUtil.getTypePath(methodElement), LibraryUtil.getTypePath(methodElement2)});
        return new ElementError(methodConfiguration, n, string2, methodElement, methodElement2, 16);
    }

    private static boolean isBreakdownReference(MethodElement methodElement, MethodElement methodElement2) {
        return (methodElement2 instanceof Task || methodElement2 instanceof Role || methodElement2 instanceof WorkProduct) && methodElement instanceof BreakdownElement;
    }

    private static boolean isGuidanceReference(MethodElement methodElement, MethodElement methodElement2) {
        return (methodElement instanceof Task || methodElement instanceof Role || methodElement instanceof WorkProduct) && methodElement2 instanceof Guidance;
    }

    private static ElementError getVariabilityError(MethodConfiguration methodConfiguration, ElementReference elementReference) {
        VariabilityElement variabilityElement = (VariabilityElement)elementReference.getElement();
        VariabilityElement variabilityElement2 = (VariabilityElement)elementReference.getRefElement();
        if (variabilityElement.getVariabilityBasedOnElement() != variabilityElement2) {
            return null;
        }
        VariabilityType variabilityType = variabilityElement.getVariabilityType();
        int n = 2;
        String string = LibraryResources.ElementError_missing_element;
        if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
            if (variabilityElement instanceof ContentCategory || variabilityElement instanceof Guidance) {
                n = 4;
            }
            string = LibraryResources.ElementError_contributor_missing_base;
        } else if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
            string = LibraryResources.ElementError_extender_missing_base;
        } else if (variabilityType == VariabilityType.REPLACES_LITERAL || variabilityType == VariabilityType.EXTENDS_REPLACES_LITERAL) {
            string = LibraryResources.ElementError_replacer_missing_base;
        }
        String string2 = LibraryResources.bind((String)string, (Object[])new String[]{LibraryUtil.getTypePath((MethodElement)variabilityElement), LibraryUtil.getTypePath((MethodElement)variabilityElement2)});
        return new ElementError(methodConfiguration, n, string2, variabilityElement, variabilityElement2, 16);
    }
}

