/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.layout.LayoutExtension;
import org.osgi.framework.Bundle;

public class LayoutExtensionFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "elementLayoutExtensions";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static LayoutExtensionFactory instance = null;
    private Map<String, LayoutExtensionElement> layoutElements = new HashMap<String, LayoutExtensionElement>();

    public static synchronized LayoutExtensionFactory getInstance() {
        if (instance == null) {
            instance = new LayoutExtensionFactory();
        }
        return instance;
    }

    private LayoutExtensionFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                String string = iExtension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)string);
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        LayoutExtensionElement layoutExtensionElement;
                        String string2 = iConfigurationElement.getAttribute(CLASS_ATTRIB_NAME);
                        String string3 = iConfigurationElement.getAttribute(ID_ATTRIB_NAME);
                        if (string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0 && (layoutExtensionElement = this.layoutElements.get(string3)) == null) {
                            layoutExtensionElement = new LayoutExtensionElement(bundle, string2, string3);
                            this.layoutElements.put(string3, layoutExtensionElement);
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public boolean hasExtension(String string) {
        return this.layoutElements.containsKey(string);
    }

    public LayoutExtension createExtension(String string) {
        if (!this.hasExtension(string)) {
            return null;
        }
        LayoutExtensionElement layoutExtensionElement = this.layoutElements.get(string);
        try {
            Class clazz = layoutExtensionElement.bundle.loadClass(layoutExtensionElement.className);
            return (LayoutExtension)clazz.newInstance();
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }

    private class LayoutExtensionElement {
        Bundle bundle;
        String className;
        String id;

        private LayoutExtensionElement(Bundle bundle, String string, String string2) {
            this.bundle = bundle;
            this.className = string;
            this.id = string2;
        }
    }
}

