/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorDescriptionLayout;
import org.eclipse.epf.library.layout.elements.RoleLayout;
import org.eclipse.epf.library.layout.elements.TaskLayout;
import org.eclipse.epf.library.layout.elements.WorkProductLayout;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.DescriptorDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DescriptorLayout
extends AbstractProcessElementLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromContentElement = Arrays.asList(UmaPackage.eINSTANCE.getContentElement_Assets(), UmaPackage.eINSTANCE.getContentElement_Checklists(), UmaPackage.eINSTANCE.getContentElement_ConceptsAndPapers(), UmaPackage.eINSTANCE.getContentElement_Examples(), UmaPackage.eINSTANCE.getContentElement_Guidelines(), UmaPackage.eINSTANCE.getContentElement_SupportingMaterials());
    MethodElement linkedElement = null;
    AbstractElementLayout elementLayout = null;

    @Override
    protected void __init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        super.__init(elementLayoutManager, methodElement);
        if (methodElement instanceof TaskDescriptor) {
            this.linkedElement = ((TaskDescriptor)methodElement).getTask();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, elementLayoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new TaskLayout();
            }
        } else if (methodElement instanceof RoleDescriptor) {
            this.linkedElement = ((RoleDescriptor)methodElement).getRole();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, elementLayoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new RoleLayout();
            }
        } else if (methodElement instanceof WorkProductDescriptor) {
            this.linkedElement = ((WorkProductDescriptor)methodElement).getWorkProduct();
            this.linkedElement = ConfigurationHelper.getCalculatedElement(this.linkedElement, elementLayoutManager.getElementRealizer());
            if (this.linkedElement != null) {
                this.elementLayout = new WorkProductLayout();
            }
        }
        if (this.elementLayout != null) {
            this.elementLayout.init(elementLayoutManager, this.linkedElement);
            this.elementLayout.setContentTarget(methodElement);
        }
        if (this.linkedElement != null) {
            TreeIterator treeIterator = this.linkedElement.eAllContents();
            while (treeIterator.hasNext()) {
                treeIterator.next();
            }
        }
    }

    @Override
    public Object getAttributeFeatureValue(EStructuralFeature eStructuralFeature) {
        Object object = super.getAttributeFeatureValue(eStructuralFeature);
        if (this.elementLayout == null || object != null && object.toString().length() > 0) {
            return object;
        }
        if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodElement_BriefDescription()) {
            return this.elementLayout.getAttributeFeatureValue(eStructuralFeature);
        }
        return object;
    }

    @Override
    protected IElementLayout getChildLayout(MethodElement methodElement) {
        if (this.layoutManager.getValidator().showExtraInfoForDescriptors() && methodElement instanceof DescriptorDescription) {
            DescriptorDescriptionLayout descriptorDescriptionLayout = new DescriptorDescriptionLayout(this.element);
            descriptorDescriptionLayout.init(this.layoutManager, methodElement);
            return descriptorDescriptionLayout;
        }
        return this.layoutManager.getLayout(methodElement, true);
    }

    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        return extraFeaturesFromContentElement;
    }

    @Override
    protected boolean acceptFeatureValue(EStructuralFeature eStructuralFeature, Object object) {
        Suppression suppression = super.getSuppression(this.owningProcess);
        if (suppression != null) {
            if (object instanceof List) {
                List list = (List)object;
                int n = 0;
                while (n < list.size()) {
                    Object e = list.get(n);
                    if (this.isSuppressed(suppression, eStructuralFeature, e)) {
                        list.remove(n);
                        continue;
                    }
                    ++n;
                }
                if (list.size() == 0) {
                    return false;
                }
            } else if (this.isSuppressed(suppression, eStructuralFeature, object)) {
                return false;
            }
        }
        return super.acceptFeatureValue(eStructuralFeature, object);
    }

    protected boolean isSuppressed(Suppression suppression, EStructuralFeature eStructuralFeature, Object object) {
        if (object instanceof Descriptor) {
            return suppression.isSuppressed(object);
        }
        return false;
    }

    protected boolean isTaskOppositeFeature(OppositeFeature oppositeFeature) {
        return oppositeFeature == AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors || oppositeFeature == AssociationHelper.RoleDescriptor_AdditionalTaskDescriptors || oppositeFeature == AssociationHelper.RoleDescriptor_AssistsIn_TaskDescriptors || oppositeFeature == AssociationHelper.WorkProductDescriptor_ExternalInputTo_TaskDescriptors || oppositeFeature == AssociationHelper.WorkProductDescriptor_MandatoryInputTo_TaskDescriptors || oppositeFeature == AssociationHelper.WorkProductDescriptor_OptionalInputTo_TaskDescriptors || oppositeFeature == AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors;
    }
}

