/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessConfigurator;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class MigrationUtil {
    public static Map getProcesses() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            String[] stringArray2;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray2 = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                MigrationUtil.getCapabilityPatterns((ProcessPackage)methodPackage, treeMap);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static Map getCapabilityPatterns() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getCapabilityPatterns((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static Map getDeliveryProcesses() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap treeMap = new TreeMap();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static Map getContexts(Process process) {
        if (process == null) {
            return null;
        }
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> treeMap = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        if (methodConfiguration != null) {
            treeMap.put(methodConfiguration.getName(), methodConfiguration);
        }
        List list = process.getValidContext();
        for (MethodConfiguration methodConfiguration2 : list) {
            if (methodConfiguration2 == null) continue;
            treeMap.put(methodConfiguration2.getName(), methodConfiguration2);
        }
        return treeMap;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map map) {
        List list = processPackage.getChildPackages();
        for (Object e : list) {
            if (e instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)e;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String string = process.getName();
                map.put(string, process);
                continue;
            }
            if (!(e instanceof ProcessPackage)) continue;
            MigrationUtil.getCapabilityPatterns((ProcessPackage)e, map);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map map) {
        List list = processPackage.getChildPackages();
        for (Object e : list) {
            if (e instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)e;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String string = process.getName();
                map.put(string, process);
                continue;
            }
            if (!(e instanceof ProcessPackage)) continue;
            MigrationUtil.getDeliveryProcesses((ProcessPackage)e, map);
        }
    }

    public static Map getActivities(Process process) {
        return MigrationUtil.getActivities(process, false);
    }

    public static Map getActivities(Process process, boolean bl) {
        AbstractMap abstractMap = bl ? new LinkedHashMap() : new TreeMap();
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        ProcessConfigurator processConfigurator = new ProcessConfigurator(methodConfiguration, null);
        MigrationUtil.getActivities((Activity)process, abstractMap, processConfigurator);
        return abstractMap;
    }

    protected static void getActivities(Activity activity, Map map, ProcessConfigurator processConfigurator) {
        map.put(activity.getName(), activity);
        List list = activity.getBreakdownElements();
        if (list.size() > 0) {
            for (Object e : list) {
                if (!(e instanceof Activity)) continue;
                if (processConfigurator != null && processConfigurator.accept(e)) {
                    map.put(((Activity)e).getName(), e);
                }
                if (!(e instanceof Activity)) continue;
                MigrationUtil.getActivities((Activity)e, map, processConfigurator);
            }
        }
    }
}

