/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.ui.internal;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.xml.AbstractSAXParser;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.search.ui.SearchUIPlugin;
import org.eclipse.epf.search.ui.SearchUIResources;
import org.eclipse.epf.search.ui.internal.ISearchResultCollector;
import org.eclipse.epf.search.ui.internal.MethodSearchInput;
import org.eclipse.epf.search.ui.internal.MethodSearchPattern;
import org.eclipse.epf.search.ui.internal.MethodSearchScope;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.xml.sax.Attributes;

public class MethodSearchOperation {
    private static final String SCAN_LIBRARY_TEXT = SearchUIResources.scanLibraryTask_name;
    private static final String SCAN_ELEMENT_TEXT = SearchUIResources.scanElementTask_name;
    private boolean debug;
    private MethodSearchInput searchInput;
    private ISearchResultCollector result;
    private String searchString;
    private boolean caseSensitive;
    private boolean regExp;
    private Pattern searchStringPattern;
    private Pattern elementNamePattern;
    private MethodElementScanner elementScanner;
    private List<String> parsedFiles = new ArrayList<String>();
    private IProgressMonitor progressMonitor;

    public MethodSearchOperation(MethodSearchInput methodSearchInput, ISearchResultCollector iSearchResultCollector) {
        this.searchInput = methodSearchInput;
        this.result = iSearchResultCollector;
        this.caseSensitive = methodSearchInput.getCaseSensitive();
        this.regExp = methodSearchInput.getRegularExpression();
        this.elementNamePattern = MethodSearchPattern.createPattern(methodSearchInput.getNamePattern(), false, false);
        this.debug = SearchUIPlugin.getDefault().isDebugging();
        this.searchString = methodSearchInput.getSearchString();
        if (this.searchString == null) {
            this.searchString = "";
        }
        if (this.searchString.length() > 0) {
            this.elementScanner = new MethodElementScanner();
            this.searchStringPattern = MethodSearchPattern.createPattern(this.searchString, this.caseSensitive, this.regExp);
        }
        if (this.debug) {
            System.out.println("MethodSearchOperation constructor: searchString=" + this.searchString + ", elementNamePattern=" + methodSearchInput.getNamePattern() + ", caseSensitive=" + this.caseSensitive);
        }
    }

    public void execute(IProgressMonitor iProgressMonitor) {
        this.progressMonitor = iProgressMonitor;
        this.progressMonitor.beginTask(SCAN_LIBRARY_TEXT, 7500);
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        List list = LibraryUtil.getMethodPlugins((MethodLibrary)methodLibrary);
        Iterator iterator = list.iterator();
        while (iterator.hasNext() && !iProgressMonitor.isCanceled()) {
            MethodPackage methodPackage;
            MethodPlugin methodPlugin = (MethodPlugin)iterator.next();
            this.matchPattern((MethodElement)methodPlugin);
            if (this.searchInput.getSearchScope().includeCoreContent()) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.STANDARD_CATEGORY)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.disciplineDefinitionPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.domainPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.workProductTypePath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.roleSetPath);
                this.searchMethodPackages(methodPackage);
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.toolPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.CUSTOM_CATEGORY)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
                this.searchMethodPackages(methodPackage);
            }
            if (this.searchInput.getSearchScope().include(MethodSearchScope.CAPABILITY_PATTERN)) {
                methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
                this.searchMethodPackages(methodPackage);
            }
            if (!this.searchInput.getSearchScope().include(MethodSearchScope.DELIVERY_PROCESS)) continue;
            methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
            this.searchMethodPackages(methodPackage);
        }
    }

    protected void searchMethodPackages(MethodPackage methodPackage) {
        block11: {
            ContentPackage contentPackage;
            block10: {
                Object object;
                if (methodPackage == null || methodPackage.getName().equals("Hidden")) {
                    return;
                }
                if (methodPackage instanceof ProcessComponent) {
                    object = (ProcessComponent)methodPackage;
                    this.matchPattern((MethodElement)object.getProcess());
                } else if (!this.isInternalProcessPackage(methodPackage)) {
                    this.matchPattern((MethodElement)methodPackage);
                }
                object = methodPackage.getChildPackages();
                contentPackage = object.iterator();
                while (contentPackage.hasNext() && !this.progressMonitor.isCanceled()) {
                    this.searchMethodPackages((MethodPackage)contentPackage.next());
                }
                if (!(methodPackage instanceof ContentPackage)) break block10;
                contentPackage = (ContentPackage)methodPackage;
                List list = contentPackage.getContentElements();
                Iterator iterator = list.iterator();
                while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                    ContentElement contentElement = (ContentElement)iterator.next();
                    this.matchPattern((MethodElement)contentElement);
                    if (contentElement instanceof Artifact) {
                        this.searchContainedArtifacts((Artifact)contentElement);
                        continue;
                    }
                    if (contentElement instanceof Discipline) {
                        this.searchSubDisciplines((Discipline)contentElement);
                        continue;
                    }
                    if (contentElement instanceof Practice) {
                        this.searchSubPractices((Practice)contentElement);
                        continue;
                    }
                    if (!(contentElement instanceof Domain)) continue;
                    this.searchSubDomains((Domain)contentElement);
                }
                break block11;
            }
            if (!(methodPackage instanceof ProcessPackage)) break block11;
            contentPackage = (ProcessPackage)methodPackage;
            List list = contentPackage.getProcessElements();
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                ProcessElement processElement = (ProcessElement)iterator.next();
                this.matchPattern((MethodElement)processElement);
            }
        }
    }

    protected boolean isInternalProcessPackage(MethodPackage methodPackage) {
        return methodPackage instanceof ProcessPackage && UmaUtil.getProcessComponent((MethodElement)methodPackage) != null;
    }

    protected void searchContainedArtifacts(Artifact artifact) {
        if (artifact != null) {
            Iterator iterator = artifact.getContainedArtifacts().iterator();
            while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                Artifact artifact2 = (Artifact)iterator.next();
                this.matchPattern((MethodElement)artifact2);
                this.searchContainedArtifacts(artifact2);
            }
        }
    }

    protected void searchSubDisciplines(Discipline discipline) {
        if (discipline != null) {
            Iterator iterator = discipline.getSubdiscipline().iterator();
            while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                Discipline discipline2 = (Discipline)iterator.next();
                this.matchPattern((MethodElement)discipline2);
                this.searchSubDisciplines(discipline2);
            }
        }
    }

    protected void searchSubPractices(Practice practice) {
        if (practice != null) {
            Iterator iterator = practice.getSubPractices().iterator();
            while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                Practice practice2 = (Practice)iterator.next();
                this.matchPattern((MethodElement)practice2);
                this.searchSubPractices(practice2);
            }
        }
    }

    protected void searchSubDomains(Domain domain) {
        if (domain != null) {
            Iterator iterator = domain.getSubdomains().iterator();
            while (iterator.hasNext() && !this.progressMonitor.isCanceled()) {
                Domain domain2 = (Domain)iterator.next();
                this.matchPattern((MethodElement)domain2);
                this.searchSubDomains(domain2);
            }
        }
    }

    protected void matchPattern(MethodElement methodElement) {
        block9: {
            try {
                if (!this.searchInput.getSearchScope().include(methodElement)) break block9;
                String string = methodElement.getName();
                String string2 = MessageFormat.format(SCAN_ELEMENT_TEXT, string);
                this.progressMonitor.setTaskName(string2);
                boolean bl = false;
                if (methodElement instanceof DescribableElement) {
                    String string3 = ((DescribableElement)methodElement).getPresentationName();
                    bl = string != null && this.elementNamePattern.matcher(string).matches() || string3 != null && this.elementNamePattern.matcher(string3).matches();
                } else {
                    boolean bl2 = bl = string != null && this.elementNamePattern.matcher(string).matches();
                }
                if (bl) {
                    if (this.searchString.length() == 0) {
                        this.result.accept(methodElement);
                    } else {
                        try {
                            this.elementScanner.parse(methodElement);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                this.progressMonitor.worked(1);
            }
            catch (Exception exception) {
                SearchUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            }
        }
    }

    protected String getElementPath(MethodElement methodElement) {
        DescribableElement describableElement;
        Resource resource = null;
        if (methodElement instanceof DescribableElement) {
            describableElement = (DescribableElement)methodElement;
            ContentDescription contentDescription = describableElement.getPresentation();
            if (contentDescription == null) {
                return null;
            }
            resource = contentDescription.eResource();
        } else {
            resource = methodElement.eResource();
        }
        if (resource != null && (describableElement = resource.getURI()) != null) {
            return describableElement.toFileString();
        }
        return null;
    }

    private class MethodElementScanner
    extends AbstractSAXParser {
        private MethodElement element;

        public MethodElementScanner() {
            super(null, false);
        }

        public void parse(MethodElement methodElement) {
            this.element = methodElement;
            String string = MethodSearchOperation.this.getElementPath(methodElement);
            String string2 = methodElement.getBriefDescription();
            if (MethodSearchOperation.this.searchStringPattern.matcher(string2).find()) {
                MethodSearchOperation.this.result.accept(methodElement);
            }
            if (string != null && !MethodSearchOperation.this.parsedFiles.contains(string)) {
                super.parse(string);
                MethodSearchOperation.this.parsedFiles.add(string);
            }
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            int n = 0;
            while (n < attributes.getLength()) {
                String string4 = attributes.getQName(n);
                if (!string4.equals("briefDescription")) {
                    String string5 = attributes.getValue(n);
                    if (MethodSearchOperation.this.searchStringPattern.matcher(string5).find()) {
                        MethodSearchOperation.this.result.accept(this.element);
                    }
                }
                ++n;
            }
        }

        public void endElement(String string, String string2, String string3) {
            String string4 = this.strBuf.toString();
            if (MethodSearchOperation.this.searchStringPattern.matcher(string4).find()) {
                MethodSearchOperation.this.result.accept(this.element);
            }
            this.strBuf.setLength(0);
        }
    }
}

