/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.IRichTextToolBar;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.actions.IRichTextAction;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.richtext.actions.RichTextComboAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolItem;

public class RichTextToolBar
implements IRichTextToolBar {
    private IRichText richText;
    private boolean addToolBar = true;
    private ToolBarManager toolbarMgr;
    private ToolBarManager toolbarMgrCombo;
    private List<Object> actionItems = new ArrayList<Object>();
    private static int lastWidth = -1;
    protected Composite parent;

    public RichTextToolBar(Composite composite, int n, IRichText iRichText) {
        this.parent = composite;
        this.richText = iRichText;
        this.addToolBar();
    }

    public void addAction(IAction iAction) {
        if (iAction != null) {
            ActionContributionItem actionContributionItem = new ActionContributionItem(iAction);
            this.toolbarMgr.add((IContributionItem)actionContributionItem);
            this.toolbarMgr.update(true);
            this.actionItems.add(actionContributionItem);
        }
    }

    public void addAction(RichTextComboAction richTextComboAction) {
        if (richTextComboAction != null) {
            richTextComboAction.init();
            this.toolbarMgrCombo.add((IContributionItem)richTextComboAction);
            this.toolbarMgrCombo.update(true);
            this.actionItems.add((Object)richTextComboAction);
        }
    }

    public void addSeparator() {
        this.toolbarMgr.add((IContributionItem)new Separator());
    }

    public void updateToolBar(boolean bl) {
        boolean bl2 = true;
        if (this.richText instanceof RichTextEditor && ((RichTextEditor)this.richText).isHTMLTabSelected()) {
            bl2 = false;
        }
        for (Object object : this.actionItems) {
            Object object2;
            boolean bl3;
            if (object instanceof ToolItem) {
                bl3 = true;
                object2 = (ToolItem)object;
                IRichTextAction iRichTextAction = (IRichTextAction)object2.getData();
                if (iRichTextAction != null && !bl && iRichTextAction.disableInReadOnlyMode()) {
                    bl3 = false;
                }
                if (iRichTextAction != null && !bl2 && iRichTextAction.disableInSourceMode()) {
                    bl3 = false;
                }
                object2.setEnabled(bl3);
                continue;
            }
            if (object instanceof Combo) {
                if (bl2 && bl) {
                    ((Combo)object).setEnabled(true);
                    continue;
                }
                ((Combo)object).setEnabled(false);
                continue;
            }
            if (!(object instanceof ActionContributionItem)) continue;
            bl3 = true;
            object2 = (RichTextAction)((ActionContributionItem)object).getAction();
            if (object2 != null && !bl && object2.disableInReadOnlyMode()) {
                bl3 = false;
            }
            if (object2 != null && !bl2 && object2.disableInSourceMode()) {
                bl3 = false;
            }
            object2.setEnabled(bl3);
        }
    }

    protected void addToolBar() {
        if (this.addToolBar) {
            this.toolbarMgrCombo = new ToolBarManager(0x800040 | this.parent.getStyle());
            this.toolbarMgrCombo.createControl(this.parent);
            this.toolbarMgr = new ToolBarManager(0x800040 | this.parent.getStyle());
            this.toolbarMgr.createControl(this.parent);
            this.addToolBar = false;
        }
    }

    public ToolBarManager getToolbarMgr() {
        return this.toolbarMgr;
    }

    public ToolBarManager getToolbarMgrCombo() {
        return this.toolbarMgrCombo;
    }
}

