/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EDataTypeUniqueEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.impl.LinkedObjectImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkImpl
extends LinkedObjectImpl
implements Link {
    protected static final String NAME_EDEFAULT = "";
    protected String name = "";
    protected Node target;
    protected EList<AbsoluteBendpoint> bendpoints;
    protected static final Point SOURCE_END_POINT_EDEFAULT = null;
    protected Point sourceEndPoint = SOURCE_END_POINT_EDEFAULT;
    protected static final Point TARGET_END_POINT_EDEFAULT = null;
    protected Point targetEndPoint = TARGET_END_POINT_EDEFAULT;

    protected LinkImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return ModelPackage.Literals.LINK;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        String string2 = this.name;
        this.name = string;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)string2, (Object)this.name));
        }
    }

    @Override
    public Node getSource() {
        if (this.eContainerFeatureID != 2) {
            return null;
        }
        return (Node)this.eContainer();
    }

    public NotificationChain basicSetSource(Node node, NotificationChain notificationChain) {
        notificationChain = this.eBasicSetContainer((InternalEObject)node, 2, notificationChain);
        return notificationChain;
    }

    @Override
    public void setSource(Node node) {
        if (node != this.eInternalContainer() || this.eContainerFeatureID != 2 && node != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)node)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain notificationChain = null;
            if (this.eInternalContainer() != null) {
                notificationChain = this.eBasicRemoveFromContainer(notificationChain);
            }
            if (node != null) {
                notificationChain = ((InternalEObject)node).eInverseAdd((InternalEObject)this, 5, Node.class, notificationChain);
            }
            if ((notificationChain = this.basicSetSource(node, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)node, (Object)node));
        }
    }

    @Override
    public Node getTarget() {
        if (this.target != null && this.target.eIsProxy()) {
            InternalEObject internalEObject = (InternalEObject)this.target;
            this.target = (Node)this.eResolveProxy(internalEObject);
            if (this.target != internalEObject && this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 9, 3, (Object)internalEObject, (Object)this.target));
            }
        }
        return this.target;
    }

    public Node basicGetTarget() {
        return this.target;
    }

    public NotificationChain basicSetTarget(Node node, NotificationChain notificationChain) {
        Node node2 = this.target;
        this.target = node;
        if (this.eNotificationRequired()) {
            ENotificationImpl eNotificationImpl = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)node2, (Object)node);
            if (notificationChain == null) {
                notificationChain = eNotificationImpl;
            } else {
                notificationChain.add((Notification)eNotificationImpl);
            }
        }
        return notificationChain;
    }

    @Override
    public void setTarget(Node node) {
        if (node != this.target) {
            NotificationChain notificationChain = null;
            if (this.target != null) {
                notificationChain = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 4, Node.class, notificationChain);
            }
            if (node != null) {
                notificationChain = ((InternalEObject)node).eInverseAdd((InternalEObject)this, 4, Node.class, notificationChain);
            }
            if ((notificationChain = this.basicSetTarget(node, notificationChain)) != null) {
                notificationChain.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)node, (Object)node));
        }
    }

    @Override
    public EList<AbsoluteBendpoint> getBendpoints() {
        if (this.bendpoints == null) {
            this.bendpoints = new EDataTypeUniqueEList(AbsoluteBendpoint.class, (InternalEObject)this, 4);
        }
        return this.bendpoints;
    }

    @Override
    public Point getSourceEndPoint() {
        return this.sourceEndPoint;
    }

    @Override
    public void setSourceEndPoint(Point point) {
        Point point2 = this.sourceEndPoint;
        this.sourceEndPoint = point;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, (Object)point2, (Object)this.sourceEndPoint));
        }
    }

    @Override
    public Point getTargetEndPoint() {
        return this.targetEndPoint;
    }

    @Override
    public void setTargetEndPoint(Point point) {
        Point point2 = this.targetEndPoint;
        this.targetEndPoint = point;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)point2, (Object)this.targetEndPoint));
        }
    }

    public NotificationChain eInverseAdd(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 2: {
                if (this.eInternalContainer() != null) {
                    notificationChain = this.eBasicRemoveFromContainer(notificationChain);
                }
                return this.basicSetSource((Node)internalEObject, notificationChain);
            }
            case 3: {
                if (this.target != null) {
                    notificationChain = ((InternalEObject)this.target).eInverseRemove((InternalEObject)this, 4, Node.class, notificationChain);
                }
                return this.basicSetTarget((Node)internalEObject, notificationChain);
            }
        }
        return super.eInverseAdd(internalEObject, n, notificationChain);
    }

    public NotificationChain eInverseRemove(InternalEObject internalEObject, int n, NotificationChain notificationChain) {
        switch (n) {
            case 2: {
                return this.basicSetSource(null, notificationChain);
            }
            case 3: {
                return this.basicSetTarget(null, notificationChain);
            }
        }
        return super.eInverseRemove(internalEObject, n, notificationChain);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain notificationChain) {
        switch (this.eContainerFeatureID) {
            case 2: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 5, Node.class, notificationChain);
            }
        }
        return super.eBasicRemoveFromContainerFeature(notificationChain);
    }

    @Override
    public Object eGet(int n, boolean bl, boolean bl2) {
        switch (n) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getSource();
            }
            case 3: {
                if (bl) {
                    return this.getTarget();
                }
                return this.basicGetTarget();
            }
            case 4: {
                return this.getBendpoints();
            }
            case 5: {
                return this.getSourceEndPoint();
            }
            case 6: {
                return this.getTargetEndPoint();
            }
        }
        return super.eGet(n, bl, bl2);
    }

    @Override
    public void eSet(int n, Object object) {
        switch (n) {
            case 1: {
                this.setName((String)object);
                return;
            }
            case 2: {
                this.setSource((Node)object);
                return;
            }
            case 3: {
                this.setTarget((Node)object);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                this.getBendpoints().addAll((Collection)object);
                return;
            }
            case 5: {
                this.setSourceEndPoint((Point)object);
                return;
            }
            case 6: {
                this.setTargetEndPoint((Point)object);
                return;
            }
        }
        super.eSet(n, object);
    }

    @Override
    public void eUnset(int n) {
        switch (n) {
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setSource(null);
                return;
            }
            case 3: {
                this.setTarget(null);
                return;
            }
            case 4: {
                this.getBendpoints().clear();
                return;
            }
            case 5: {
                this.setSourceEndPoint(SOURCE_END_POINT_EDEFAULT);
                return;
            }
            case 6: {
                this.setTargetEndPoint(TARGET_END_POINT_EDEFAULT);
                return;
            }
        }
        super.eUnset(n);
    }

    @Override
    public boolean eIsSet(int n) {
        switch (n) {
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.getSource() != null;
            }
            case 3: {
                return this.target != null;
            }
            case 4: {
                return this.bendpoints != null && !this.bendpoints.isEmpty();
            }
            case 5: {
                return SOURCE_END_POINT_EDEFAULT == null ? this.sourceEndPoint != null : !SOURCE_END_POINT_EDEFAULT.equals((Object)this.sourceEndPoint);
            }
            case 6: {
                return TARGET_END_POINT_EDEFAULT == null ? this.targetEndPoint != null : !TARGET_END_POINT_EDEFAULT.equals((Object)this.targetEndPoint);
            }
        }
        return super.eIsSet(n);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(super.toString());
        stringBuffer.append(" (name: ");
        stringBuffer.append(this.name);
        stringBuffer.append(", bendpoints: ");
        stringBuffer.append(this.bendpoints);
        stringBuffer.append(", sourceEndPoint: ");
        stringBuffer.append(this.sourceEndPoint);
        stringBuffer.append(", targetEndPoint: ");
        stringBuffer.append(this.targetEndPoint);
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public void setObject(Object object) {
        super.setObject(object);
        if (object == null) {
            return;
        }
        GraphEdge graphEdge = (GraphEdge)object;
        Iterator iterator = graphEdge.getWaypoints().iterator();
        while (iterator.hasNext()) {
            this.getBendpoints().add((Object)new AbsoluteBendpoint(GraphicalDataHelper.toPoint((org.eclipse.epf.uma.Point)iterator.next())));
        }
        if (this.getSourceGraphConnector().getPosition() != null) {
            this.sourceEndPoint = GraphicalDataHelper.toPoint(this.getSourceGraphConnector().getPosition());
        }
        if (this.getTargetGraphConnector().getPosition() != null) {
            this.targetEndPoint = GraphicalDataHelper.toPoint(this.getTargetGraphConnector().getPosition());
        }
        this.eAdapters().add((Object)new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                GraphEdge graphEdge = (GraphEdge)LinkImpl.this.getObject();
                switch (notification.getFeatureID(Link.class)) {
                    case 4: {
                        switch (notification.getEventType()) {
                            case 3: {
                                AbsoluteBendpoint absoluteBendpoint = (AbsoluteBendpoint)notification.getNewValue();
                                int n = notification.getPosition();
                                org.eclipse.epf.uma.Point point = GraphicalDataHelper.newModelPoint(absoluteBendpoint.x, absoluteBendpoint.y);
                                if (n == -1) {
                                    graphEdge.getWaypoints().add(point);
                                } else {
                                    graphEdge.getWaypoints().add(n, point);
                                }
                                return;
                            }
                            case 4: {
                                int n = notification.getPosition();
                                if (n == -1) {
                                    graphEdge.getWaypoints().remove(notification.getPosition());
                                } else {
                                    graphEdge.getWaypoints().remove(n);
                                }
                                return;
                            }
                            case 5: {
                                Collection collection = (Collection)notification.getNewValue();
                                ArrayList<org.eclipse.epf.uma.Point> arrayList = new ArrayList<org.eclipse.epf.uma.Point>();
                                for (AbsoluteBendpoint absoluteBendpoint : collection) {
                                    arrayList.add(GraphicalDataHelper.newModelPoint(absoluteBendpoint.x, absoluteBendpoint.y));
                                }
                                int n = notification.getPosition();
                                if (n == -1) {
                                    graphEdge.getWaypoints().addAll(arrayList);
                                } else {
                                    graphEdge.getWaypoints().addAll(n, arrayList);
                                }
                                return;
                            }
                            case 1: {
                                AbsoluteBendpoint absoluteBendpoint = (AbsoluteBendpoint)notification.getNewValue();
                                int n = notification.getPosition();
                                org.eclipse.epf.uma.Point point = GraphicalDataHelper.newModelPoint(absoluteBendpoint.x, absoluteBendpoint.y);
                                if (n == -1) {
                                    System.out.println("Index for bendpoint is -1, Cannot set the bend point location.");
                                } else {
                                    graphEdge.getWaypoints().remove(n);
                                    graphEdge.getWaypoints().add(n, point);
                                }
                                return;
                            }
                        }
                        return;
                    }
                    case 5: {
                        Point point = (Point)notification.getNewValue();
                        if (point != null) {
                            LinkImpl.this.getSourceGraphConnector().setPosition(GraphicalDataHelper.newModelPoint(point.x, point.y));
                        }
                        return;
                    }
                    case 6: {
                        Point point = (Point)notification.getNewValue();
                        if (point != null) {
                            LinkImpl.this.getTargetGraphConnector().setPosition(GraphicalDataHelper.newModelPoint(point.x, point.y));
                        }
                        return;
                    }
                    case 2: {
                        return;
                    }
                    case 3: {
                        return;
                    }
                }
            }
        });
    }

    private GraphConnector getSourceGraphConnector() {
        return (GraphConnector)((GraphEdge)this.getObject()).getAnchor().get(0);
    }

    private GraphConnector getTargetGraphConnector() {
        return (GraphConnector)((GraphEdge)this.getObject()).getAnchor().get(1);
    }
}

