/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.wpdd.part;

import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.WorkProductDependencyDiagram;
import org.eclipse.epf.diagram.model.WorkProductNode;
import org.eclipse.epf.diagram.wpdd.part.WPDDiagramEditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

public class DiagramVisualIDRegistry {
    private static final String DEBUG_KEY = String.valueOf(WPDDiagramEditorPlugin.getInstance().getBundle().getSymbolicName()) + "/debug/visualID";

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("WPDD".equals(view.getType())) {
                return 79;
            }
            return -1;
        }
        return DiagramVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation eAnnotation = view.getEAnnotation("Shortcut");
            if (eAnnotation != null) {
                return (String)eAnnotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                WPDDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + string);
            }
            return -1;
        }
    }

    public static String getType(int n) {
        return String.valueOf(n);
    }

    public static int getDiagramVisualID(EObject eObject) {
        if (eObject == null) {
            return -1;
        }
        EClass eClass = eObject.eClass();
        return DiagramVisualIDRegistry.getDiagramVisualID(eObject, eClass);
    }

    private static int getDiagramVisualID(EObject eObject, EClass eClass) {
        if (ModelPackage.eINSTANCE.getWorkProductDependencyDiagram().isSuperTypeOf(eClass) && DiagramVisualIDRegistry.isDiagramWorkProductDependencyDiagram_79((WorkProductDependencyDiagram)eObject)) {
            return 79;
        }
        return DiagramVisualIDRegistry.getUnrecognizedDiagramID(eObject);
    }

    public static int getNodeVisualID(View view, EObject eObject) {
        if (eObject == null) {
            return -1;
        }
        EClass eClass = eObject.eClass();
        return DiagramVisualIDRegistry.getNodeVisualID(view, eObject, eClass, null);
    }

    public static int getNodeVisualID(View view, EObject eObject, EClass eClass, String string) {
        int n;
        String string2 = DiagramVisualIDRegistry.getModelID(view);
        if (!"WPDD".equals(string2)) {
            return -1;
        }
        if ("WPDD".equals(string2)) {
            n = DiagramVisualIDRegistry.getVisualID(view);
        } else if (view instanceof Diagram) {
            n = 79;
        } else {
            return -1;
        }
        int n2 = string != null ? DiagramVisualIDRegistry.getVisualID(string) : -1;
        switch (n) {
            case 1001: {
                if (4001 == n2) {
                    return 4001;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductNode_1001ChildNodeID(eObject, string);
            }
            case 79: {
                if ((string == null || 1001 == n2) && ModelPackage.eINSTANCE.getWorkProductNode().isSuperTypeOf(eClass) && (eObject == null || DiagramVisualIDRegistry.isNodeWorkProductNode_1001((WorkProductNode)eObject))) {
                    return 1001;
                }
                return DiagramVisualIDRegistry.getUnrecognizedWorkProductDependencyDiagram_79ChildNodeID(eObject, string);
            }
            case 3001: {
                if (4002 == n2) {
                    return 4002;
                }
                return DiagramVisualIDRegistry.getUnrecognizedLink_3001LinkLabelID(string);
            }
        }
        return -1;
    }

    public static int getLinkWithClassVisualID(EObject eObject) {
        if (eObject == null) {
            return -1;
        }
        EClass eClass = eObject.eClass();
        return DiagramVisualIDRegistry.getLinkWithClassVisualID(eObject, eClass);
    }

    public static int getLinkWithClassVisualID(EObject eObject, EClass eClass) {
        if (ModelPackage.eINSTANCE.getLink().isSuperTypeOf(eClass) && (eObject == null || DiagramVisualIDRegistry.isLinkWithClassLink_3001((Link)eObject))) {
            return 3001;
        }
        return DiagramVisualIDRegistry.getUnrecognizedLinkWithClassID(eObject);
    }

    private static boolean isDiagramWorkProductDependencyDiagram_79(WorkProductDependencyDiagram workProductDependencyDiagram) {
        return true;
    }

    private static int getUnrecognizedDiagramID(EObject eObject) {
        return -1;
    }

    private static boolean isNodeWorkProductNode_1001(WorkProductNode workProductNode) {
        return true;
    }

    private static int getUnrecognizedWorkProductNode_1001ChildNodeID(EObject eObject, String string) {
        return -1;
    }

    private static int getUnrecognizedWorkProductDependencyDiagram_79ChildNodeID(EObject eObject, String string) {
        return -1;
    }

    private static int getUnrecognizedLink_3001LinkLabelID(String string) {
        return -1;
    }

    private static int getUnrecognizedLinkWithClassID(EObject eObject) {
        return -1;
    }

    private static boolean isLinkWithClassLink_3001(Link link) {
        return true;
    }
}

