/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.service.utils.CommandLineRunner;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommandLinePluginImporter
extends CommandLineRunner {
    private static String ImportPluginsTag = "ImportPlugins";
    private static String SelectedPluginTag = "SelectedPlugin";
    private static String BaseLibraryFolderUriAtt = "baseLibraryFolderUri";
    private static String ImportLibraryFolderUriAtt = "importLibraryFolderUri";
    private static String NameAtt = "name";
    private String baseLibPath;
    private String importLibPath;
    private Set<String> selectedPlugins;

    public boolean execute(String[] stringArray) {
        if (!super.execute(stringArray)) {
            return false;
        }
        try {
            this.loadInputFile();
            WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

                public void execute(IProgressMonitor iProgressMonitor) {
                    try {
                        try {
                            iProgressMonitor.setTaskName("Openning base library and preparing import ...");
                            XMILibraryUtil.openMethodLibrary((String)CommandLinePluginImporter.this.baseLibPath);
                            File file = new File(CommandLinePluginImporter.this.importLibPath);
                            PluginImportData pluginImportData = new PluginImportData();
                            pluginImportData.llData.setLibName(file.getName());
                            pluginImportData.llData.setParentFolder(file.getAbsolutePath());
                            PluginImportingService pluginImportingService = new PluginImportingService(pluginImportData);
                            pluginImportingService.validate(null);
                            List list = pluginImportData.getPlugins();
                            int n = 0;
                            while (n < list.size()) {
                                PluginImportData.PluginInfo pluginInfo = (PluginImportData.PluginInfo)list.get(n);
                                pluginInfo.selected = CommandLinePluginImporter.this.selectedPlugins.isEmpty() || CommandLinePluginImporter.this.selectedPlugins.contains(pluginInfo.name);
                                ++n;
                            }
                            pluginImportingService.performImport(iProgressMonitor);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            iProgressMonitor.done();
                        }
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            progressMonitorDialog.run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    private void loadInputFile() throws Exception {
        Document document = XMLUtil.loadXml((File)this.getInputFile());
        Element element = document.getDocumentElement();
        if (!element.getTagName().equals(ImportPluginsTag)) {
            String string = "The root element must be:  " + ImportPluginsTag;
            throw new RuntimeException(string);
        }
        this.baseLibPath = element.getAttribute(BaseLibraryFolderUriAtt);
        this.importLibPath = element.getAttribute(ImportLibraryFolderUriAtt);
        this.selectedPlugins = new HashSet<String>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList == null ? 0 : nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element2;
            Node node = nodeList.item(n2);
            if (node instanceof Element && (element2 = (Element)node).getTagName().equals(SelectedPluginTag)) {
                String string = element2.getAttribute(NameAtt);
                this.selectedPlugins.add(string);
            }
            ++n2;
        }
    }
}

