/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.services.ISiteGenerator;
import org.eclipse.epf.publishing.services.PublishHTMLOptions;
import org.eclipse.epf.publishing.services.PublishOptions;

public abstract class AbstractSiteGenerator
implements ISiteGenerator {
    public static final String DOC_ROOT = "docroot/";
    private static final String WEB_INF_PATH = "docroot/WEB-INF";
    private static final String WEB_INF_DIR = "WEB-INF";
    protected String pubDir;
    protected PublishHTMLOptions options;
    protected HtmlBuilder builder;

    public AbstractSiteGenerator(HtmlBuilder htmlBuilder, PublishHTMLOptions publishHTMLOptions) {
        this.options = publishHTMLOptions;
        this.builder = htmlBuilder;
        this.pubDir = htmlBuilder.getPublishDir();
    }

    public abstract HtmlBuilder getHtmlBuilder();

    public abstract String getIndexFilePath();

    public abstract String getNodeIconPath();

    public abstract String getDefaultBannerImageFile();

    public abstract PublishOptions getPublishOptions();

    public abstract void postPublish() throws Exception;

    public abstract void prePublish() throws Exception;

    public abstract void writePublishedBookmarks(List var1, Bookmark var2) throws Exception;

    protected void copyCustomizedFiles() throws Exception {
        if (this.options.bannerImage != null && this.options.bannerImage.length() > 0) {
            FileUtil.copyFile((String)this.options.bannerImage, (String)(String.valueOf(this.pubDir) + "images"));
            this.options.bannerImage = FileUtil.getFileName((String)this.options.bannerImage);
        } else {
            this.options.bannerImage = this.getDefaultBannerImageFile();
        }
        if (this.options.isPublishDynamicWebApp()) {
            URL uRL = PublishingPlugin.getDefault().getInstallURL();
            String string = FileLocator.resolve((URL)new URL(uRL, WEB_INF_PATH)).getPath();
            String string2 = "*.*, **/";
            LayoutResources.copyDir((String)string, (String)(String.valueOf(this.pubDir) + WEB_INF_DIR), (String)string2, null);
        }
    }

    protected void copyLocalizedFiles() throws Exception {
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/scripts/", new File(this.pubDir, "scripts/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles("docroot/images/", new File(this.pubDir, "images/"), true, false);
        PublishingPlugin.getDefault().copyLocalizedFiles(DOC_ROOT, new File(this.pubDir, "/"), false, false);
    }

    protected String getViewDataFileName(Bookmark bookmark, String string) {
        File file = new File(bookmark.getFileName());
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n >= 0) {
            string2 = string2.substring(0, n);
        }
        return String.valueOf(string2) + string;
    }

    public void dispose() {
        if (this.builder != null) {
            this.builder.getLayoutManager().clear();
            this.builder.dispose();
            this.builder = null;
        }
    }
}

