/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.common.serviceability.DebugTrace;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.layout.Bookmark;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.publishing.PublishingPlugin;
import org.eclipse.epf.publishing.PublishingResources;
import org.eclipse.epf.publishing.services.AbstractPublishManager;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ConfigurationViewBuilder;
import org.eclipse.epf.publishing.services.DefaultSiteGenerator;
import org.eclipse.epf.publishing.services.GlossaryBuilder;
import org.eclipse.epf.publishing.services.ProcessPublishingContentValidator;
import org.eclipse.epf.publishing.services.ProcessPublishingElementRealizer;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.publishing.services.PublishingElementRealizer;
import org.eclipse.epf.publishing.services.index.DefinitionObject;
import org.eclipse.epf.publishing.services.index.KeyWordIndexHelper;
import org.eclipse.epf.publishing.util.PublishingUtil;
import org.eclipse.epf.search.SearchService;

public class PublishManager
extends AbstractPublishManager {
    protected static final String KEYWORD_DEF_FILE = "keywordindexdef.txt";
    protected static final String PUBLISHING_REPORT_XSL_FILE = "xsl/PublishingReport.xsl";
    protected static final String PUBLISHING_REPORT_HTML_FILE = "PublishingReport.html";

    protected AbstractViewBuilder createViewBuilder() {
        PublishingContentValidator publishingContentValidator = null;
        PublishingElementRealizer publishingElementRealizer = null;
        if (this.options != null && this.options.publishProcess) {
            publishingContentValidator = new ProcessPublishingContentValidator(this.pubDir, this.options);
            publishingElementRealizer = new ProcessPublishingElementRealizer(this.config, (ProcessPublishingContentValidator)publishingContentValidator);
        } else {
            publishingContentValidator = new PublishingContentValidator(this.pubDir, this.options);
            publishingElementRealizer = new PublishingElementRealizer(this.config, publishingContentValidator);
        }
        ElementLayoutManager elementLayoutManager = new ElementLayoutManager(this.config, this.pubDir, (IContentValidator)publishingContentValidator, true);
        elementLayoutManager.setElementRealizer((ElementRealizer)publishingElementRealizer);
        HtmlBuilder htmlBuilder = new HtmlBuilder(elementLayoutManager);
        htmlBuilder.enableContentScan(true);
        htmlBuilder.enableTreeBrowser(true);
        DefaultSiteGenerator defaultSiteGenerator = new DefaultSiteGenerator(htmlBuilder, this.options);
        return new ConfigurationViewBuilder(defaultSiteGenerator);
    }

    protected void prePublish(IProgressMonitor iProgressMonitor) throws Exception {
        iProgressMonitor.subTask(PublishingResources.initializingDirTask_name);
        File file = new File(this.viewBuilder.getHtmlBuilder().getPublishDir());
        if (!file.exists()) {
            file.mkdirs();
        }
        iProgressMonitor.subTask(PublishingResources.copyingFilesTask_name);
        this.getSiteGenerator().prePublish();
    }

    protected void doPublish(IProgressMonitor iProgressMonitor) throws Exception {
        String string;
        Collection<Resource> collection = this.loadLibrary(iProgressMonitor);
        Collection collection2 = DiagramManager.getDiagramManagers();
        iProgressMonitor.subTask(PublishingResources.generatingBookmarksTask_name);
        this.generateBookmarks(iProgressMonitor);
        String string2 = string = this.options == null ? "" : this.options.getTitle();
        if (!iProgressMonitor.isCanceled() && (this.options == null || this.options.isPublishGlossary())) {
            iProgressMonitor.subTask(PublishingResources.generatingGlossaryTask_name);
            new GlossaryBuilder().execute(this.config, this.pubDir, string, iProgressMonitor);
        }
        Collection collection3 = DiagramManager.getDiagramManagers();
        PublishingUtil.disposeDiagramManagers(collection3, collection2);
        PublishingUtil.unloadResources(collection);
        collection.clear();
        collection2.clear();
        collection3.clear();
        Runtime.getRuntime().gc();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (this.options == null || this.options.isPublishIndex()) {
            iProgressMonitor.subTask(PublishingResources.generatingBookmarkIndexTask_name);
            this.generateBookmarkIndex(this.pubDir, string, iProgressMonitor);
        }
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (this.options != null && this.options.isPublishDynamicWebApp() && this.options.isIncludeServletSearch()) {
            iProgressMonitor.subTask(PublishingResources.generatingSearchIndexTask_name);
            SearchService.getInstance().createIndex(this.pubDir, false);
        }
    }

    protected void postPublish(IProgressMonitor iProgressMonitor) throws Exception {
        this.getSiteGenerator().postPublish();
        this.createWARFile();
        this.getPublishReportUrl();
    }

    private void generateBookmarks(IProgressMonitor iProgressMonitor) throws Exception {
        long l = 0L;
        long l2 = 0L;
        if (profiling) {
            l = l2 = System.currentTimeMillis();
        }
        List<Bookmark> list = this.viewBuilder.buildViews(iProgressMonitor);
        if (profiling) {
            DebugTrace.print((Object)this.viewBuilder, (String)"buildViews", (String)(String.valueOf(System.currentTimeMillis() - l2) + " ms"));
        }
        Bookmark bookmark = this.viewBuilder.getDefaultView();
        if (iProgressMonitor.isCanceled()) {
            return;
        }
        if (profiling) {
            l2 = System.currentTimeMillis();
        }
        this.getSiteGenerator().writePublishedBookmarks(list, bookmark);
        if (profiling) {
            DebugTrace.print((Object)this.getSiteGenerator(), (String)"writePublishedBookmarks", (String)(String.valueOf(System.currentTimeMillis() - l2) + " ms"));
            DebugTrace.print((Object)this, (String)"generateBookmarks", (String)(String.valueOf(System.currentTimeMillis() - l) + " ms"));
        }
    }

    public String getPublishedUrl() {
        String string;
        File file;
        if (this.success && (file = new File(string = this.getSiteGenerator().getIndexFilePath())).exists()) {
            return string;
        }
        return null;
    }

    protected void generateBookmarkIndex(String string, String string2, IProgressMonitor iProgressMonitor) {
        try {
            String string3;
            String string4;
            URL uRL = new URL(PublishingPlugin.getDefault().getInstallURL(), KEYWORD_DEF_FILE);
            if (uRL == null) {
                System.out.println("Unable to get index definition file ");
                return;
            }
            String string5 = Platform.resolve((URL)uRL).getPath();
            KeyWordIndexHelper keyWordIndexHelper = new KeyWordIndexHelper(string5, string4 = "utf-8", string3 = null);
            DefinitionObject definitionObject = keyWordIndexHelper.loadDefinition(string);
            if (definitionObject != null) {
                definitionObject.setwwwRoot(string);
                definitionObject.setIndexTitle(String.valueOf(PublishingResources.indexLabel_text) + " - " + string2);
            }
            keyWordIndexHelper.execute(iProgressMonitor);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getPublishReportUrl() {
        String string = this.viewBuilder.getHtmlBuilder().getPublishDir();
        String string2 = "logs" + File.separator + PUBLISHING_REPORT_HTML_FILE;
        File file = new File(string, string2);
        String string3 = file.getAbsolutePath();
        if (!file.exists()) {
            File file2 = new File(string, "logs" + File.separator + "error.log");
            File file3 = new File(string, "logs" + File.separator + "warning.log");
            File file4 = new File(string, "logs" + File.separator + "info.log");
            XmlElement xmlElement = new XmlElement("PublishingReport");
            xmlElement.newChild("pubDir").setAttribute("path", string);
            xmlElement.newChild("errorLog").setAttribute("name", "error.log").setAttribute("path", "./" + file2.getName());
            xmlElement.newChild("warningLog").setAttribute("name", "warning.log").setAttribute("path", "./" + file3.getName());
            xmlElement.newChild("infoLog").setAttribute("name", "info.log").setAttribute("path", "./" + file4.getName());
            PublishingContentValidator publishingContentValidator = (PublishingContentValidator)this.viewBuilder.getHtmlBuilder().getValidator();
            xmlElement.addChild(publishingContentValidator.getReport());
            String string4 = PublishingUtil.getHtml(xmlElement, PUBLISHING_REPORT_XSL_FILE);
            if (string4 != null) {
                FileUtil.writeUTF8File((String)string3, (String)string4.toString());
            }
        }
        return string3;
    }

    protected void createWARFile() throws Exception {
        if (this.options != null && this.options.isPublishDynamicWebApp() && this.options.getDynamicWebAppName().length() > 0) {
            SearchService.getInstance().createWAR(this.pubDir, this.options.getDynamicWebAppName());
        }
    }

    public void dispose() {
        super.dispose();
    }
}

