/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.RelativeXYAnchor;
import org.eclipse.epf.authoring.gef.figures.Diamond;
import org.eclipse.epf.authoring.gef.util.AnchorUtil;
import org.eclipse.epf.authoring.gef.util.ConnectionAnchorLocator;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.CreateConnectionRequest;
import org.eclipse.gef.requests.LocationRequest;
import org.eclipse.swt.graphics.Color;

public class DecisionNodeEditPart
extends NodeEditPart
implements ConnectionAnchorLocator {
    private static final Color BG_COLOR = new Color(null, 254, 204, 153);
    private Point recentSourceEndPoint;
    private Point recentTargetEndPoint;

    public DecisionNodeEditPart(TypedNode typedNode) {
        super((Node)typedNode);
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return null;
    }

    protected IFigure createFigure() {
        Diamond diamond = new Diamond();
        diamond.setBackgroundColor(BG_COLOR);
        diamond.setSize(48, 24);
        return diamond;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connectionEditPart) {
        Point point;
        boolean bl = false;
        if (this.recentSourceEndPoint == null) {
            Link link = (Link)connectionEditPart.getModel();
            point = link.getSourceEndPoint();
            bl = true;
        } else {
            point = this.recentSourceEndPoint;
        }
        if (point != null) {
            return new RelativeXYAnchor(this.getFigure(), point, bl);
        }
        return super.getSourceConnectionAnchor(connectionEditPart);
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        Point point = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            point = createConnectionRequest.getLocation();
        } else if (request instanceof LocationRequest) {
            point = ((LocationRequest)request).getLocation();
        }
        if (point != null) {
            this.recentSourceEndPoint = this.getLocation(point);
            return new RelativeXYAnchor(this.getFigure(), this.recentSourceEndPoint, true);
        }
        return super.getSourceConnectionAnchor(request);
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connectionEditPart) {
        Point point;
        boolean bl = false;
        if (this.recentTargetEndPoint == null) {
            Link link = (Link)connectionEditPart.getModel();
            point = link.getTargetEndPoint();
            bl = true;
        } else {
            point = this.recentTargetEndPoint;
        }
        if (point != null) {
            return new RelativeXYAnchor(this.getFigure(), point, bl);
        }
        return super.getTargetConnectionAnchor(connectionEditPart);
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        Point point = null;
        if (request instanceof CreateConnectionRequest) {
            CreateConnectionRequest createConnectionRequest = (CreateConnectionRequest)request;
            point = createConnectionRequest.getLocation();
        } else if (request instanceof LocationRequest) {
            point = ((LocationRequest)request).getLocation();
        }
        if (point != null) {
            this.recentTargetEndPoint = this.getLocation(point);
            return new RelativeXYAnchor(this.getFigure(), this.recentTargetEndPoint, true);
        }
        return super.getTargetConnectionAnchor(request);
    }

    public Point getLocation(Point point) {
        Point point2;
        Diamond diamond = (Diamond)this.getFigure();
        Point[] pointArray = new Point[diamond.getPoints().size()];
        int n = diamond.getPoints().size() - 1;
        while (n > -1) {
            point2 = diamond.getPoints().getPoint(n);
            diamond.translateToAbsolute((Translatable)point2);
            pointArray[n] = point2;
            --n;
        }
        Point point3 = AnchorUtil.getClosestPoint(pointArray, point);
        if (point3 != null) {
            point2 = diamond.getBounds().getCopy();
            diamond.translateToAbsolute((Translatable)point2);
            point3.performTranslate(-point2.x, -point2.y);
        }
        return point3;
    }
}

