/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class ChangeHistoryDialog
extends Dialog {
    protected Button okButton;
    protected Button cancelButton;
    private MethodElement element;
    private Table table;

    public ChangeHistoryDialog(Shell shell, MethodElement methodElement) {
        super(shell);
        this.element = methodElement;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 1;
        GridData gridData = (GridData)composite2.getLayoutData();
        gridData.verticalIndent = 10;
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.ChangeHistoryDialog_label);
        this.table = new Table(composite2, 2050);
        GridData gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 2;
        gridData2.widthHint = 400;
        gridData2.heightHint = 300;
        this.table.setLayoutData((Object)gridData2);
        this.table.setLinesVisible(true);
        this.initChangeHistoryTable();
        super.getShell().setText(AuthoringUIResources.ChangeHistoryDialog_title);
        return composite2;
    }

    private void initChangeHistoryTable() {
        ContentDescription contentDescription;
        String string = null;
        if (this.element instanceof ContentElement) {
            contentDescription = ((ContentElement)this.element).getPresentation();
            string = contentDescription.getChangeDescription();
        }
        if (this.element instanceof MethodPlugin) {
            string = ((MethodPlugin)this.element).getChangeDescription();
        }
        if (string != null) {
            contentDescription = new StringTokenizer(string, AuthoringUIResources.ChangeHistoryDialog_delimiter);
            ArrayList<String> arrayList = new ArrayList<String>();
            while (contentDescription.hasMoreTokens()) {
                arrayList.add(contentDescription.nextToken());
            }
            int n = arrayList.size() - 1;
            while (n >= 0) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText((String)arrayList.get(n));
                --n;
            }
        }
    }

    protected void createButtonsForButtonBar(Composite composite) {
        this.createButton(composite, 0, IDialogConstants.OK_LABEL, true);
        this.okButton = super.getButton(0);
    }

    protected void okPressed() {
        super.okPressed();
    }
}

