/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.AddLinkFilter;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.dialogs.AddLinkDialog;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MethodAddLinkDialog
extends AddLinkDialog {
    private static final int LINK_URL = 0;
    private static final int LINK_FILE = 1;
    private static final int LINK_ELEMENT_LINK_WITH_TYPE = 3;
    private static final int LINK_ELEMENT_LINK_WITH_USER_TEXT = 4;
    private static final String[] ELEMENT_TYPE_LABELS = new String[]{LibraryUIResources.linkToURL_name, LibraryUIResources.linkToFile_name, LibraryUIResources.elementLink_name, LibraryUIResources.elementLinkWithType_name, LibraryUIResources.elementLinkWithUserText_name};
    public static final String OPEN_LINK_IN_NEW_WINDOW_ATTRIBUTE = "target=\"_blank\"";
    private IMethodRichText richText;
    private MethodElement methodElement;
    private String elementLoc;
    private Combo linkTypeCombo;
    private Button browseButton;
    private Button openLinkCheckbox;
    private int linkType;
    private boolean openLinkInNewWindow = true;
    private File fileToCopy;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            if (((BaseDialog)MethodAddLinkDialog.this).okButton != null) {
                try {
                    if (MethodAddLinkDialog.this.linkType == 1 && modifyEvent.widget == MethodAddLinkDialog.this.urlText) {
                        File file = new File(MethodAddLinkDialog.this.urlText.getText().trim());
                        if (file.isAbsolute()) {
                            MethodAddLinkDialog.this.fileToCopy = file;
                        } else {
                            MethodAddLinkDialog.this.fileToCopy = new File(MethodAddLinkDialog.this.elementLoc, MethodAddLinkDialog.this.urlText.getText().trim());
                        }
                        ((BaseDialog)MethodAddLinkDialog.this).okButton.setEnabled(MethodAddLinkDialog.this.fileToCopy.isFile() && MethodAddLinkDialog.this.fileToCopy.canRead());
                    } else {
                        ((BaseDialog)MethodAddLinkDialog.this).okButton.setEnabled(MethodAddLinkDialog.this.urlText.getText().trim().length() > 0);
                    }
                }
                catch (Exception exception) {
                    ((BaseDialog)MethodAddLinkDialog.this).okButton.setEnabled(false);
                }
            }
        }
    };

    public MethodAddLinkDialog(Shell shell, IMethodRichText iMethodRichText) {
        super(shell, iMethodRichText.getBasePath());
        this.richText = iMethodRichText;
        this.methodElement = iMethodRichText.getMethodElement();
        this.elementLoc = ResourceHelper.getFolderAbsolutePath((MethodElement)this.methodElement);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.addLinkDialog_linkType);
        label.moveAbove((Control)this.urlLabel);
        this.urlText.removeModifyListener(this.urlTextModifyListener);
        this.urlText.addModifyListener(this.modifyListener);
        this.linkTypeCombo = new Combo(composite2, 2056);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.linkTypeCombo.setLayoutData((Object)gridData);
        this.linkTypeCombo.setItems(ELEMENT_TYPE_LABELS);
        this.linkTypeCombo.setText(ELEMENT_TYPE_LABELS[0]);
        this.linkTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodAddLinkDialog.this.linkType = MethodAddLinkDialog.this.linkTypeCombo.getSelectionIndex();
                MethodAddLinkDialog.this.browseButton.setEnabled(MethodAddLinkDialog.this.linkType != 0);
                MethodAddLinkDialog.this.urlDisplayNameLabel.setEnabled(MethodAddLinkDialog.this.linkType == 0);
                MethodAddLinkDialog.this.urlDisplayNameText.setEnabled(MethodAddLinkDialog.this.linkType == 0);
                if (MethodAddLinkDialog.this.linkType == 0) {
                    MethodAddLinkDialog.this.urlDisplayNameText.setText(MethodAddLinkDialog.this.richText.getSelected().getText());
                } else {
                    MethodAddLinkDialog.this.urlDisplayNameText.setText("");
                }
                MethodAddLinkDialog.this.openLinkCheckbox.setEnabled(MethodAddLinkDialog.this.linkType == 0 || MethodAddLinkDialog.this.linkType == 1);
                MethodAddLinkDialog.this.urlText.setText("");
                if (MethodAddLinkDialog.this.linkType != 1) {
                    MethodAddLinkDialog.this.fileToCopy = null;
                }
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.linkTypeCombo.moveAbove((Control)this.urlLabel);
        this.browseButton = new Button(composite2, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (MethodAddLinkDialog.this.linkType == 1) {
                    FileDialog fileDialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    fileDialog.setFilterPath(MethodAddLinkDialog.this.basePath);
                    String string = fileDialog.open();
                    if (string != null && string.length() > 0) {
                        try {
                            File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                            MethodAddLinkDialog.this.urlText.setText(file.getAbsolutePath());
                        }
                        catch (Exception exception) {
                            ((BaseDialog)MethodAddLinkDialog.this).logger.logError((Throwable)exception);
                        }
                    }
                } else {
                    AddLinkFilter addLinkFilter = new AddLinkFilter(){

                        protected boolean childAccept(Object object) {
                            if (object instanceof MethodPlugin) {
                                return true;
                            }
                            if (object instanceof MethodConfiguration) {
                                return false;
                            }
                            return !(object instanceof Milestone);
                        }
                    };
                    ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)addLinkFilter, MethodAddLinkDialog.this.methodElement, FilterConstants.ALL_ELEMENTS);
                    itemsFilterDialog.setBlockOnOpen(true);
                    itemsFilterDialog.setTitle(FilterConstants.ALL_ELEMENTS);
                    itemsFilterDialog.open();
                    ArrayList arrayList = itemsFilterDialog.getSelectedItems();
                    if (arrayList.size() > 0) {
                        MethodElement methodElement = (MethodElement)arrayList.get(0);
                        String string = null;
                        String string2 = ResourceHelper.getUrl((MethodElement)methodElement, (MethodElement)MethodAddLinkDialog.this.methodElement, (String)"html");
                        if (MethodAddLinkDialog.this.linkType == 4) {
                            String string3 = ((RichTextEditor)MethodAddLinkDialog.this.richText).getSelected().getText();
                            if (string3.trim().length() == 0) {
                                string3 = methodElement.getName();
                            }
                            string = ResourceHelper.getElementLink((MethodElement)methodElement, (String)string3, (String)("file://" + string2));
                        } else {
                            boolean bl = MethodAddLinkDialog.this.linkType == 3;
                            string = ResourceHelper.getElementLink((MethodElement)methodElement, (boolean)bl, (String)("file://" + string2));
                        }
                        MethodAddLinkDialog.this.urlText.setText(string);
                    }
                }
            }
        });
        this.browseButton.moveAbove((Control)this.urlDisplayNameLabel);
        this.openLinkCheckbox = new Button(composite2, 32);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 2;
        this.openLinkCheckbox.setLayoutData((Object)gridData2);
        this.openLinkCheckbox.setText(AuthoringUIResources.openLinkCheckbox_text);
        this.openLinkCheckbox.setSelection(true);
        this.openLinkCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodAddLinkDialog.this.openLinkInNewWindow = MethodAddLinkDialog.this.openLinkCheckbox.getSelection();
            }
        });
        this.urlDisplayNameText.setText(this.richText.getSelected().getText());
        return composite2;
    }

    public File getFileToCopy() {
        return this.fileToCopy;
    }

    public boolean getOpenLinkInNewWindow() {
        return this.openLinkInNewWindow;
    }

    protected void okPressed() {
        String string = this.urlText.getText();
        if (string != null && string.length() > 0) {
            if (this.linkType == 0) {
                String string2 = this.urlDisplayNameText.getText();
                if (string2.trim().length() == 0) {
                    string2 = string;
                }
                String string3 = "<a href=\"" + string + "\"" + (this.openLinkInNewWindow ? " target=\"_blank\"" : "") + ">" + string2 + "</a>";
                this.link.setURL(string3);
            } else {
                this.link.setURL(string);
            }
        }
        this.urlText.removeModifyListener(this.modifyListener);
        this.urlText.setText("");
        super.okPressed();
    }
}

