/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditor;
import org.eclipse.epf.authoring.ui.editors.ConfigurationEditorInput;
import org.eclipse.epf.authoring.ui.editors.EditorOpener;
import org.eclipse.epf.authoring.ui.editors.EditorOpenerFactory;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.ui.editors.IMethodEditor;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorChooser
implements IEditorKeeper {
    private static EditorChooser singleton = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EditorChooser getInstance() {
        if (singleton != null) return singleton;
        Class<EditorChooser> clazz = EditorChooser.class;
        synchronized (EditorChooser.class) {
            if (singleton != null) return singleton;
            singleton = new EditorChooser();
            IEditorKeeper.REFERENCE.setEditorKeeper(singleton);
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }

    @Override
    public void openEditor(Object object) {
        try {
            EObject eObject;
            Resource resource;
            Object object2;
            object = ViewHelper.handleDangling(object);
            if (object == null) {
                return;
            }
            object = LibraryUtil.unwrap((Object)object);
            ArrayList arrayList = new ArrayList();
            if (object instanceof EObject) {
                object2 = ((EObject)object).eResource();
                if (object2 != null && !object2.getErrors().isEmpty()) {
                    arrayList.addAll(object2.getErrors());
                }
                if (object instanceof DescribableElement && (resource = ((DescribableElement)object).getPresentation().eResource()) != null && !resource.getErrors().isEmpty()) {
                    arrayList.addAll(resource.getErrors());
                }
                if (!arrayList.isEmpty()) {
                    resource = new MultiStatus(AuthoringUIPlugin.getDefault().getId(), 0, AuthoringUIResources.EditorChooser_ResourcesError, null);
                    eObject = arrayList.iterator();
                    while (eObject.hasNext()) {
                        Resource.Diagnostic diagnostic = (Resource.Diagnostic)eObject.next();
                        Status status = new Status(2, LibraryPlugin.getDefault().getId(), 0, diagnostic.getMessage(), null);
                        resource.add((IStatus)status);
                    }
                    try {
                        if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.EditorChooser_loaddErrorDlgTitle, AuthoringUIResources.EditorChooser_ResourcesError, (IStatus)resource) == 1) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                }
            }
            if ((object2 = EditorOpenerFactory.getInstance().getOpener(object)) != null && ((EditorOpener)object2).canOpen(object)) {
                ((EditorOpener)object2).openEditor(object);
            } else if (object instanceof MethodPlugin || object instanceof ContentPackage || object instanceof Role || object instanceof Task || object instanceof WorkProduct || object instanceof Guidance || object instanceof Discipline || object instanceof DisciplineGrouping || object instanceof Domain || object instanceof WorkProductType || object instanceof RoleSet || object instanceof Tool || object instanceof RoleSetGrouping || object instanceof MethodLibrary) {
                this.openEditor((MethodElement)object, MethodElementEditor.EDITOR_ID);
            } else if (object instanceof CustomCategory) {
                resource = (CustomCategory)object;
                if (TngUtil.isRootCustomCategory((CustomCategory)resource)) {
                    return;
                }
                this.openEditor((MethodElement)object, MethodElementEditor.EDITOR_ID);
            } else if (object instanceof ProcessComponent) {
                this.openEditor((MethodElement)object, ProcessEditor.EDITOR_ID);
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.PropertySheet", null, 2);
                }
                catch (PartInitException partInitException) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
                }
            } else if (object instanceof Process) {
                resource = ((Process)object).eContainer();
                if (resource instanceof ProcessComponent) {
                    this.openEditor((MethodElement)resource, ProcessEditor.EDITOR_ID);
                }
            } else if (object instanceof MethodConfiguration) {
                this.openEditor((MethodConfiguration)object, ConfigurationEditor.EDITOR_ID);
            } else if (object instanceof BreakdownElement && (eObject = (resource = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)object))).eContainer()) instanceof ProcessComponent) {
                this.openEditor((MethodElement)eObject, ProcessEditor.EDITOR_ID);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_title;
            String string2 = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_message;
            String string3 = AuthoringUIResources.editors_EditorChooser_systemErrorDialog_reason;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, string2, string3, throwable);
        }
    }

    private void openEditor(MethodConfiguration methodConfiguration, String string) throws PartInitException {
        ConfigurationEditorInput configurationEditorInput = new ConfigurationEditorInput(methodConfiguration);
        AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)configurationEditorInput, string);
    }

    private void openEditor(MethodElement methodElement, String string) throws PartInitException {
        MethodElementEditorInput methodElementEditorInput = new MethodElementEditorInput(methodElement);
        AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().openEditor((IEditorInput)methodElementEditorInput, string);
    }

    public void selectEditor(Object object) {
        IWorkbenchPage iWorkbenchPage;
        IEditorPart iEditorPart;
        try {
            object = ViewHelper.handleDangling(object);
            if (object == null) {
                return;
            }
            object = LibraryUtil.unwrap((Object)object);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        MethodElementEditorInput methodElementEditorInput = null;
        if (object instanceof MethodConfiguration) {
            methodElementEditorInput = new ConfigurationEditorInput((MethodConfiguration)object);
        } else if (object instanceof MethodElement) {
            methodElementEditorInput = new MethodElementEditorInput((MethodElement)object);
        }
        if (methodElementEditorInput != null && (iEditorPart = (iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage()).findEditor((IEditorInput)methodElementEditorInput)) != null) {
            iWorkbenchPage.bringToTop((IWorkbenchPart)iEditorPart);
        }
    }

    public Object getActiveMethodEditorInput() {
        IEditorPart iEditorPart = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        return this.getMethodEditorInput(iEditorPart);
    }

    public Object getMethodEditorInput(IEditorPart iEditorPart) {
        if (iEditorPart != null) {
            IEditorInput iEditorInput = iEditorPart.getEditorInput();
            if (iEditorInput instanceof ConfigurationEditorInput) {
                return ((ConfigurationEditorInput)iEditorInput).getConfiguration();
            }
            if (iEditorInput instanceof MethodElementEditorInput) {
                return ((MethodElementEditorInput)iEditorInput).getMethodElement();
            }
        }
        return null;
    }

    public void closeEditor(Object object) {
        try {
            IEditorPart iEditorPart = this.findEditor(object);
            if (iEditorPart != null) {
                AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor(iEditorPart, false);
            }
        }
        catch (NullPointerException nullPointerException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)nullPointerException);
        }
    }

    public IEditorPart findEditor(Object object) {
        try {
            MethodElementEditorInput methodElementEditorInput = new MethodElementEditorInput((MethodElement)object);
            IEditorPart iEditorPart = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage().findEditor((IEditorInput)methodElementEditorInput);
            return iEditorPart;
        }
        catch (NullPointerException nullPointerException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)nullPointerException);
            return null;
        }
    }

    public Collection getElementsWithDirtyEditor(Collection collection) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            IEditorPart iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart != null && iEditorPart.isDirty()) {
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                MethodElement methodElement = null;
                if (iEditorInput instanceof MethodElementEditorInput) {
                    methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement();
                } else if (iEditorInput instanceof ConfigurationEditorInput) {
                    methodElement = ((ConfigurationEditorInput)iEditorInput).getConfiguration();
                }
                if (methodElement != null) {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        if (e != methodElement && !UmaUtil.isContainedBy((EObject)methodElement, e)) continue;
                        arrayList.add(methodElement);
                        iterator.remove();
                    }
                }
            }
            ++n;
        }
        return arrayList;
    }

    @Override
    public void closeEditorsOnDeletion(Object object) {
        IEditorReference[] iEditorReferenceArray;
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorReference[]> arrayList = new ArrayList<IEditorReference[]>();
        int n = 0;
        while (n < iEditorReferenceArray2.length) {
            iEditorReferenceArray = iEditorReferenceArray2[n];
            IEditorPart iEditorPart = iEditorReferenceArray.getEditor(true);
            if (iEditorPart != null) {
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                MethodElement methodElement = null;
                if (iEditorInput instanceof MethodElementEditorInput) {
                    methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement();
                } else if (iEditorInput instanceof ConfigurationEditorInput) {
                    methodElement = ((ConfigurationEditorInput)iEditorInput).getConfiguration();
                }
                if (methodElement != null && (methodElement.eContainer() == null || UmaUtil.isContainedBy((EObject)methodElement, (Object)object))) {
                    arrayList.add(iEditorReferenceArray);
                }
            }
            ++n;
        }
        n = arrayList.size();
        iEditorReferenceArray = new IEditorReference[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorReferenceArray[n2] = (IEditorReference)arrayList.get(n2);
            ++n2;
        }
        iWorkbenchPage.closeEditors(iEditorReferenceArray, false);
    }

    public void closeAllMethodEditors() {
        final IWorkbench iWorkbench = PlatformUI.getWorkbench();
        iWorkbench.getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    List<IEditorReference> list = EditorChooser.this.getOpenMethodEditors();
                    iWorkbenchPage.closeEditors(list.toArray(new IEditorReference[list.size()]), false);
                }
            }
        });
    }

    public List<IEditorReference> getOpenMethodEditors() {
        final IWorkbench iWorkbench = PlatformUI.getWorkbench();
        final ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
        iWorkbench.getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
                if (iWorkbenchWindow != null) {
                    IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
                    IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
                    int n = 0;
                    while (n < iEditorReferenceArray.length) {
                        IEditorReference iEditorReference = iEditorReferenceArray[n];
                        IEditorPart iEditorPart = iEditorReference.getEditor(false);
                        String string = iEditorReference.getId();
                        if (string.startsWith("org.eclipse.epf") || iEditorPart instanceof IMethodEditor) {
                            arrayList.add(iEditorReference);
                        }
                        ++n;
                    }
                }
            }
        });
        return arrayList;
    }

    public void closeMethodEditorsForPluginElements(MethodPlugin methodPlugin) {
        if (AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow() != null && AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage() != null) {
            IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
            List<IEditorReference> list = this.getOpenMethodEditors();
            ArrayList<IEditorReference> arrayList = new ArrayList<IEditorReference>();
            for (IEditorReference iEditorReference : list) {
                DiagramEditorInput diagramEditorInput;
                IEditorPart iEditorPart = iEditorReference.getEditor(true);
                if (iEditorPart == null) continue;
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                MethodElement methodElement = null;
                if (iEditorInput instanceof MethodElementEditorInput) {
                    methodElement = ((MethodElementEditorInput)iEditorInput).getMethodElement();
                } else if (iEditorInput instanceof ConfigurationEditorInput) {
                    methodElement = ((ConfigurationEditorInput)iEditorInput).getConfiguration();
                } else if (iEditorInput instanceof DiagramEditorInputProxy && (methodElement = (diagramEditorInput = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()).getMethodElement()) == null && diagramEditorInput.getWrapper() != null) {
                    methodElement = (MethodElement)TngUtil.unwrap((Object)diagramEditorInput.getWrapper());
                }
                if (methodElement == null || methodElement.eContainer() != null && !UmaUtil.isContainedBy((EObject)methodElement, (Object)methodPlugin) || methodElement.equals(methodPlugin)) continue;
                arrayList.add(iEditorReference);
            }
            iWorkbenchPage.closeEditors(arrayList.toArray(new IEditorReference[arrayList.size()]), true);
        }
    }
}

