/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.epf.authoring.ui.editors.AbstractBaseFormEditor;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodRichTextEditor;
import org.eclipse.epf.authoring.ui.editors.PreviewPage;
import org.eclipse.epf.authoring.ui.forms.ChecklistItemsPage;
import org.eclipse.epf.authoring.ui.forms.ContentElementGuidancePage;
import org.eclipse.epf.authoring.ui.forms.ContentPackageDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryAssignPage;
import org.eclipse.epf.authoring.ui.forms.CustomCategoryDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineGroupingDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineGroupingDisciplinesPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineReferenceWorkflowPage;
import org.eclipse.epf.authoring.ui.forms.DisciplineTasksPage;
import org.eclipse.epf.authoring.ui.forms.DomainDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.DomainWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.GuidanceWithAttachmentsDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.IExtensionFormPage;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.forms.MethodLibraryDescriptionFormPage;
import org.eclipse.epf.authoring.ui.forms.MethodPluginDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.PracticeDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.PracticeReferencesPage;
import org.eclipse.epf.authoring.ui.forms.RoleCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.RoleDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetGroupingDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.RoleSetGroupingRoleSets;
import org.eclipse.epf.authoring.ui.forms.RoleSetRolesPage;
import org.eclipse.epf.authoring.ui.forms.RoleWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.TaskCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.TaskDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.TaskRolesPage;
import org.eclipse.epf.authoring.ui.forms.TaskStepsPage;
import org.eclipse.epf.authoring.ui.forms.TaskWorkProductsPage;
import org.eclipse.epf.authoring.ui.forms.ToolDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.ToolToolMentorsPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductCategoriesPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductDeliverablePartsPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductTypeDescriptionPage;
import org.eclipse.epf.authoring.ui.forms.WorkProductTypeWorkProductsPage;
import org.eclipse.epf.authoring.ui.internal.MethodElementEditorErrorTickUpdater;
import org.eclipse.epf.authoring.ui.providers.MethodEditorPageProvider;
import org.eclipse.epf.authoring.ui.providers.MethodElementLabelDecorator;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.util.LibraryValidationMarkerHelper;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.FullyRevertibleCommandStack;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResource;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.synch.ISynchronizationHelper;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementEditor
extends AbstractBaseFormEditor
implements ISelectionProvider,
IGotoMarker {
    public static final String EDITOR_ID = MethodElementEditor.class.getName();
    protected int preview_page_index = -1;
    protected ElementHTMLViewer previewer = null;
    protected MethodElement elementObj = null;
    protected IMethodRichText modifiedRichText = null;
    protected Adapter nameChangedListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(MethodElement.class)) {
                case 0: {
                    MethodElementEditor.this.nameChanged();
                }
            }
        }
    };
    protected Collection<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected ISelection currentSelection = StructuredSelection.EMPTY;
    protected ActionManager actionMgr;
    private boolean dirty;
    private ILibraryPersister.FailSafeMethodLibraryPersister persister;
    private Collection<Object> widgetsToRestoreValue = new HashSet<Object>();
    private long changeTime = -1L;
    public Object widgetToCheck;
    private Object currentFeatureEditor;
    private EStructuralFeature currentEditedFeature;
    protected ArrayList<Resource> removedResources = new ArrayList();
    protected ArrayList<Resource> changedResources = new ArrayList();
    protected MethodElementEditorErrorTickUpdater fMethodElementEditorErrorTickUpdater = null;
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            System.out.println("MethodElementEditor.resourceChanged(): event = " + iResourceChangeEvent);
            if (MethodElementEditor.this.elementObj.eIsProxy()) {
                return;
            }
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected Map URIToUsedResourceMap;
                    protected Collection<Resource> changedResources;
                    protected Collection<Resource> removedResources;

                    ResourceDeltaVisitor() {
                        this.URIToUsedResourceMap = MethodElementEditor.this.getURIToUsedResourceMap();
                        this.changedResources = new ArrayList<Resource>();
                        this.removedResources = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta iResourceDelta) {
                        Resource resource;
                        if (iResourceDelta.getFlags() != 131072 && iResourceDelta.getResource().getType() == 1 && (iResourceDelta.getKind() & 6) != 0 && (resource = (Resource)this.URIToUsedResourceMap.get(URI.createFileURI((String)iResourceDelta.getResource().getLocation().toString()))) != null) {
                            if ((iResourceDelta.getKind() & 2) != 0) {
                                this.removedResources.add(resource);
                            } else {
                                this.changedResources.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedResources;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedResources;
                    }
                }
                ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                MethodElementEditor.this.removedResources.addAll(resourceDeltaVisitor.getRemovedResources());
                if (!resourceDeltaVisitor.getRemovedResources().isEmpty() && !MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            MethodElementEditor.this.dispose();
                        }
                    });
                }
                MethodElementEditor.this.changedResources.addAll(resourceDeltaVisitor.getChangedResources());
            }
            catch (CoreException coreException) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)coreException);
            }
        }
    };
    private ActivationListener activationListener;
    private boolean checkFileChangedRequired = false;
    protected HashSet<Resource> lastUsedResources;
    private boolean disposed;
    protected HashMap<Resource, ResourceInfo> resourceInfoMap;
    private IFile elementFile;

    public MethodElementEditor() {
        this.createEditorErrorTickUpdater();
        this.createActionManager();
    }

    protected void createEditorErrorTickUpdater() {
        this.fMethodElementEditorErrorTickUpdater = new MethodElementEditorErrorTickUpdater(this);
    }

    protected void createActionManager() {
        this.actionMgr = new ActionManager(){

            protected FullyRevertibleCommandStack createCommandStack() {
                return new FullyRevertibleCommandStack(this){

                    public boolean doExecute(Command command) {
                        boolean bl;
                        Object object;
                        if (command instanceof IResourceAwareCommand) {
                            IStatus iStatus;
                            object = ((IResourceAwareCommand)command).getModifiedResources();
                            if (object != null && !object.isEmpty() && !(iStatus = UserInteractionHelper.checkModify((Collection)object, (Shell)MethodElementEditor.this.getSite().getShell())).isOK()) {
                                MethodElementEditor.this.handleError(iStatus);
                                return false;
                            }
                        } else {
                            IStatus iStatus;
                            object = TngUtil.getOwner((Command)command);
                            if (object != null && !(iStatus = TngUtil.checkEdit((EObject)object, (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                                AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, iStatus);
                                return false;
                            }
                        }
                        if (MethodElementEditor.this.changeTime == -1L) {
                            MethodElementEditor.this.changeTime = System.currentTimeMillis();
                        }
                        if (!(bl = super.doExecute(command)) && MethodElementEditor.this.changeTime != -1L) {
                            MethodElementEditor.this.changeTime = -1L;
                        }
                        return bl;
                    }
                };
            }

            public boolean doAction(int n, EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n2) {
                final IStatus iStatus = TngUtil.checkEdit((EObject)eObject, (Object)MethodElementEditor.this.getSite().getShell());
                if (iStatus.isOK()) {
                    return super.doAction(n, eObject, eStructuralFeature, object, n2);
                }
                SafeUpdateController.syncExec((Runnable)new Runnable(){

                    public void run() {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, iStatus);
                    }
                });
                return false;
            }

            protected void save(Resource resource) {
                block8: {
                    File file;
                    if (MethodElementEditor.this.changedResources.contains(resource)) {
                        return;
                    }
                    boolean bl = resource.getURI().isFile() ? (file = new File(resource.getURI().toFileString())).lastModified() > MethodElementEditor.this.changeTime : true;
                    try {
                        if (!bl) break block8;
                        file = MethodElementEditor.this.getPersister();
                        try {
                            file.save(resource);
                            file.commit();
                        }
                        catch (Exception exception) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                            try {
                                file.rollback();
                            }
                            catch (Exception exception2) {
                                ViewHelper.reloadCurrentLibaryOnRollbackError(MethodElementEditor.this.getEditorSite().getShell());
                            }
                        }
                    }
                    finally {
                        MethodElementEditor.this.changeTime = -1L;
                    }
                }
            }
        };
        this.actionMgr.getCommandStack().addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject eventObject) {
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        MethodElementEditor.this.firePropertyChange(257);
                    }
                });
            }
        });
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.startListeningTo(this.actionMgr.getCommandStack());
        }
    }

    private void nameChanged() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                MethodElementEditor.this.setPartName();
                if (MethodElementEditor.this.pages != null) {
                    for (Object e : MethodElementEditor.this.pages) {
                        if (!(e instanceof IRefreshable)) continue;
                        ((IRefreshable)e).refreshName(MethodElementEditor.this.elementObj.getName());
                    }
                }
            }
        });
    }

    public IActionManager getActionManager() {
        return this.actionMgr;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) throws PartInitException {
        MethodElement methodElement;
        this.setSite((IWorkbenchPartSite)iEditorSite);
        if (iEditorInput instanceof FileEditorInput) {
            this.elementFile = ((FileEditorInput)iEditorInput).getFile();
            methodElement = PersistenceUtil.getMethodElement((IResource)this.elementFile, (ResourceSet)LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet());
            if (methodElement != null) {
                iEditorInput = new MethodElementEditorInput(methodElement);
            }
        }
        this.setInput(iEditorInput);
        iEditorSite.setSelectionProvider((ISelectionProvider)this);
        this.activationListener = new ActivationListener(iEditorSite.getWorkbenchWindow().getPartService());
        methodElement = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        Image image = methodElement.getImage((Object)this.elementObj);
        methodElement.dispose();
        this.setTitleImage(image);
    }

    protected void setInput(IEditorInput iEditorInput) {
        super.setInput(iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        this.elementObj = methodElementEditorInput.getMethodElement();
        this.setPartName();
        this.elementObj.eAdapters().add((Object)this.nameChangedListener);
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.updateEditorImage(this.elementObj);
        }
    }

    public void updateResourceInfos(Collection<Resource> collection) {
        if (this.resourceInfoMap == null) {
            this.resourceInfoMap = new HashMap();
        }
        for (Resource resource : collection) {
            ResourceInfo resourceInfo = this.resourceInfoMap.get(resource);
            if (resourceInfo == null) {
                resourceInfo = new ResourceInfo(resource);
                this.resourceInfoMap.put(resource, resourceInfo);
                continue;
            }
            resourceInfo.refresh();
        }
        this.checkFileChangedRequired = true;
    }

    public void ovewriteResources(Collection<Resource> collection) {
        for (Resource resource : collection) {
            ResourceInfo resourceInfo = this.resourceInfoMap.get(resource);
            if (resourceInfo == null) continue;
            resourceInfo.overwrite = true;
        }
    }

    public void setResourceInfos(Collection<Resource> collection) {
        if (this.resourceInfoMap != null && !this.resourceInfoMap.isEmpty()) {
            this.resourceInfoMap.clear();
        }
        this.updateResourceInfos(collection);
    }

    private long getLoadStamp(Resource resource) {
        ResourceInfo resourceInfo = this.resourceInfoMap.get(resource);
        return resourceInfo != null ? resourceInfo.loadStamp : -1L;
    }

    private boolean checkReloaded(Collection collection) {
        ResourceSet resourceSet = MethodElementEditor.getResourceSet(collection);
        boolean bl = resourceSet instanceof ILibraryResourceSet && ((ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi");
        for (Resource resource : collection) {
            long l;
            long l2;
            if (!(resource instanceof ILibraryResource) || (l2 = this.getLoadStamp(resource)) == (l = ((ILibraryResource)resource).getLoadStamp())) continue;
            if (bl) {
                IResource iResource = FileManager.getResourceForLocation((String)resource.getURI().toFileString());
                if (iResource == null) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private static ResourceSet getResourceSet(Collection collection) {
        ResourceSet resourceSet = null;
        for (Resource resource : collection) {
            resourceSet = resource.getResourceSet();
            if (resourceSet != null) break;
        }
        return resourceSet;
    }

    private Collection<Resource> getOutOfSyncResources(Collection<Resource> collection) {
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (Resource resource : collection) {
            if (!this.isOutOfSync(resource)) continue;
            arrayList.add(resource);
        }
        return arrayList;
    }

    private boolean isOutOfSync(Resource resource) {
        ResourceInfo resourceInfo = this.resourceInfoMap.get(resource);
        long l = ISynchronizationHelper.INSTANCE.getModificationStamp(resource);
        if (l != -1L) {
            if (resourceInfo == null || resourceInfo.modificationStamp != l) {
                if (ISynchronizationHelper.INSTANCE.isSynchronized(resource)) {
                    if (resourceInfo == null) {
                        this.resourceInfoMap.put(resource, new ResourceInfo(resource));
                    } else {
                        resourceInfo.modificationStamp = ISynchronizationHelper.INSTANCE.getModificationStamp(resource);
                    }
                    return false;
                }
                return true;
            }
            return false;
        }
        return !ISynchronizationHelper.INSTANCE.isSynchronized(resource);
    }

    private boolean checkFileChanged(Collection collection) {
        ResourceSet resourceSet = MethodElementEditor.getResourceSet(collection);
        if (resourceSet instanceof ILibraryResourceSet && ((ILibraryResourceSet)resourceSet).getPersistenceType().equals("xmi")) {
            for (Resource resource : collection) {
                if (!this.isOutOfSync(resource)) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean promptReloadFiles() {
        String string = AuthoringUIResources.editor_error_activated_outofsync_title;
        String string2 = AuthoringUIResources.editor_error_activated_outofsync_message;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(string, string2);
    }

    private boolean handleFileChanged(final Collection<Resource> collection) {
        boolean bl = this.promptReloadFiles();
        if (bl) {
            IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    iProgressMonitor.beginTask("", 10);
                    iProgressMonitor.subTask(AuthoringUIResources.refresh_text);
                    iProgressMonitor.worked(1);
                    try {
                        Collection collection2;
                        Object object2;
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        for (Object object2 : collection) {
                            if (new File(object2.getURI().toFileString()).exists()) continue;
                            arrayList.add(object2);
                        }
                        object2 = MethodElementEditor.this.resourceInfoMap != null ? MethodElementEditor.this.getOutOfSyncResources(collection) : ResourceUtil.getOutOfSyncResources((Collection)collection);
                        iProgressMonitor.worked(2);
                        PersistenceUtil.unload(arrayList);
                        iProgressMonitor.worked(2);
                        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
                        if (iLibraryManager != null) {
                            collection2 = iLibraryManager.reloadResources((Collection)object2);
                            if (!collection2.isEmpty()) {
                                RefreshJob.getInstance().getReloadedBeforeRefreshResources().addAll(collection2);
                            }
                            if (!arrayList.isEmpty() || !collection2.isEmpty()) {
                                MethodElementEditor.this.changedResources.addAll(collection2);
                                MethodElementEditor.this.lastUsedResources.removeAll(arrayList);
                                MethodElementEditor.this.refresh(true);
                                MethodElementEditor.this.changedResources.clear();
                            }
                        }
                        iProgressMonitor.worked(4);
                        Iterator iterator = object2.iterator();
                        while (iterator.hasNext()) {
                            collection2 = (Resource)iterator.next();
                            FileManager.getInstance().refresh((Resource)collection2);
                        }
                        iProgressMonitor.worked(1);
                    }
                    finally {
                        iProgressMonitor.done();
                    }
                }
            };
            try {
                this.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)new ProgressMonitorDialog(this.getSite().getShell()), iRunnableWithProgress, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
            }
            catch (Exception exception) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                String string = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, exception.toString(), (Throwable)exception);
            }
        } else {
            this.checkFileChangedRequired = false;
        }
        return bl;
    }

    public void setPartName() {
        String string = this.elementObj.getName();
        if (string == null) {
            string = "";
        }
        this.setPartName(string);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.add(iSelectionChangedListener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void setSelection(ISelection iSelection) {
        this.currentSelection = iSelection;
        for (ISelectionChangedListener iSelectionChangedListener : new ArrayList<ISelectionChangedListener>(this.selectionChangedListeners)) {
            iSelectionChangedListener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, iSelection));
        }
    }

    @Override
    protected void addPages() {
        block45: {
            try {
                List list;
                if (this.elementObj instanceof MethodLibrary) {
                    this.addPage((IFormPage)new MethodLibraryDescriptionFormPage(this));
                } else if (this.elementObj instanceof MethodPlugin) {
                    this.addPage((IFormPage)new MethodPluginDescriptionPage(this));
                } else if (this.elementObj instanceof ContentPackage) {
                    this.addPage((IFormPage)new ContentPackageDescriptionPage(this));
                } else if (this.elementObj instanceof Role) {
                    this.addPage((IFormPage)new RoleDescriptionPage(this));
                    this.addPage((IFormPage)new RoleWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new RoleCategoriesPage(this));
                } else if (this.elementObj instanceof Task) {
                    this.addPage((IFormPage)new TaskDescriptionPage(this));
                    this.addPage((IFormPage)new TaskStepsPage(this));
                    this.addPage((IFormPage)new TaskRolesPage(this));
                    this.addPage((IFormPage)new TaskWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new TaskCategoriesPage(this));
                } else if (this.elementObj instanceof WorkProduct) {
                    this.addPage((IFormPage)new WorkProductDescriptionPage(this));
                    if (this.elementObj instanceof Deliverable) {
                        this.addPage((IFormPage)new WorkProductDeliverablePartsPage(this));
                    }
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    this.addPage((IFormPage)new WorkProductCategoriesPage(this));
                } else if (this.elementObj instanceof Guidance) {
                    if (TngUtil.isAllowedAttachments((MethodElement)this.elementObj)) {
                        this.addPage((IFormPage)new GuidanceWithAttachmentsDescriptionPage(this));
                    } else if (this.elementObj instanceof Practice) {
                        this.addPage((IFormPage)new PracticeDescriptionPage(this));
                        this.addPage((IFormPage)new PracticeReferencesPage(this));
                    } else if (this.elementObj instanceof Checklist) {
                        this.addPage((IFormPage)new GuidanceDescriptionPage(this));
                        this.addPage((IFormPage)new ChecklistItemsPage(this));
                    } else {
                        this.addPage((IFormPage)new GuidanceDescriptionPage(this));
                    }
                    if (!(this.elementObj instanceof Practice)) {
                        this.addPage((IFormPage)new ContentElementGuidancePage(this));
                    }
                } else if (this.elementObj instanceof Discipline) {
                    this.addPage((IFormPage)new DisciplineDescriptionPage(this));
                    this.addPage((IFormPage)new DisciplineTasksPage(this));
                    this.addPage((IFormPage)new DisciplineReferenceWorkflowPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof DisciplineGrouping) {
                    this.addPage((IFormPage)new DisciplineGroupingDescriptionPage(this));
                    this.addPage((IFormPage)new DisciplineGroupingDisciplinesPage(this));
                } else if (this.elementObj instanceof Domain) {
                    this.addPage((IFormPage)new DomainDescriptionPage(this));
                    this.addPage((IFormPage)new DomainWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof WorkProductType) {
                    this.addPage((IFormPage)new WorkProductTypeDescriptionPage(this));
                    this.addPage((IFormPage)new WorkProductTypeWorkProductsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof RoleSet) {
                    this.addPage((IFormPage)new RoleSetDescriptionPage(this));
                    this.addPage((IFormPage)new RoleSetRolesPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof RoleSetGrouping) {
                    this.addPage((IFormPage)new RoleSetGroupingDescriptionPage(this));
                    this.addPage((IFormPage)new RoleSetGroupingRoleSets(this));
                } else if (this.elementObj instanceof Tool) {
                    this.addPage((IFormPage)new ToolDescriptionPage(this));
                    this.addPage((IFormPage)new ToolToolMentorsPage(this));
                    this.addPage((IFormPage)new ContentElementGuidancePage(this));
                } else if (this.elementObj instanceof CustomCategory) {
                    this.addPage((IFormPage)new CustomCategoryDescriptionPage(this));
                    this.addPage((IFormPage)new CustomCategoryAssignPage(this));
                }
                this.setPartName(this.elementObj.getName());
                if (!(this.elementObj instanceof ContentPackage) && !(this.elementObj instanceof MethodPlugin)) {
                    this.createPreviewPage();
                }
                if (!(this.elementObj instanceof Task) || (list = MethodEditorPageProvider.getInstance().getPageProviders()) == null || list.size() <= 0) break block45;
                try {
                    int n = 0;
                    while (n < list.size()) {
                        Object e = list.get(n);
                        if (e instanceof IExtensionFormPage) {
                            IExtensionFormPage iExtensionFormPage = (IExtensionFormPage)e;
                            iExtensionFormPage.setEditor(this);
                        }
                        ++n;
                    }
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
            catch (Throwable throwable) {
                AuthoringUIPlugin.getDefault().getLogger().logError(throwable);
                this.dispose();
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (!(throwable instanceof Error)) break block45;
                throw (Error)throwable;
            }
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.activationListener != null) {
                this.activationListener.dispose();
            }
            this.modifiedRichText = null;
            this.disposeEditorErrorTickUpdater();
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                iLibraryManager.stopListeningTo(this.actionMgr.getCommandStack());
            }
            if (this.isDirty()) {
                this.actionMgr.undoAll();
            }
            this.actionMgr.dispose();
            this.elementObj.eAdapters().remove((Object)this.nameChangedListener);
            if (this.resourceInfoMap != null) {
                this.resourceInfoMap.clear();
                this.resourceInfoMap = null;
            }
            if (this.changedResources != null) {
                this.changedResources.clear();
                this.changedResources = null;
            }
            if (this.selectionChangedListeners != null) {
                this.selectionChangedListeners.clear();
                this.selectionChangedListeners = null;
            }
            PerspectiveUtil.isActivePerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
            if (this.lastUsedResources != null) {
                this.lastUsedResources.clear();
                this.lastUsedResources = null;
            }
        }
        finally {
            super.dispose();
            this.disposed = true;
        }
    }

    protected void disposeEditorErrorTickUpdater() {
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.dispose();
            this.fMethodElementEditorErrorTickUpdater = null;
        }
    }

    @Override
    public boolean isDirty() {
        if (this.dirty) {
            return true;
        }
        this.dirty = this.actionMgr.isSaveNeeded();
        return this.dirty;
    }

    public ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        if (this.persister == null) {
            this.persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
        }
        return this.persister;
    }

    protected Collection<Resource> getModifiedResources() {
        return this.actionMgr.getModifiedResources();
    }

    public void setModifiedRichText(IMethodRichText iMethodRichText) {
        this.modifiedRichText = iMethodRichText;
    }

    public void saveModifiedRichText(IMethodRichText iMethodRichText) {
        if (iMethodRichText != null && !iMethodRichText.isDisposed() && iMethodRichText.getModified()) {
            Object object;
            EObject eObject = iMethodRichText.getModalObject();
            EStructuralFeature eStructuralFeature = iMethodRichText.getModalObjectFeature();
            if (eObject != null && eStructuralFeature != null && !this.mustRestoreValue(iMethodRichText, object = eObject.eGet(eStructuralFeature))) {
                String string = iMethodRichText.getText();
                iMethodRichText.setInitialText(string);
                if (!string.equals(object)) {
                    this.actionMgr.doAction(1, eObject, eStructuralFeature, (Object)string, -1);
                }
            }
        }
    }

    public void saveModifiedRichText() {
        this.saveModifiedRichText(this.modifiedRichText);
    }

    protected LibraryValidateAction createValidateResourceAction() {
        return new LibraryValidateAction(false){

            protected void refreshViews() {
                LibraryView.getView().refreshViews();
            }
        };
    }

    public boolean validateResources(Collection collection) {
        ArrayList arrayList = new ArrayList();
        for (Resource resource : collection) {
            if (!(resource instanceof MultiFileXMIResourceImpl)) continue;
            arrayList.addAll(resource.getContents());
        }
        LibraryValidateAction libraryValidateAction = this.createValidateResourceAction();
        libraryValidateAction.updateSelection((IStructuredSelection)new StructuredSelection(arrayList));
        libraryValidateAction.run();
        return libraryValidateAction.isSuccessful();
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void doSave(IProgressMonitor var1_1) {
        block34: {
            if (MethodElementEditor.DEBUG) {
                System.out.println("MethodElementEditor.doSave: saving changes to method library");
            }
            this.saveModifiedRichText(this.modifiedRichText);
            this.getPersister();
            try {
                block35: {
                    var2_2 = this.getModifiedResources();
                    var3_4 = new ArrayList<Resource>(var2_2);
                    var4_6 = new HashSet<Resource>();
                    if (!var2_2.isEmpty()) {
                        var5_7 = var2_2.iterator();
                        while (var5_7.hasNext()) {
                            var6_8 = (Resource)var5_7.next();
                            var7_9 = PersistenceUtil.getMethodElement((Resource)var6_8);
                            if (var7_9 == null || (var8_10 = UmaUtil.getMethodLibrary((EObject)var7_9)) == null || (var9_14 /* !! */  = var8_10.eResource()) == null || var2_2.contains(var9_14 /* !! */ ) || var4_6.contains(var9_14 /* !! */ ) || PersistenceUtil.checkToolVersion((Resource)var9_14 /* !! */ ) == 0) continue;
                            var4_6.add(var9_14 /* !! */ );
                        }
                        var3_4.addAll(var4_6);
                    }
                    if (!(var5_7 = UserInteractionHelper.checkModify(var3_4, (Shell)this.getSite().getShell())).isOK()) {
                        this.handleError(var5_7);
                        return;
                    }
                    if (this.checkFileChanged(var3_4)) {
                        var6_8 = LibraryEditResources.update_outofsynch_title;
                        var7_9 = LibraryEditResources.update_outofsynch_msg;
                        if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt((String)var6_8, (String)var7_9)) {
                            return;
                        }
                    }
                    if (!var4_6.isEmpty()) {
                        for (Object var7_9 : var4_6) {
                            var7_9.setModified(true);
                        }
                    }
                    if (this.isValidateResourcesBeforeSaveRequired()) {
                        if (!this.validateResources(var2_2)) {
                            return;
                        }
                    } else if (LibraryValidationMarkerHelper.INSTANCE.hasMarkers(this.elementObj)) {
                        LibraryValidationMarkerHelper.INSTANCE.deleteMarkers(this.elementObj);
                        var6_8 = LibraryView.getView();
                        if (var6_8 != null) {
                            MethodElementLabelDecorator.clearDecorationCache();
                            var6_8.getViewer().refresh();
                        }
                    }
                    var6_8 = this.persister.getSaveOptions().get("OVERWRITABLE_RESOURCES");
                    var7_9 = null;
                    try {
                        this.persister.getSaveOptions().put("OVERWRITABLE_RESOURCES", this.getOverwritableResources());
                        for (Resource var9_14 : var3_4) {
                            try {
                                this.persister.save(var9_14 /* !! */ );
                            }
                            catch (Exception var10_15) {
                                var11_19 = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                                var12_23 = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                                var13_27 = var10_15.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : var10_15.getMessage();
                                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(var11_19, var12_23, var13_27, (Throwable)var10_15);
                                throw var10_15;
                            }
                        }
                        try {
                            this.persister.commit();
                            this.dirty = false;
                            this.actionMgr.saveIsDone();
                            this.changeTime = -1L;
                            var7_9 = this.getResourceToAdjustLocation();
                            this.setResourceInfos(this.getUsedResources());
                        }
                        catch (Exception var8_11) {
                            var9_14 /* !! */  = var8_11.getMessage();
                            if (StrUtil.isBlank((String)var9_14 /* !! */ )) {
                                var9_14 /* !! */  = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                            }
                            var10_16 = new StringWriter();
                            var8_11.printStackTrace(new PrintWriter(var10_16));
                            var11_20 = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                            var12_24 = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(var11_20, var12_24, (String)var9_14 /* !! */ , var10_16.toString(), (Throwable)var8_11);
                            throw var8_11;
                        }
                    }
                    finally {
                        this.persister.getSaveOptions().put("OVERWRITABLE_RESOURCES", var6_8);
                    }
                    if (var7_9 == null || var7_9.isEmpty()) break block34;
                    try {
                        this.persister.adjustLocation((Collection)var7_9);
                        break block35;
                    }
                    catch (Exception var8_12) {
                        var9_14 /* !! */  = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                        var10_17 = AuthoringUIResources.editors_MethodElementEditor_renameErrorMessage1;
                        var11_21 = new StringBuffer();
                        var12_25 = var7_9.iterator();
                        ** while (var12_25.hasNext())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var13_28 /* !! */  = (Resource)var12_25.next();
                        var14_30 = FileManager.toFileString((URI)var13_28 /* !! */ .getURI());
                        if (var14_30 == null) {
                            var14_30 = var13_28 /* !! */ ;
                        }
                        var11_21.append((Object)var14_30).append(", ");
                        continue;
                    }
lbl98:
                    // 1 sources

                    var12_25 = MessageFormat.format(var10_17, new Object[]{var11_21});
                    var13_28 /* !! */  = var8_12.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : var8_12.getMessage();
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError((String)var9_14 /* !! */ , (String)var12_25, (String)var13_28 /* !! */ , (Throwable)var8_12);
                    throw var8_12;
                }
                try {
                    this.persister.commit();
                }
                catch (Exception var8_13) {
                    var9_14 /* !! */  = var8_13.getMessage();
                    if (StrUtil.isBlank((String)var9_14 /* !! */ )) {
                        var9_14 /* !! */  = AuthoringUIResources.editors_MethodElementEditor_saveErrorReason2;
                    }
                    var10_18 = new StringWriter();
                    var8_13.printStackTrace(new PrintWriter(var10_18));
                    var11_22 = AuthoringUIResources.editors_MethodElementEditor_renameErrorTitle;
                    var12_26 = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage2;
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(var11_22, var12_26, (String)var9_14 /* !! */ , var10_18.toString(), (Throwable)var8_13);
                    throw var8_13;
                }
                var7_9.clear();
            }
            catch (Exception var2_3) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)var2_3);
                try {
                    this.persister.rollback();
                }
                catch (Exception var3_5) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)var3_5);
                    ViewHelper.reloadCurrentLibaryOnRollbackError(this.getSite().getShell());
                }
            }
        }
    }

    private Collection<Resource> getOverwritableResources() {
        if (this.resourceInfoMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (ResourceInfo resourceInfo : this.resourceInfoMap.values()) {
            if (!resourceInfo.overwrite) continue;
            arrayList.add(resourceInfo.resource);
        }
        return arrayList;
    }

    private Collection<Resource> getResourceToAdjustLocation() {
        if (this.resourceInfoMap == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Resource> arrayList = new ArrayList<Resource>();
        for (ResourceInfo resourceInfo : this.resourceInfoMap.values()) {
            if (!resourceInfo.adjustLocation) continue;
            arrayList.add(resourceInfo.resource);
        }
        return arrayList;
    }

    protected boolean isValidateResourcesBeforeSaveRequired() {
        return false;
    }

    protected void saveResource(Resource resource) {
        if (resource != null && resource.isModified()) {
            try {
                this.getPersister().save(resource);
            }
            catch (Exception exception) {
                String string = AuthoringUIResources.editors_MethodElementEditor_saveErrorTitle;
                String string2 = AuthoringUIResources.editors_MethodElementEditor_saveErrorMessage1;
                String string3 = MessageFormat.format(string2, resource.getURI().toFileString());
                String string4 = exception.getMessage() == null ? AuthoringUIResources.editors_MethodElementEditor_saveErrorReason1 : exception.getMessage();
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, string3, string4, (Throwable)exception);
            }
        }
    }

    protected void createPreviewPage() {
        Composite composite = this.getContainer();
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        PreviewPage previewPage = new PreviewPage(composite2);
        this.previewer = previewPage.getPreviewViewer();
        this.preview_page_index = this.addPage((Control)composite2);
        this.setPageText(this.preview_page_index, AuthoringUIResources.previewPage_title);
    }

    protected void pageChange(int n) {
        super.pageChange(n);
        if (this.preview_page_index == n && this.previewer != null) {
            this.previewer.showElementContent(this.elementObj);
        }
    }

    private void setDirty() {
        this.dirty = true;
        this.firePropertyChange(257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mustRestoreValue(Object object, Object object2) {
        Object object3;
        boolean bl;
        if (this.widgetToCheck == object) {
            return true;
        }
        Object object4 = object;
        if (object4 instanceof MethodRichTextEditor) {
            object4 = ((MethodRichTextEditor)object).getRichTextControl();
        }
        if (!(bl = this.widgetsToRestoreValue.contains(object4))) {
            object3 = this.widgetsToRestoreValue;
            synchronized (object3) {
                bl = this.widgetsToRestoreValue.contains(object4);
            }
        }
        if (bl) {
            if (object4 instanceof Text) {
                object3 = (Text)object4;
                object3.setText((String)object2);
            } else if (object4 instanceof IMethodRichText) {
                object3 = (IMethodRichText)object4;
                object3.setText((String)object2);
            }
            this.widgetsToRestoreValue.remove(object4);
        }
        return bl;
    }

    public ModifyListener createModifyListener(EObject eObject) {
        return this.createModifyListener(eObject, false);
    }

    public ModifyListener createModifyListener(EObject eObject, boolean bl) {
        return new ModifyListener(eObject, bl);
    }

    public void setCurrentFeatureEditor(Object object, EStructuralFeature eStructuralFeature) {
        this.currentFeatureEditor = object;
        this.currentEditedFeature = eStructuralFeature;
    }

    protected void monitorChange() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint("org.eclipse.core.resources.refreshProviders");
        if (iExtensionPoint == null) {
            return;
        }
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        int n = 0;
        while (n < iExtensionArray.length) {
            IExtension iExtension = iExtensionArray[n];
            if (DEBUG) {
                System.out.println("extension: UID=" + iExtension.getUniqueIdentifier() + ", " + iExtension);
            }
            ++n;
        }
    }

    private Map<Resource, ResourceInfo> getResourceInfoMap() {
        if (this.resourceInfoMap == null) {
            this.resourceInfoMap = new HashMap();
        }
        return this.resourceInfoMap;
    }

    public void addResourceToAdjustLocation(Resource resource) {
        ResourceInfo resourceInfo = this.getResourceInfoMap().get(resource);
        if (resourceInfo == null) {
            resourceInfo = new ResourceInfo(resource);
            this.getResourceInfoMap().put(resource, resourceInfo);
        }
        resourceInfo.adjustLocation = true;
    }

    protected List getUsedFeatures() {
        return this.elementObj.eClass().getEAllStructuralFeatures();
    }

    public Collection<Resource> getUsedResources() {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            hashSet.add(resource);
        }
        List list = this.getUsedFeatures();
        int n = list.size() - 1;
        while (n > -1) {
            Object object;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
            if (eStructuralFeature.isMany()) {
                object = (List)this.elementObj.eGet(eStructuralFeature);
                int n2 = object.size() - 1;
                while (n2 > -1) {
                    EObject eObject = (EObject)object.get(n2);
                    if (eObject.eResource() != null) {
                        hashSet.add(eObject.eResource());
                    }
                    --n2;
                }
            } else {
                object = this.elementObj.eGet(eStructuralFeature);
                if (object instanceof EObject && (resource = ((EObject)object).eResource()) != null) {
                    hashSet.add(resource);
                }
            }
            --n;
        }
        this.lastUsedResources = hashSet;
        return hashSet;
    }

    private Map getURIToUsedResourceMap() {
        HashMap<URI, Resource> hashMap = new HashMap<URI, Resource>();
        for (Resource resource : this.getUsedResources()) {
            hashMap.put(resource.getURI(), resource);
        }
        return hashMap;
    }

    protected void handleError(IStatus iStatus) {
        AuthoringUIPlugin.getDefault().getMsgDialog().display(AuthoringUIResources.errorDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, iStatus);
    }

    protected void handleActivate(IWorkbenchPart iWorkbenchPart) {
        Collection<Resource> collection;
        XMILibraryUtil.openMethodLibraryProject((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)this.getEditorSite().getActionBars().getStatusLineManager().getProgressMonitor());
        if (this.checkFileChangedRequired && this.checkFileChanged(collection = this.getUsedResources())) {
            this.handleFileChanged(collection);
        }
    }

    protected boolean handleDirtyConflict() {
        String string = AuthoringUIResources._UI_FileConflict_label;
        String string2 = AuthoringUIResources._WARN_FileConflict;
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(string, string2);
    }

    protected void handleChangedResources() {
        if ((this.elementObj.eIsProxy() || !this.changedResources.isEmpty()) && this.isDirty()) {
            this.handleDirtyConflict();
        }
    }

    public boolean isInputValid() {
        if (this.elementObj != null && this.elementObj.eIsProxy()) {
            EObject eObject = RefreshJob.getInstance().resolve((EObject)this.elementObj);
            return eObject instanceof MethodElement && !eObject.eIsProxy() && UmaUtil.getMethodLibrary((EObject)eObject) == LibraryService.getInstance().getCurrentMethodLibrary();
        }
        return true;
    }

    protected void updatePages() {
        while (this.getPageCount() > 0) {
            this.removePage(0);
        }
        this.addPages();
    }

    protected IEditorInput createInput(MethodElement methodElement) {
        return new MethodElementEditorInput(methodElement);
    }

    public synchronized void refresh(final boolean bl) {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                HashSet<Resource> hashSet = MethodElementEditor.this.lastUsedResources;
                if (!(bl || MethodElementEditor.this.elementObj.eIsProxy() || MethodElementEditor.this.checkReloaded(hashSet))) {
                    return;
                }
                int n = MethodElementEditor.this.getActivePage();
                MethodElementEditor.this.modifiedRichText = null;
                if (MethodElementEditor.this.isDirty()) {
                    MethodElementEditor.this.actionMgr.undoAll();
                    MethodElementEditor.this.dirty = false;
                }
                if (MethodElementEditor.this.elementObj.eIsProxy()) {
                    MethodElementEditor.this.elementObj.eAdapters().remove((Object)MethodElementEditor.this.nameChangedListener);
                    EObject eObject = RefreshJob.getInstance().resolve((EObject)MethodElementEditor.this.elementObj);
                    if (eObject instanceof MethodElement && !eObject.eIsProxy() && UmaUtil.getMethodLibrary((EObject)eObject) == LibraryService.getInstance().getCurrentMethodLibrary()) {
                        MethodElementEditor.this.setInput(MethodElementEditor.this.createInput((MethodElement)eObject));
                    } else {
                        MethodElementEditor.this.close(false);
                        return;
                    }
                }
                MethodElementEditor.this.setResourceInfos(hashSet);
                MethodElementEditor.this.updatePages();
                if (n != -1) {
                    MethodElementEditor.this.setActivePage(n);
                }
                MethodElementEditor.this.firePropertyChange(257);
            }
        });
    }

    public void refresh() {
        this.refresh(RefreshJob.getInstance().getChangedResources());
    }

    protected void refresh(Collection<Resource> collection) {
        this.changedResources.addAll(collection);
        this.refresh(false);
        this.changedResources.clear();
    }

    public void refreshTitleImage() {
        if (this.fMethodElementEditorErrorTickUpdater != null) {
            this.fMethodElementEditorErrorTickUpdater.updateEditorImage(this.elementObj);
        }
    }

    public void updatedTitleImage(Image image) {
        this.setTitleImage(image);
    }

    public void gotoMarker(IMarker iMarker) {
        if (iMarker.getResource() == this.elementFile) {
            try {
                Object object = iMarker.getAttribute("guid");
                if (object instanceof String) {
                    String string = (String)object;
                    MethodElement methodElement = LibraryService.getInstance().getCurrentLibraryManager().getMethodElement(string);
                    if (methodElement != this.elementObj) {
                        this.close(false);
                        IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(methodElement);
                        return;
                    }
                }
            }
            catch (CoreException coreException) {}
        }
        this.setActivePage(0);
    }

    public boolean isDisposed() {
        return this.disposed;
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService iPartService) {
            this.fPartService = iPartService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            this.fActivePart = iWorkbenchPart;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart == MethodElementEditor.this) {
                if (!MethodElementEditor.this.isInputValid()) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.editors_MethodElementEditor_invalidEditorTitle, AuthoringUIResources.editors_MethodElementEditor_invalidEditorMsg);
                    MethodElementEditor.this.close(false);
                    return;
                }
                Collection<Resource> collection = MethodElementEditor.this.getUsedResources();
                if (ResourceUtil.hasOutOfSynch(collection)) {
                    MethodElementEditor.this.handleFileChanged(collection);
                    return;
                }
                MethodElementEditor.this.setResourceInfos(collection);
            }
        }

        private void handleActivation() {
            if (this.fIsHandlingActivation || MethodElementEditor.this.disposed) {
                return;
            }
            if (this.fActivePart == MethodElementEditor.this) {
                this.fIsHandlingActivation = true;
                try {
                    MethodElementEditor.this.handleActivate(this.fActivePart);
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow iWorkbenchWindow) {
            if (iWorkbenchWindow == MethodElementEditor.this.getEditorSite().getWorkbenchWindow()) {
                iWorkbenchWindow.getShell().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowClosed(IWorkbenchWindow iWorkbenchWindow) {
        }

        public void windowOpened(IWorkbenchWindow iWorkbenchWindow) {
        }
    }

    public class ModifyListener
    implements org.eclipse.swt.events.ModifyListener {
        private EObject element;
        private boolean checkContainerResource;
        private boolean disabled = false;

        public ModifyListener(EObject eObject, boolean bl) {
            this.checkContainerResource = bl;
            this.element = eObject;
        }

        private void restoreText(Object object, String string) {
            boolean bl = this.disabled;
            try {
                this.disabled = true;
                Object object2 = object;
                if (object2 instanceof MethodRichTextEditor) {
                    object2 = ((MethodRichTextEditor)object).getRichTextControl();
                }
                if (object2 instanceof Text) {
                    Text text = (Text)object2;
                    text.setText(string);
                } else if (object2 instanceof IMethodRichText) {
                    IMethodRichText iMethodRichText = (IMethodRichText)object2;
                    iMethodRichText.setText(string);
                }
            }
            finally {
                this.disabled = bl;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean checkEdit(EObject eObject, Object object, boolean bl) {
            MethodElementEditor.this.widgetToCheck = object;
            try {
                if (DEBUG) {
                    System.out.println("MethodElementEditor.checkEdit: enter, control=" + object);
                }
                IStatus iStatus = null;
                if (MethodElementEditor.this.widgetsToRestoreValue.contains(object)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                    }
                    return false;
                }
                Collection collection = MethodElementEditor.this.widgetsToRestoreValue;
                synchronized (collection) {
                    if (MethodElementEditor.this.widgetsToRestoreValue.contains(object)) {
                        if (!DEBUG) return false;
                        System.out.println("MethodElementEditor.checkEdit: widget found in widgetsToRestoreValue, exit");
                        return false;
                    }
                    iStatus = TngUtil.checkEdit((EObject)eObject, (Object)MethodElementEditor.this.getSite().getShell());
                    if (!iStatus.isOK()) {
                        if (object instanceof IRichText) {
                            ((IRichText)object).restoreText();
                        } else if (object == MethodElementEditor.this.currentFeatureEditor) {
                            this.restoreText(object, (String)eObject.eGet(MethodElementEditor.this.currentEditedFeature));
                        } else {
                            MethodElementEditor.this.widgetsToRestoreValue.add(object);
                            if (DEBUG) {
                                System.out.println("MethodElementEditor.checkEdit: added widget to widgetsToRestoreValue");
                            }
                        }
                    } else if (bl && eObject.eContainer() != null && eObject.eContainer().eResource() != eObject.eResource() && !(iStatus = TngUtil.checkEdit((EObject)eObject.eContainer(), (Object)MethodElementEditor.this.getSite().getShell())).isOK()) {
                        if (object instanceof IRichText) {
                            ((IRichText)object).restoreText();
                        } else if (object == MethodElementEditor.this.currentFeatureEditor) {
                            this.restoreText(object, (String)eObject.eGet(MethodElementEditor.this.currentEditedFeature));
                        } else {
                            MethodElementEditor.this.widgetsToRestoreValue.add(object);
                        }
                    }
                }
                if (iStatus == null || iStatus.isOK()) return true;
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.editDialog_msgCannotEdit, iStatus);
                return false;
            }
            finally {
                MethodElementEditor.this.widgetToCheck = null;
            }
        }

        public void modifyText(ModifyEvent modifyEvent) {
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: enter, disabled=" + this.disabled);
            }
            if (!this.disabled && this.element != null) {
                if (modifyEvent.widget == null) {
                    return;
                }
                Object object = modifyEvent.widget;
                if (object instanceof Browser && (object = ((Browser)object).getData("richText")) == null) {
                    object = modifyEvent.widget;
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: widget=" + object);
                }
                if (MethodElementEditor.this.widgetsToRestoreValue.contains(object)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: widget found in widgetsToRestoreValue, exit");
                    }
                    return;
                }
                if (!this.checkEdit(this.element, object, this.checkContainerResource)) {
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: checkEdit failed, exit");
                    }
                    return;
                }
                if (object instanceof IMethodRichText) {
                    IMethodRichText iMethodRichText = (IMethodRichText)object;
                    MethodElementEditor.this.setModifiedRichText(iMethodRichText);
                    if (DEBUG) {
                        System.out.println("MethodElementEditor.ModifyListener.modifyText: adding to modifiedRichTexts list");
                    }
                }
                if (DEBUG) {
                    System.out.println("MethodElementEditor.ModifyListener.modifyText: marking editor as dirty");
                }
                MethodElementEditor.this.setDirty();
            }
            if (DEBUG) {
                System.out.println("MethodElementEditor.ModifyListener.modifyText: exit");
            }
        }

        public void setElement(EObject eObject) {
            this.element = eObject;
        }

        public void setDisable(boolean bl) {
            this.disabled = bl;
        }
    }

    protected static class ResourceInfo {
        long modificationStamp;
        long loadStamp;
        boolean overwrite;
        boolean adjustLocation;
        private Resource resource;

        ResourceInfo(Resource resource) {
            this.resource = resource;
            this.refresh();
        }

        public void refresh() {
            this.modificationStamp = ISynchronizationHelper.INSTANCE.getModificationStamp(this.resource);
            this.loadStamp = this.resource instanceof ILibraryResource ? ((ILibraryResource)this.resource).getLoadStamp() : -1L;
        }
    }
}

