/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.GuidanceDescriptionPage;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.dialogs.AddLinkDialog;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.GuidanceDescription;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class GuidanceWithAttachmentsDescriptionPage
extends GuidanceDescriptionPage {
    private Button ctrl_attach;
    private Button ctrl_detach;
    private Button ctrl_attach_url;
    private org.eclipse.swt.widgets.List ctrl_attached_files;
    private static final String GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF = "guidance_attachment_last_dir_browsed";

    public GuidanceWithAttachmentsDescriptionPage(FormEditor formEditor) {
        super(formEditor);
    }

    protected void createEditorContent(FormToolkit formToolkit) {
        super.createEditorContent(formToolkit);
        GuidanceWithAttachmentsDescriptionPage.createLabel(formToolkit, this.generalComposite, AuthoringUIText.ATTACHED_FILE_TEXT, 2);
        this.ctrl_attached_files = new org.eclipse.swt.widgets.List(this.generalComposite, 772);
        GridData gridData = new GridData(1, 1, true, true);
        gridData.heightHint = 30;
        gridData.widthHint = 300;
        this.ctrl_attached_files.setLayoutData((Object)gridData);
        this.ctrl_attached_files.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Composite composite = GuidanceWithAttachmentsDescriptionPage.createComposite(formToolkit, this.generalComposite, 1);
        GridData gridData2 = new GridData(128);
        gridData2.verticalSpan = 1;
        gridData2.horizontalSpan = 3;
        composite.setLayoutData((Object)gridData2);
        composite.setLayout((Layout)new GridLayout(3, false));
        this.ctrl_attach = GuidanceWithAttachmentsDescriptionPage.createButton(formToolkit, composite, 7);
        this.ctrl_attach_url = GuidanceWithAttachmentsDescriptionPage.createButton(formToolkit, composite, 9);
        this.ctrl_detach = GuidanceWithAttachmentsDescriptionPage.createButton(formToolkit, composite, 8);
        this.label_base.setText(AuthoringUIText.BASE_ELEMENT_TEXT);
    }

    protected void addListeners() {
        super.addListeners();
        final IActionManager iActionManager = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.ctrl_attach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                fileDialog.setText(AuthoringUIResources.attachGuidanceFileDialog_title);
                String string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString(GuidanceWithAttachmentsDescriptionPage.GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF);
                if (string != null && string.trim().length() > 0) {
                    fileDialog.setFilterPath(string);
                } else {
                    fileDialog.setFilterPath(ResourceHelper.getFolderAbsolutePath((MethodElement)GuidanceWithAttachmentsDescriptionPage.this.guidance));
                }
                fileDialog.open();
                if (fileDialog.getFileName() != null && fileDialog.getFileName() != "") {
                    try {
                        File file = new File(fileDialog.getFilterPath(), fileDialog.getFileName());
                        String string2 = ResourceHelper.getURLForAttachment((Shell)GuidanceWithAttachmentsDescriptionPage.this.ctrl_attach.getShell(), (File)file, (MethodElement)GuidanceWithAttachmentsDescriptionPage.this.guidance, (boolean)true);
                        if (string2 == null) {
                            return;
                        }
                        if (GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.indexOf(string2) != -1) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.AttachmentDialogattachFile_text, AuthoringUIResources.forms_GuidanceWithAttachmentsDescriptionPage_alreadyAttached_msg);
                            return;
                        }
                        GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.add(string2);
                        boolean bl = iActionManager.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                        if (!bl) {
                            return;
                        }
                        AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(GuidanceWithAttachmentsDescriptionPage.GUIDANCE_ATTACHMENT_LAST_DIRECTORY_BROWSED_PREF, fileDialog.getFilterPath());
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        });
        this.ctrl_attach_url.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                AddLinkDialog addLinkDialog = new AddLinkDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "");
                addLinkDialog.open();
                if (addLinkDialog.getReturnCode() == 0 && addLinkDialog.getLink() != null) {
                    try {
                        String string;
                        String string2;
                        block9: {
                            string2 = addLinkDialog.getLink().getURL();
                            string = addLinkDialog.getLink().getName();
                            if (string == null || string.trim().length() == 0) {
                                string = FileUtil.getFileName((String)string2);
                            }
                            try {
                                new URL(string2);
                            }
                            catch (MalformedURLException malformedURLException) {
                                if (!malformedURLException.getMessage().startsWith("no protocol")) break block9;
                                string2 = "http://" + string2;
                            }
                        }
                        String string3 = "<a href=\"";
                        string3 = Platform.getOS().equals("win32") ? String.valueOf(string3) + NetUtil.encodeFileURL((String)string2) : String.valueOf(string3) + NetUtil.encodeFileURL((String)string2);
                        string2 = string3 = String.valueOf(string3) + "\">" + string + "</a>";
                        if (string2 == null) {
                            return;
                        }
                        if (GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.indexOf(string2) != -1) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(AuthoringUIResources.AttachmentDialogattachUrl_text, AuthoringUIResources.forms_GuidanceWithUrlAttachmentsDescriptionPage_alreadyAttached_msg);
                            return;
                        }
                        GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.add(string2);
                        boolean bl = iActionManager.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                        if (!bl) {
                            return;
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        });
        this.ctrl_detach.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.remove(GuidanceWithAttachmentsDescriptionPage.this.ctrl_attached_files.getSelectionIndex());
                boolean bl = iActionManager.doAction(1, (EObject)GuidanceWithAttachmentsDescriptionPage.this.guidance.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getGuidanceDescription_Attachments(), (Object)GuidanceWithAttachmentsDescriptionPage.this.getFilesFromListCtrl(), -1);
                if (!bl) {
                    return;
                }
            }
        });
    }

    protected void refresh(boolean bl) {
        super.refresh(bl);
        this.ctrl_attach.setEnabled(bl);
        this.ctrl_attach_url.setEnabled(bl);
        this.ctrl_detach.setEnabled(bl);
    }

    protected void loadData() {
        super.loadData();
        if (this.guidance != null) {
            ContentDescription contentDescription = this.guidance.getPresentation();
            String string = ((GuidanceDescription)contentDescription).getAttachments();
            this.setFilesToListCtrl(string);
        }
    }

    protected Object getContentElement() {
        return this.contentElement;
    }

    private void setFilesToListCtrl(String string) {
        List list = TngUtil.convertGuidanceAttachmentsToList((String)string);
        this.ctrl_attached_files.removeAll();
        for (String string2 : list) {
            this.ctrl_attached_files.add(string2);
        }
    }

    private String getFilesFromListCtrl() {
        String[] stringArray = this.ctrl_attached_files.getItems();
        return TngUtil.convertGuidanceAttachmentsToString(Arrays.asList(stringArray));
    }
}

