/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessFormPage;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.navigator.ConfigurationsItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProcessDescription
extends ProcessFormPage {
    private static final String FORM_PAGE_ID = "processDescriptionPage";
    private static final int DEFAULT_VERTICAL_INDENT = 2;
    protected static final int GENERAL_SECTION_ID = 1;
    protected static final int DETAIL_SECTION_ID = 2;
    private IStructuredContentProvider contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){};
    private ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
    protected Section formSection;
    protected Composite sectionComposite;
    private Composite expandedComposite;
    private Text ctrl_name;
    private Text ctrl_presentation_name;
    private Text ctrl_brief_desc;
    private Text ctrl_external_id;
    private IMethodRichText ctrl_purpose;
    private IMethodRichText ctrl_full_desc;
    private IMethodRichText ctrl_scope;
    private IMethodRichText ctrl_usage_notes;
    private IMethodRichText ctrl_alternatives;
    private IMethodRichText ctrl_how_to_staff;
    private IMethodRichText ctrl_key_consideration;
    private IMethodRichText activeControl;
    private Section generalSection;
    private Section detailSection;
    private Section configSection;
    protected Composite generalComposite;
    protected Composite detailComposite;
    protected Composite configComposite;
    protected boolean descExpandFlag = false;
    protected boolean generalSectionExpandFlag = false;
    protected boolean detailSectionExpandFlag = false;
    protected boolean configSectionExpandFlag = false;
    protected IMethodRichTextEditor ctrl_expanded;
    private ImageHyperlink expandLink;
    private Label expandLabel;
    private org.eclipse.swt.widgets.List list_configurations;
    private ListViewer configListViewer;
    protected Button buttonAdd;
    protected Button buttonRemove;
    protected Button buttonMakeDefault;
    private Text textConfigDescription;
    private ItemProviderAdapter configListAdapter;
    protected ModifyListener modifyListener;
    protected ModifyListener contentModifyListener;
    private String processType;
    private MethodElementEditor editor;
    private ModifyListener nameModifyListener;
    private boolean disposed;

    public ProcessDescription(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIResources.descriptionPage_title);
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        super.createFormContent(iManagedForm);
        this.processType = LibraryUIText.getUITextLower((MethodElement)this.process);
        this.setFormText();
        this.createEditorContent(this.toolkit);
        this.loadData();
        this.addListeners();
        EditorsContextHelper.setHelp(this.getPartControl(), this.processType);
    }

    protected void createEditorContent(FormToolkit formToolkit) {
        this.createFormComposites();
        this.createGeneralSection();
        this.createDetailSection();
        this.createConfigurationSection();
        formToolkit.paintBordersFor(this.generalComposite);
        formToolkit.paintBordersFor(this.detailComposite);
        formToolkit.paintBordersFor(this.configComposite);
        formToolkit.paintBordersFor(this.expandedComposite);
    }

    private void createFormComposites() {
        this.formSection = this.toolkit.createSection(this.form.getBody(), 4096);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.formSection.setLayoutData((Object)tableWrapData);
        this.formSection.setLayout((Layout)new TableWrapLayout());
        this.sectionComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        this.sectionComposite.setLayoutData((Object)new TableWrapData());
        this.sectionComposite.setLayout((Layout)new TableWrapLayout());
        this.formSection.setClient((Control)this.sectionComposite);
        this.expandedComposite = this.toolkit.createComposite((Composite)this.formSection, 0);
        tableWrapData = new TableWrapData(256);
        this.expandedComposite.setLayoutData((Object)tableWrapData);
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.expandedComposite, AuthoringUIHelpContexts.RICH_TEXT_EDITOR_CONTEXT_ID);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent hyperlinkEvent) {
                ProcessDescription.this.toggle(hyperlinkEvent);
            }
        });
        this.expandLabel = ProcessDescription.createDecoratedLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void createGeneralSection() {
        this.generalSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.generalSection.setLayoutData((Object)tableWrapData);
        this.generalSection.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        this.generalSection.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, this.processType));
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(1808));
        this.generalComposite.setLayout((Layout)new GridLayout(3, false));
        this.generalSection.setClient((Control)this.generalComposite);
        this.ctrl_name = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIText.NAME_TEXT);
        this.ctrl_presentation_name = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIText.PRESENTATION_NAME_TEXT);
        this.ctrl_brief_desc = ProcessDescription.createTextEditWithLabel2(this.toolkit, this.generalComposite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.ctrl_external_id = ProcessDescription.createTextEditWithLabel(this.toolkit, this.generalComposite, AuthoringUIResources.Process_ExternalID);
        this.ctrl_purpose = this.createRichTextEditWithLinkForSection(this.toolkit, this.generalComposite, AuthoringUIResources.Process_Purpose, 40, 400, 1);
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ProcessDescription.this.ctrl_name.setFocus();
                }
            });
        }
    }

    protected void createDetailSection() {
        this.detailSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.detailSection.setLayoutData((Object)tableWrapData);
        this.detailSection.setText(AuthoringUIText.DETAIL_SECTION_NAME);
        this.detailSection.setDescription(MessageFormat.format(AuthoringUIText.DETAIL_SECTION_DESC, this.processType));
        this.detailSection.setLayout((Layout)new GridLayout());
        this.detailComposite = this.toolkit.createComposite((Composite)this.detailSection);
        this.detailComposite.setLayoutData((Object)new GridData(1808));
        this.detailComposite.setLayout((Layout)new GridLayout(3, false));
        this.detailSection.setClient((Control)this.detailComposite);
        this.ctrl_full_desc = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIText.MAIN_DESCRIPTION_TEXT, 100, 400, 2);
        this.ctrl_scope = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.Process_Scope, 40, 400, 2);
        this.ctrl_usage_notes = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.Process_UsageNotes, 40, 400, 2);
        this.ctrl_alternatives = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.Process_Alternatives, 40, 400, 2);
        this.ctrl_how_to_staff = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.Process_HowToStaff, 40, 400, 2);
        this.ctrl_key_consideration = this.createRichTextEditWithLinkForSection(this.toolkit, this.detailComposite, AuthoringUIResources.Process_KeyConsideration, 40, 400, 2);
    }

    protected void createConfigurationSection() {
        this.configSection = this.toolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.configSection.setLayoutData((Object)tableWrapData);
        this.configSection.setText(AuthoringUIResources.processDescription_configurationSectionTitle);
        this.configSection.setDescription(AuthoringUIResources.processDescription_configurationSectionMessage);
        this.configSection.setLayout((Layout)new GridLayout());
        this.configComposite = this.toolkit.createComposite((Composite)this.configSection);
        this.configComposite.setLayoutData((Object)new GridData(1808));
        this.configComposite.setLayout((Layout)new GridLayout(2, false));
        this.configSection.setClient((Control)this.configComposite);
        Label label = this.toolkit.createLabel(this.configComposite, AuthoringUIResources.processDescription_configurations);
        GridData gridData = new GridData(1, 0x1000008, true, true, 2, 1);
        label.setLayoutData((Object)gridData);
        this.list_configurations = UIHelper.createList(this.toolkit, this.configComposite, 2052);
        gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 2;
        gridData.heightHint = 80;
        gridData.widthHint = 200;
        this.list_configurations.setLayoutData((Object)gridData);
        this.configListViewer = new ListViewer(this.list_configurations);
        this.configListViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.configListViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object object) {
                if (object == ProcessDescription.this.process.getDefaultContext()) {
                    return AuthoringUIPlugin.getDefault().getSharedImage("icons/checked.gif");
                }
                return null;
            }

            public String getText(Object object) {
                String string = ProcessDescription.this.labelProvider.getText(object);
                if (object == ProcessDescription.this.process.getDefaultContext()) {
                    string = String.valueOf(string) + " " + AuthoringUIResources.processDescription_default;
                }
                return string;
            }
        });
        gridData = this.toolkit.createComposite(this.configComposite);
        GridData gridData2 = new GridData(0x1000000, 0x1000000, false, false);
        gridData2.horizontalIndent = 4;
        gridData.setLayoutData((Object)gridData2);
        gridData.setLayout((Layout)new GridLayout());
        gridData2 = this.toolkit.createButton((Composite)gridData, AuthoringUIResources.addButton_text, 0);
        GridData gridData3 = new GridData(768);
        gridData2.setLayoutData((Object)gridData3);
        this.buttonAdd = gridData2;
        gridData2 = this.toolkit.createButton((Composite)gridData, AuthoringUIResources.removeButton_text, 0);
        gridData3 = new GridData(768);
        gridData2.setLayoutData((Object)gridData3);
        this.buttonRemove = gridData2;
        gridData2 = this.toolkit.createButton((Composite)gridData, AuthoringUIResources.makeDefaultButton_text, 0);
        gridData3 = new GridData(768);
        gridData2.setLayoutData((Object)gridData3);
        this.buttonMakeDefault = gridData2;
        gridData3 = this.toolkit.createLabel(this.configComposite, AuthoringUIResources.processDescription_configurationDescription);
        GridData gridData4 = new GridData(1, 0x1000008, true, false, 2, 1);
        gridData3.setLayoutData((Object)gridData4);
        this.textConfigDescription = this.toolkit.createText(this.configComposite, "");
        gridData4 = new GridData(4, 4, true, true);
        gridData4.verticalIndent = 2;
        gridData4.heightHint = 80;
        gridData4.widthHint = 400;
        this.textConfigDescription.setLayoutData((Object)gridData4);
        this.textConfigDescription.setEditable(false);
    }

    public void dispose() {
        if (this.configListAdapter != null) {
            this.configListAdapter.dispose();
        }
        super.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
        if (this.labelProvider != null) {
            this.labelProvider.dispose();
        }
        this.disposed = true;
    }

    private void updateModelControls() {
        if (this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.updateControl(this.ctrl_name, this.process.getName());
        }
        if (this.ctrl_brief_desc != null && !this.ctrl_brief_desc.isDisposed()) {
            this.updateControl(this.ctrl_brief_desc, this.process.getBriefDescription());
        }
        if (this.ctrl_presentation_name != null && !this.ctrl_presentation_name.isDisposed()) {
            this.updateControl(this.ctrl_presentation_name, this.process.getPresentationName());
        }
    }

    private boolean updateControl(Text text, String string) {
        if (!text.getText().equals(TngUtil.checkNull((String)string))) {
            text.setText(TngUtil.checkNull((String)string));
        }
        return false;
    }

    private boolean updateControl(IMethodRichText iMethodRichText, String string) {
        if (!iMethodRichText.getText().equals(TngUtil.checkNull((String)string))) {
            iMethodRichText.setText(TngUtil.checkNull((String)string));
        }
        return false;
    }

    public void loadData() {
        org.eclipse.epf.uma.ProcessDescription processDescription = (org.eclipse.epf.uma.ProcessDescription)this.process.getPresentation();
        String string = processDescription.getExternalId();
        String string2 = processDescription.getPurpose();
        String string3 = processDescription.getMainDescription();
        String string4 = processDescription.getScope();
        String string5 = processDescription.getUsageNotes();
        String string6 = processDescription.getAlternatives();
        String string7 = processDescription.getHowtoStaff();
        String string8 = processDescription.getKeyConsiderations();
        this.updateModelControls();
        this.updateControl(this.ctrl_external_id, string);
        this.updateControl(this.ctrl_purpose, string2);
        this.updateControl(this.ctrl_full_desc, string3);
        this.updateControl(this.ctrl_scope, string4);
        this.updateControl(this.ctrl_usage_notes, string5);
        this.updateControl(this.ctrl_alternatives, string6);
        this.updateControl(this.ctrl_how_to_staff, string7);
        this.updateControl(this.ctrl_key_consideration, string8);
        if (this.configListAdapter == null) {
            this.configListAdapter = new ConfigListItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
        }
        this.configListViewer.setInput((Object)this.configListAdapter);
    }

    protected void addListeners() {
        this.editor = (MethodElementEditor)this.getEditor();
        final IActionManager iActionManager = this.editor.getActionManager();
        final org.eclipse.epf.uma.ProcessDescription processDescription = (org.eclipse.epf.uma.ProcessDescription)this.process.getPresentation();
        this.modifyListener = this.editor.createModifyListener((EObject)this.process);
        this.contentModifyListener = this.editor.createModifyListener((EObject)this.process.getPresentation());
        this.form.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent controlEvent) {
                if (!ProcessDescription.this.descExpandFlag) {
                    return;
                }
                if (ProcessDescription.this.ctrl_expanded != null) {
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).heightHint = ProcessDescription.this.getRichTextEditorHeight();
                    ((GridData)ProcessDescription.this.ctrl_expanded.getLayoutData()).widthHint = ProcessDescription.this.getRichTextEditorWidth();
                }
                ProcessDescription.this.formSection.layout(true, true);
            }

            public void controlMoved(ControlEvent controlEvent) {
            }
        });
        this.form.getParent().addListener(26, new Listener(){

            public void handleEvent(Event event) {
                if (TngUtil.isLocked((EObject)ProcessDescription.this.process)) {
                    ProcessDescription.this.refresh(false);
                } else {
                    ProcessDescription.this.refresh(true);
                }
            }
        });
        this.nameModifyListener = this.editor.createModifyListener(this.process.eContainer(), true);
        this.ctrl_name.addModifyListener(this.nameModifyListener);
        this.ctrl_name.addListener(27, new Listener(){

            /*
             * Enabled aggressive block sorting
             */
            public void handleEvent(Event event) {
                String string = ProcessDescription.this.process.getName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(event.widget, string)) {
                    return;
                }
                String string2 = ProcessDescription.this.ctrl_name.getText().trim();
                if (string2.equals(ProcessDescription.this.process.getName())) {
                    return;
                }
                ProcessComponent processComponent = (ProcessComponent)ProcessDescription.this.process.eContainer();
                String string3 = null;
                if (string2.indexOf(38) > -1) {
                    string3 = NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string2);
                } else {
                    IValidator iValidator = IValidatorFactory.INSTANCE.createNameValidator((NamedElement)processComponent, (AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory());
                    string3 = iValidator.isValid(string2);
                }
                if (string3 != null) {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, string3);
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    event.doit = false;
                    ProcessDescription.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ProcessDescription.this.ctrl_name.setFocus();
                            ProcessDescription.this.ctrl_name.selectAll();
                        }
                    });
                    return;
                }
                String string4 = AuthoringUIResources.processDescriptionNameChangeConfirm_title;
                String string5 = AuthoringUIResources.processDescriptionNameChangeConfirm_message;
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(string4, string5)) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                event.doit = true;
                boolean bl = iActionManager.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                if (!bl) {
                    ProcessDescription.this.ctrl_name.setText(ProcessDescription.this.process.getName());
                    return;
                }
                iActionManager.doAction(1, (EObject)processComponent, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)ProcessDescription.this.ctrl_name.getText(), -1);
                ProcessDescription.this.setFormText();
                BusyIndicator.showWhile((Display)ProcessDescription.this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

                    public void run() {
                        MethodElementEditor methodElementEditor = (MethodElementEditor)ProcessDescription.this.getEditor();
                        methodElementEditor.doSave((IProgressMonitor)new NullProgressMonitor());
                        if (methodElementEditor.isDirty()) {
                            return;
                        }
                        ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = methodElementEditor.getPersister();
                        try {
                            failSafeMethodLibraryPersister.adjustLocation((this).ProcessDescription.this.process.eResource());
                            failSafeMethodLibraryPersister.commit();
                        }
                        catch (RuntimeException runtimeException) {
                            failSafeMethodLibraryPersister.rollback();
                            throw runtimeException;
                        }
                        DiagramManager diagramManager = DiagramManager.getInstance((Process)(this).ProcessDescription.this.process, (Object)this);
                        if (diagramManager != null) {
                            try {
                                try {
                                    diagramManager.updateResourceURI();
                                }
                                catch (Exception exception) {
                                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                                    diagramManager.removeConsumer((Object)this);
                                }
                            }
                            finally {
                                diagramManager.removeConsumer((Object)this);
                            }
                        }
                    }
                });
            }
        });
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }
        });
        this.ctrl_presentation_name.addModifyListener(this.modifyListener);
        this.ctrl_presentation_name.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                String string = ProcessDescription.this.process.getPresentationName();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(event.widget, string)) {
                    return;
                }
                if (ProcessDescription.this.ctrl_presentation_name.getText() != null && !ProcessDescription.this.ctrl_presentation_name.getText().equals("")) {
                    boolean bl;
                    event.doit = true;
                    if (!ProcessDescription.this.ctrl_presentation_name.getText().equals(string) && !(bl = iActionManager.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), (Object)ProcessDescription.this.ctrl_presentation_name.getText(), -1))) {
                        ProcessDescription.this.ctrl_presentation_name.setText(string);
                        return;
                    }
                } else {
                    ProcessDescription.this.ctrl_presentation_name.setText(ProcessDescription.this.process.getPresentationName());
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editDialog_title, AuthoringUIResources.invalidPresentationNameError_msg);
                    event.doit = false;
                    ProcessDescription.this.ctrl_presentation_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ProcessDescription.this.ctrl_presentation_name.setFocus();
                        }
                    });
                }
            }
        });
        this.ctrl_presentation_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName());
            }
        });
        this.ctrl_brief_desc.addModifyListener(this.modifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = ProcessDescription.this.process.getBriefDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = ProcessDescription.this.ctrl_brief_desc.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)string2, -1))) {
                    ProcessDescription.this.ctrl_brief_desc.setText(string2);
                }
            }
        });
        this.ctrl_external_id.addModifyListener(this.contentModifyListener);
        this.ctrl_external_id.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ProcessDescription.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = processDescription.getExternalId();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_external_id, string)) {
                    return;
                }
                String string2 = ProcessDescription.this.ctrl_external_id.getText();
                if (!string2.equals(string) && (bl = iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_ExternalId(), (Object)string2, -1))) {
                    ProcessDescription.this.ctrl_external_id.setText(string2);
                }
            }
        });
        this.ctrl_purpose.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_purpose.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose());
        this.ctrl_purpose.addModifyListener(this.contentModifyListener);
        this.ctrl_purpose.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_purpose;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getPurpose();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_purpose, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Purpose(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_full_desc.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_full_desc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription());
        this.ctrl_full_desc.addModifyListener(this.contentModifyListener);
        this.ctrl_full_desc.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_full_desc;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getMainDescription();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_full_desc, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_scope.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_scope.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope());
        this.ctrl_scope.addModifyListener(this.contentModifyListener);
        this.ctrl_scope.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_scope;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getScope();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_scope, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_Scope(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_usage_notes.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_usage_notes.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes());
        this.ctrl_usage_notes.addModifyListener(this.contentModifyListener);
        this.ctrl_usage_notes.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_usage_notes;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getUsageNotes();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_usage_notes, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getProcessDescription_UsageNotes(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_alternatives.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_alternatives.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives());
        this.ctrl_alternatives.addModifyListener(this.contentModifyListener);
        this.ctrl_alternatives.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_alternatives;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getAlternatives();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_alternatives, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_Alternatives(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_how_to_staff.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_how_to_staff.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff());
        this.ctrl_how_to_staff.addModifyListener(this.contentModifyListener);
        this.ctrl_how_to_staff.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_how_to_staff;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getHowtoStaff();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_how_to_staff, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getActivityDescription_HowtoStaff(), (Object)string2, -1);
                }
            }
        });
        this.ctrl_key_consideration.setModalObject((EObject)this.process.getPresentation());
        this.ctrl_key_consideration.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations());
        this.ctrl_key_consideration.addModifyListener(this.contentModifyListener);
        this.ctrl_key_consideration.addListener(27, new Listener(){

            public void handleEvent(Event event) {
                IMethodRichText iMethodRichText;
                IMethodRichText iMethodRichText2 = iMethodRichText = ProcessDescription.this.descExpandFlag ? ProcessDescription.this.ctrl_expanded : ProcessDescription.this.ctrl_key_consideration;
                if (!iMethodRichText.getModified()) {
                    return;
                }
                String string = processDescription.getKeyConsiderations();
                if (((MethodElementEditor)ProcessDescription.this.getEditor()).mustRestoreValue(ProcessDescription.this.ctrl_key_consideration, string)) {
                    return;
                }
                String string2 = iMethodRichText.getText();
                if (!string2.equals(string)) {
                    iActionManager.doAction(1, (EObject)ProcessDescription.this.process.getPresentation(), (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_KeyConsiderations(), (Object)string2, -1);
                }
            }
        });
        this.configListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (iStructuredSelection.size() == 1) {
                    MethodConfiguration methodConfiguration = (MethodConfiguration)iStructuredSelection.getFirstElement();
                    if (methodConfiguration == ProcessDescription.this.process.getDefaultContext()) {
                        ProcessDescription.this.buttonRemove.setEnabled(false);
                    } else {
                        ProcessDescription.this.buttonRemove.setEnabled(true);
                    }
                    String string = methodConfiguration.getBriefDescription();
                    if (string == null) {
                        string = "";
                    }
                    ProcessDescription.this.textConfigDescription.setText(string);
                }
            }
        });
        this.buttonAdd.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)ProcessDescription.this.process);
                final ConfigurationsItemProvider configurationsItemProvider = new ConfigurationsItemProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory(), methodLibrary, "");
                ListSelectionDialog listSelectionDialog = new ListSelectionDialog(Display.getCurrent().getActiveShell(), configurationsItemProvider, ProcessDescription.this.contentProvider, ProcessDescription.this.labelProvider, AuthoringUIResources.ProcessDescription_selectConfiguration){

                    protected Control createDialogArea(Composite composite) {
                        Control control = super.createDialogArea(composite);
                        this.getViewer().addFilter(new ViewerFilter(){

                            public boolean select(Viewer viewer, Object object, Object object2) {
                                return !((this).this).ProcessDescription.this.process.getValidContext().contains(object2);
                            }
                        });
                        return control;
                    }

                    public boolean close() {
                        configurationsItemProvider.dispose();
                        return super.close();
                    }
                };
                if (listSelectionDialog.open() == 0) {
                    Object[] objectArray = listSelectionDialog.getResult();
                    int n = 0;
                    while (n < objectArray.length) {
                        MethodConfiguration methodConfiguration = (MethodConfiguration)objectArray[n];
                        if (methodConfiguration != null) {
                            iActionManager.doAction(3, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)methodConfiguration, -1);
                        } else {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.addConfigErrorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.invalidConfigError_msg, (Object)methodConfiguration.getName()));
                        }
                        ++n;
                    }
                }
            }
        });
        this.buttonRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                iActionManager.doAction(6, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_ValidContext(), (Object)iStructuredSelection.toList(), -1);
            }
        });
        this.buttonMakeDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MethodConfiguration methodConfiguration;
                IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessDescription.this.configListViewer.getSelection();
                if (iStructuredSelection.size() == 1 && (methodConfiguration = ProcessDescription.this.process.getDefaultContext()) != iStructuredSelection.getFirstElement()) {
                    boolean bl = true;
                    List list = ProcessDescription.this.process.getValidContext();
                    for (MethodConfiguration methodConfiguration2 : list) {
                        if (ProcessDescription.this.checkValidityForSuperSet((MethodConfiguration)iStructuredSelection.getFirstElement(), methodConfiguration2)) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        boolean bl2 = iActionManager.doAction(1, (EObject)ProcessDescription.this.process, (EStructuralFeature)UmaPackage.eINSTANCE.getProcess_DefaultContext(), iStructuredSelection.getFirstElement(), -1);
                        if (!bl2) {
                            return;
                        }
                        ProcessDescription.this.buttonRemove.setEnabled(false);
                    } else {
                        String string = ((MethodConfiguration)iStructuredSelection.getFirstElement()).getName();
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.setDefaultConfigErrorDialog_title, AuthoringUIResources.bind((String)AuthoringUIResources.setDefaultConfigError_msg, (Object)string));
                    }
                }
            }
        });
    }

    protected void refresh(boolean bl) {
        if (!this.ctrl_name.isDisposed()) {
            this.ctrl_name.setEditable(bl);
        }
        if (!this.ctrl_presentation_name.isDisposed()) {
            this.ctrl_presentation_name.setEditable(bl);
        }
        if (!this.ctrl_brief_desc.isDisposed()) {
            this.ctrl_brief_desc.setEditable(bl);
        }
        if (!this.ctrl_purpose.isDisposed()) {
            this.ctrl_purpose.setEditable(bl);
        }
        if (!this.ctrl_full_desc.isDisposed()) {
            this.ctrl_full_desc.setEditable(bl);
        }
        if (!this.ctrl_alternatives.isDisposed()) {
            this.ctrl_alternatives.setEditable(bl);
        }
        if (!this.ctrl_external_id.isDisposed()) {
            this.ctrl_external_id.setEditable(bl);
        }
        if (!this.ctrl_key_consideration.isDisposed()) {
            this.ctrl_key_consideration.setEditable(bl);
        }
        if (!this.ctrl_how_to_staff.isDisposed()) {
            this.ctrl_how_to_staff.setEditable(bl);
        }
        if (!this.ctrl_scope.isDisposed()) {
            this.ctrl_scope.setEditable(bl);
        }
        if (!this.ctrl_usage_notes.isDisposed()) {
            this.ctrl_usage_notes.setEditable(bl);
        }
        if (this.ctrl_expanded != null && !this.ctrl_expanded.isDisposed()) {
            this.ctrl_expanded.setEditable(bl);
        }
        if (!this.buttonAdd.isDisposed()) {
            this.buttonAdd.setEnabled(bl);
        }
        if (!this.buttonMakeDefault.isDisposed()) {
            this.buttonMakeDefault.setEnabled(bl);
        }
        if (!this.buttonRemove.isDisposed()) {
            this.buttonRemove.setEnabled(bl);
        }
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent, int n) {
        this.toggle(hyperlinkEvent);
    }

    protected void toggle(HyperlinkEvent hyperlinkEvent) {
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1040, this.getRichTextEditorHeight(), this.getRichTextEditorWidth(), 2, this.expandLabel);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.expandedComposite.setVisible(false);
            this.sectionComposite.setVisible(true);
            this.formSection.setClient((Control)this.sectionComposite);
            this.enableSections(true);
            IMethodRichText iMethodRichText = this.getActiveRichTextControl();
            iMethodRichText.setText(this.ctrl_expanded.getText());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.removeListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            this.editor.setFocus();
        } else {
            this.sectionComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.formSection.setClient((Control)this.expandedComposite);
            this.enableSections(false);
            this.expandLabel.setText((String)((ImageHyperlink)hyperlinkEvent.getSource()).getData("Title"));
            IMethodRichText iMethodRichText = (IMethodRichText)hyperlinkEvent.getHref();
            this.ctrl_expanded.setInitialText(iMethodRichText.getText());
            this.ctrl_expanded.setModalObject(iMethodRichText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(iMethodRichText.getModalObjectFeature());
            this.ctrl_expanded.setFindReplaceAction(iMethodRichText.getFindReplaceAction());
            Iterator iterator = iMethodRichText.getListeners();
            while (iterator.hasNext()) {
                RichTextListener richTextListener = (RichTextListener)iterator.next();
                this.ctrl_expanded.addListener(richTextListener.getEventType(), richTextListener.getListener());
            }
            boolean bl = !TngUtil.isLocked((EObject)this.process);
            this.ctrl_expanded.setEditable(bl);
            if (bl) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(iMethodRichText);
        }
        this.form.getBody().layout(true, true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private boolean checkValidityForSuperSet(MethodConfiguration methodConfiguration, MethodConfiguration methodConfiguration2) {
        List list = methodConfiguration.getMethodPluginSelection();
        List list2 = methodConfiguration.getMethodPackageSelection();
        List list3 = methodConfiguration2.getMethodPackageSelection();
        List list4 = methodConfiguration2.getMethodPluginSelection();
        boolean bl = false;
        boolean bl2 = false;
        if (list4 != null) {
            bl = list.containsAll(list4);
        }
        if (list3 != null) {
            bl2 = list2.containsAll(list3);
        }
        return bl && bl2;
    }

    private void setActiveRichTextControl(IMethodRichText iMethodRichText) {
        this.activeControl = iMethodRichText;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    protected void enableSections(boolean bl) {
        this.generalSection.setVisible(bl);
        if (bl) {
            this.generalSection.setExpanded(this.generalSectionExpandFlag);
        } else {
            this.generalSectionExpandFlag = this.generalSection.isExpanded();
            this.generalSection.setExpanded(bl);
        }
        this.detailSection.setVisible(bl);
        if (bl) {
            this.detailSection.setExpanded(this.detailSectionExpandFlag);
        } else {
            this.detailSectionExpandFlag = this.detailSection.isExpanded();
            this.detailSection.setExpanded(bl);
        }
        this.configSection.setVisible(bl);
        if (bl) {
            this.configSection.setExpanded(this.configSectionExpandFlag);
        } else {
            this.configSectionExpandFlag = this.configSection.isExpanded();
            this.configSection.setExpanded(bl);
        }
    }

    public void setFormText() {
        this.form.setText(String.valueOf(LibraryUIText.getUIText((MethodElement)this.process)) + ": " + this.methodElement.getName());
    }

    public void refreshElementName(final String string) {
        if (string != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ProcessDescription.this.ctrl_name.removeModifyListener(ProcessDescription.this.nameModifyListener);
                    ProcessDescription.this.ctrl_name.setText(string);
                    ProcessDescription.this.ctrl_name.addModifyListener(ProcessDescription.this.nameModifyListener);
                    ProcessDescription.this.setFormText();
                }
            };
            if (this.ctrl_name.getDisplay().getThread() == Thread.currentThread()) {
                runnable.run();
            } else {
                this.ctrl_name.getDisplay().syncExec(runnable);
            }
        }
    }

    class ConfigListItemProvider
    extends ItemProviderAdapter
    implements IStructuredItemContentProvider {
        public ConfigListItemProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            ProcessDescription.this.process.eAdapters().add((Object)this);
        }

        public Collection getChildren(Object object) {
            MethodConfiguration methodConfiguration = ProcessDescription.this.process.getDefaultContext();
            if (methodConfiguration != null && !ProcessDescription.this.process.getValidContext().contains(methodConfiguration)) {
                ProcessDescription.this.process.getValidContext().add(0, methodConfiguration);
            }
            return ProcessDescription.this.process.getValidContext();
        }

        public void notifyChanged(Notification notification) {
            boolean bl = false;
            switch (notification.getFeatureID(Process.class)) {
                case 38: {
                    switch (notification.getEventType()) {
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: {
                            bl = true;
                        }
                    }
                    break;
                }
                case 37: {
                    bl = true;
                }
            }
            if (bl) {
                ProcessDescription.this.configListViewer.refresh();
            }
        }
    }
}

