/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.properties.BreakdownElementGeneralSection;
import org.eclipse.epf.authoring.ui.properties.EPFPropertySheetPage;
import org.eclipse.epf.common.serviceability.Logger;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.internal.views.properties.tabbed.view.Tab;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class AbstractSection
extends AbstractPropertySection
implements PropertyChangeListener {
    private BreakdownElement element;
    protected boolean editable = false;
    protected TabbedPropertySheetPage page;
    protected ProcessAuthoringConfigurator configurator = new ProcessAuthoringConfigurator(LibraryService.getInstance().getCurrentMethodConfiguration(), null);
    protected Logger logger;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        public void libraryChanged(int n, Collection collection) {
            switch (n) {
                case 8: {
                    AbstractSection.this.sectionRefresh();
                }
            }
        }
    };

    public AbstractSection() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.addListener(this.libraryListener);
        }
        this.logger = AuthoringUIPlugin.getDefault().getLogger();
    }

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
        this.page = tabbedPropertySheetPage;
    }

    private void sectionRefresh() {
        ISection iSection;
        Tab tab;
        if (this.page != null && (tab = this.page.getCurrentTab()) != null && (iSection = tab.getSectionAtIndex(0)) != null && iSection instanceof BreakdownElementGeneralSection) {
            iSection.refresh();
        }
    }

    public void dispose() {
        ILibraryManager iLibraryManager;
        super.dispose();
        if (this.libraryListener != null && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            iLibraryManager.removeListener(this.libraryListener);
        }
    }

    public void setInput(IWorkbenchPart iWorkbenchPart, ISelection iSelection) {
        super.setInput(iWorkbenchPart, iSelection);
        Assert.isTrue((boolean)(iSelection instanceof IStructuredSelection));
        Object object = ((IStructuredSelection)iSelection).getFirstElement();
        this.initElementData(object);
    }

    private void initElementData(Object object) {
        if (object instanceof BreakdownElement) {
            this.element = (BreakdownElement)object;
            if (TngUtil.isLocked((EObject)this.element)) {
                this.editable = false;
            } else {
                this.editable = true;
                if (this.element instanceof RoleDescriptor) {
                    RoleDescriptor roleDescriptor = (RoleDescriptor)this.element;
                    this.editable = roleDescriptor.getSuperActivities() != null && roleDescriptor.getSuperActivities() != null;
                }
            }
        } else if (object instanceof BreakdownElementWrapperItemProvider) {
            this.element = (BreakdownElement)LibraryUtil.unwrap((Object)object);
            this.editable = false;
        }
    }

    public ISelection getSelection() {
        return EPFPropertySheetPage.getSelection();
    }

    public Object getInput() {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            return object;
        }
        return null;
    }

    public ProcessEditor getEditor() {
        return EPFPropertySheetPage.getEditor();
    }

    public ItemProviderAdapter getAdapter() {
        try {
            AdapterFactory adapterFactory = EPFPropertySheetPage.getAdapterFactory();
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
            return itemProviderAdapter;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public AdapterFactory getAdapterFactory() {
        AdapterFactory adapterFactory = EPFPropertySheetPage.getAdapterFactory();
        return adapterFactory;
    }

    public BreakdownElement getElement() {
        ISelection iSelection = this.getSelection();
        if (iSelection instanceof IStructuredSelection) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            try {
                this.initElementData(object);
            }
            catch (Exception exception) {
                this.logger.logError("Error getting element from the selection " + this.element, (Throwable)exception);
                return null;
            }
            return this.element;
        }
        return null;
    }

    public TabbedPropertySheetPage getPropertySheetPage() {
        return this.page;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.refresh();
    }

    public List getFilteredList(List list) {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (this.configurator == null) continue;
            Object e = iterator.next();
            this.configurator.setMethodConfiguration(LibraryService.getInstance().getCurrentMethodConfiguration());
            if (!this.configurator.accept(e)) continue;
            arrayList.add(e);
        }
        return arrayList;
    }

    protected MethodConfiguration getDefaultConfiguration() {
        ItemProviderAdapter itemProviderAdapter = this.getAdapter();
        Object object = null;
        if (itemProviderAdapter instanceof IBSItemProvider) {
            IBSItemProvider iBSItemProvider = (IBSItemProvider)itemProviderAdapter;
            object = iBSItemProvider.getTopItem();
            MethodConfiguration methodConfiguration = ((Process)object).getDefaultContext();
            return methodConfiguration;
        }
        this.logger.logError("AbstractSection::getDefaultConfiguration - IBSItemProvider is null");
        return null;
    }

    protected MethodConfiguration getConfiguration() {
        MethodConfiguration methodConfiguration = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (methodConfiguration == null) {
            return this.getDefaultConfiguration();
        }
        return methodConfiguration;
    }

    public String getNamePrefix() {
        return "ProcessElement: ";
    }
}

