/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.DescriptorProcessFilter;
import org.eclipse.epf.authoring.ui.properties.OBSRelationSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CompositeRoleRoleSection
extends OBSRelationSection {
    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
    }

    protected void initContentProvider() {
        this.contentProvider = new AdapterFactoryContentProvider(this.getAdapterFactory()){

            public Object[] getElements(Object object) {
                CompositeRoleRoleSection.this.element = CompositeRoleRoleSection.this.getElement();
                return CompositeRoleRoleSection.this.getFilteredList(((CompositeRole)CompositeRoleRoleSection.this.element).getAggregatedRoles()).toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void init() {
        super.init();
        this.element = (CompositeRole)this.element;
        String string = PropertiesResources.CompositeRole_Role_SectionTitle;
        String string2 = PropertiesResources.CompositeRole_Role_SectionDescription;
        String string3 = PropertiesResources.CompositeRole_Role_Table1;
        this.setTabData(string, string2, string3);
        this.showAddFromProcessButton = true;
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof CompositeRole) {
                super.refresh();
                this.element = (CompositeRole)this.getElement();
                this.viewer.refresh();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing Composite role - role sectin ", (Throwable)exception);
        }
    }

    private void add(List list) {
        if (list != null) {
            for (Object e : list) {
                if (e instanceof Role) {
                    this.actionMgr.doAction(3, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)((Role)e), -1);
                    continue;
                }
                if (!(e instanceof RoleDescriptor)) continue;
                Role role = ((RoleDescriptor)e).getRole();
                if (role != null) {
                    this.actionMgr.doAction(3, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)role, -1);
                    continue;
                }
                MessageFormat messageFormat = new MessageFormat(PropertiesResources.Process_CompositeRoleAssignError);
                Object[] objectArray = new Object[]{((RoleDescriptor)e).getName(), ((CompositeRole)this.element).getName()};
                AuthoringUIPlugin.getDefault().getMsgDialog().displayInfo(PropertiesResources.Process_AssignmentInfoTitle, messageFormat.format(objectArray));
            }
        }
    }

    protected void remove(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Role role : arrayList) {
                this.actionMgr.doAction(4, (EObject)((CompositeRole)this.element), (EStructuralFeature)UmaPackage.eINSTANCE.getCompositeRole_AggregatedRoles(), (Object)role, -1);
            }
        }
    }

    protected void openAddDialog() {
        List list = ((CompositeRole)this.element).getAggregatedRoles();
        ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getFilter(), this.element, FilterConstants.ROLES, list);
        itemsFilterDialog.setBlockOnOpen(true);
        itemsFilterDialog.setTitle(FilterConstants.ROLES);
        itemsFilterDialog.open();
        this.add(itemsFilterDialog.getSelectedItems());
    }

    private List getExistingElements() {
        return null;
    }

    protected void openAddFromProcessDialog() {
        String string = FilterConstants.ROLE_DESCRIPTORS;
        List list = this.getExistingElements();
        Process process = (Process)this.getProcess(this.element);
        IFilter iFilter = this.getDescriptorFilter();
        if (iFilter != null && process != null) {
            ItemsFilterDialog itemsFilterDialog = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), iFilter, process, string, list);
            itemsFilterDialog.setBlockOnOpen(true);
            itemsFilterDialog.setTitle(FilterConstants.ROLE_DESCRIPTORS);
            itemsFilterDialog.open();
            this.add(itemsFilterDialog.getSelectedItems());
        }
    }

    protected Object getProcess(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        if (object instanceof Process) {
            return object;
        }
        return this.getProcess((BreakdownElement)object);
    }

    protected IFilter getDescriptorFilter() {
        return new DescriptorProcessFilter(this.getConfiguration()){

            protected boolean childAccept(Object object) {
                if (object instanceof Activity) {
                    ArrayList arrayList = new ArrayList();
                    this.getActivitiesInScope((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory(), CompositeRoleRoleSection.this.element, arrayList);
                    return arrayList.contains(object);
                }
                if (object instanceof CompositeRole && object.equals(CompositeRoleRoleSection.this.element)) {
                    return false;
                }
                return object instanceof RoleDescriptor;
            }
        };
    }
}

