/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.properties.OBSRelationSection;
import org.eclipse.epf.authoring.ui.properties.PropertiesResources;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class RoleDescriptorTeamSection
extends OBSRelationSection {
    private Image titleImage = null;

    public void createControls(Composite composite, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(composite, tabbedPropertySheetPage);
    }

    protected void initContentProvider() {
        this.contentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                return RoleDescriptorTeamSection.this.getSelectedTeams((EObject)RoleDescriptorTeamSection.this.element).toArray();
            }
        };
        this.viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void init() {
        super.init();
        this.element = (RoleDescriptor)this.element;
        this.setTabData(PropertiesResources.RoleDescriptor_Team_SectionTitle, PropertiesResources.RoleDescriptor_Team_SectionDescription, PropertiesResources.RoleDescriptor_Team_Table1);
    }

    public void refresh() {
        try {
            if (this.getElement() instanceof RoleDescriptor) {
                super.refresh();
                this.element = (RoleDescriptor)this.getElement();
                this.viewer.refresh();
            }
        }
        catch (Exception exception) {
            this.logger.logError("Error refreshing Role Descriptor team section ", (Throwable)exception);
        }
    }

    private void add(Object[] objectArray) {
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                CompositeRole compositeRole;
                TeamProfile teamProfile = (TeamProfile)objectArray[n];
                if (this.element instanceof CompositeRole) {
                    compositeRole = ProcessUtil.createCompositeRole((CompositeRole)((CompositeRole)this.element));
                    this.actionMgr.doAction(3, (EObject)teamProfile, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)compositeRole, -1);
                } else if (this.element instanceof RoleDescriptor) {
                    MessageFormat messageFormat;
                    compositeRole = ((RoleDescriptor)this.element).getRole();
                    if (compositeRole != null) {
                        if (!this.isPartOfTeam((Role)compositeRole, teamProfile)) {
                            messageFormat = ProcessUtil.createRoleDescriptor((Role)compositeRole);
                            this.actionMgr.doAction(3, (EObject)teamProfile, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)messageFormat, -1);
                        }
                    } else {
                        messageFormat = new MessageFormat(PropertiesResources.Process_TeamAssignError);
                        Object[] objectArray2 = new Object[]{this.element.getName(), teamProfile.getName()};
                        String string = messageFormat.format(objectArray2);
                        String string2 = this.getEditor().getTitle();
                        MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                        msgDialog.displayError(string2, string, "");
                        return;
                    }
                }
                this.actionMgr.doAction(3, (EObject)teamProfile, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)this.element, -1);
                ++n;
            }
        }
    }

    protected void remove(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (TeamProfile teamProfile : arrayList) {
                Role role = ((RoleDescriptor)this.element).getRole();
                this.actionMgr.doAction(4, (EObject)teamProfile, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)this.element, -1);
                List list = teamProfile.getTeamRoles();
                ArrayList<RoleDescriptor> arrayList2 = new ArrayList<RoleDescriptor>();
                int n = 0;
                while (n < list.size()) {
                    RoleDescriptor roleDescriptor = (RoleDescriptor)list.get(n);
                    if (roleDescriptor.getRole().equals(role)) {
                        arrayList2.add(roleDescriptor);
                    }
                    ++n;
                }
                if (arrayList2.size() != 1) continue;
                this.actionMgr.doAction(4, (EObject)teamProfile, (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), (Object)((RoleDescriptor)arrayList2.get(0)), -1);
            }
        }
    }

    private boolean isPartOfTeam(Role role, TeamProfile teamProfile) {
        List list = teamProfile.getTeamRoles();
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (RoleDescriptor roleDescriptor : list) {
            arrayList.add(roleDescriptor.getRole());
        }
        return arrayList.contains(role);
    }

    protected void openAddDialog() {
        AdapterFactoryContentProvider adapterFactoryContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                List list = RoleDescriptorTeamSection.this.getTeams();
                list.removeAll(RoleDescriptorTeamSection.this.getSelectedTeams((EObject)RoleDescriptorTeamSection.this.element));
                return list.toArray();
            }
        };
        AdapterFactoryLabelProvider adapterFactoryLabelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (Object)this.element, (IStructuredContentProvider)adapterFactoryContentProvider, (ILabelProvider)adapterFactoryLabelProvider, PropertiesResources.Process_TeamDialogMessage);
        this.titleImage = Display.getCurrent().getActiveShell().getImage();
        ListSelectionDialog.setDefaultImage((Image)this.titleImage);
        listSelectionDialog.setTitle(PropertiesResources.Process_TeamDialogTitle);
        listSelectionDialog.setBlockOnOpen(true);
        listSelectionDialog.open();
        this.add(listSelectionDialog.getResult());
    }

    public void dispose() {
        super.dispose();
        if (this.contentProvider != null) {
            this.contentProvider.dispose();
        }
    }

    protected Object getParent(BreakdownElement breakdownElement) {
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)composedAdapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        Object object = itemProviderAdapter.getParent((Object)breakdownElement);
        return object;
    }

    private List getTeams() {
        ArrayList<TeamProfile> arrayList = new ArrayList<TeamProfile>();
        Object object = this.getParent(this.element);
        while (object != null) {
            if (object instanceof Activity) {
                Activity activity = (Activity)object;
                List list = activity.getBreakdownElements();
                for (BreakdownElement breakdownElement : list) {
                    if (!(breakdownElement instanceof TeamProfile)) continue;
                    TeamProfile teamProfile = (TeamProfile)breakdownElement;
                    arrayList.add(teamProfile);
                    List list2 = teamProfile.getSubTeam();
                    arrayList.addAll(list2);
                }
            }
            object = this.getParent((BreakdownElement)object);
        }
        return arrayList;
    }

    private List getSelectedTeams(EObject eObject) {
        Object object = this.getInput();
        if (object instanceof RoleDescriptorWrapperItemProvider) {
            return ProcessUtil.getTeamProfiles((RoleDescriptorWrapperItemProvider)((RoleDescriptorWrapperItemProvider)object));
        }
        RoleDescriptor roleDescriptor = (RoleDescriptor)eObject;
        return ProcessUtil.getTeamProfiles((RoleDescriptor)roleDescriptor, (AdapterFactory)this.getAdapterFactory());
    }
}

