/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceListener;
import org.eclipse.epf.library.edit.element.TransientContentPackageItemProvider;
import org.eclipse.epf.library.edit.navigator.ContentItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.navigator.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.ProcessPackage;

public class MethodRichTextMarkerHelper
extends ValidateAction.EclipseResourcesUtil {
    public static final MethodRichTextMarkerHelper INSTANCE = new MethodRichTextMarkerHelper();
    public static final String GUID = "guid";
    public static final String MARKER_ID = "org.eclipse.epf.authoring.ui.methodRichText";
    private static String METHOD_FIELDNAME = "MethodFieldName";
    private static ContainerMap containersOfMarkedObjects = new ContainerMap();

    private MethodRichTextMarkerHelper() {
    }

    protected String getMarkerID() {
        return MARKER_ID;
    }

    protected IFile getFile(URI uRI) {
        if (uRI.isFile()) {
            return (IFile)FileManager.getResourceForLocation((String)uRI.toFileString());
        }
        return super.getFile(uRI);
    }

    protected boolean adjustMarker(IMarker iMarker, Diagnostic diagnostic) throws CoreException {
        boolean bl = super.adjustMarker(iMarker, diagnostic);
        if (!diagnostic.getData().isEmpty()) {
            Object e = diagnostic.getData().get(0);
            Object e2 = diagnostic.getData().get(1);
            if (e instanceof MethodElement) {
                iMarker.setAttribute(GUID, (Object)((MethodElement)e).getGuid());
                iMarker.setAttribute("location", (Object)(String.valueOf(TngUtil.getLabel(e)) + ", " + e2));
                iMarker.setAttribute("org.eclipse.ui.editorID", (Object)"org.eclipse.epf.authoring.ui.editors.MethodElementEditor");
            }
            if (e2 instanceof String) {
                iMarker.setAttribute(METHOD_FIELDNAME, (Object)((String)e2));
            }
        }
        return bl;
    }

    public static boolean isInvalid(Object object) {
        if (object instanceof ProcessesItemProvider) {
            ProcessesItemProvider processesItemProvider = (ProcessesItemProvider)object;
            ProcessPackage processPackage = processesItemProvider.getCapabilityPatternPackage();
            return processPackage != null && containersOfMarkedObjects.containsKey(processPackage) || (processPackage = processesItemProvider.getDeliveryProcessPackage()) != null && containersOfMarkedObjects.containsKey(processPackage);
        }
        if (object instanceof MethodPackagesItemProvider || object instanceof ContentItemProvider) {
            object = ((ItemProviderAdapter)object).getTarget();
        } else if (object instanceof TransientContentPackageItemProvider) {
            Collection collection = ((TransientContentPackageItemProvider)object).getChildren(object);
            for (Object e : collection) {
                if (!containersOfMarkedObjects.containsKey(e) && !INSTANCE.hasMarkers(e)) continue;
                return true;
            }
            return false;
        }
        return containersOfMarkedObjects.containsKey(object) || INSTANCE.hasMarkers(object);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasMarkers(Object object) {
        if (!(object instanceof MethodElement)) return super.hasMarkers(object);
        IFile iFile = this.getFile(object);
        if (iFile == null) return false;
        if (!iFile.exists()) return false;
        try {
            String string = ((MethodElement)object).getGuid();
            IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
            int n = 0;
            while (true) {
                if (n >= iMarkerArray.length) {
                    return false;
                }
                IMarker iMarker = iMarkerArray[n];
                if (string.equals(iMarker.getAttribute(GUID))) {
                    return true;
                }
                ++n;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    protected IFile getFile(Object object) {
        try {
            return super.getFile(object);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void deleteMarkers(Object object, String string) {
        if (object instanceof MethodElement) {
            IFile iFile = this.getFile(object);
            if (iFile != null) {
                try {
                    String string2 = ((MethodElement)object).getGuid();
                    IMarker[] iMarkerArray = iFile.findMarkers(this.getMarkerID(), false, 0);
                    int n = 0;
                    while (n < iMarkerArray.length) {
                        IMarker iMarker = iMarkerArray[n];
                        if (string2.equals(iMarker.getAttribute(GUID)) && (string == null || string.equals(iMarker.getAttribute(METHOD_FIELDNAME)))) {
                            iMarker.delete();
                        }
                        ++n;
                    }
                }
                catch (CoreException coreException) {}
            }
            return;
        }
        super.deleteMarkers(object);
    }

    protected void deleteMarkers(IResource iResource, boolean bl, int n) {
        super.deleteMarkers(iResource, bl, n);
    }

    protected void createMarkers(IResource iResource, Diagnostic diagnostic, Diagnostic diagnostic2) throws CoreException {
        super.createMarkers(iResource, diagnostic, diagnostic2);
    }

    protected String composeMessage(Diagnostic diagnostic, Diagnostic diagnostic2) {
        String string;
        String string2 = diagnostic.getMessage();
        if (diagnostic2 != null && (string = diagnostic2.getMessage()) != null) {
            string2 = string2 != null ? String.valueOf(string) + " " + string2 : string;
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContainerMap
    extends HashMap<Object, Integer> {
        private static final long serialVersionUID = 1L;

        public ContainerMap() {
            this.initMap();
            LibraryService.getInstance().addListener((ILibraryServiceListener)new LibraryServiceListener(){

                public void libraryOpened(MethodLibrary methodLibrary) {
                    ContainerMap.this.initMap();
                }

                public void libraryClosed(MethodLibrary methodLibrary) {
                    ContainerMap.this.clear();
                }

                public void libraryReopened(MethodLibrary methodLibrary) {
                    ContainerMap.this.initMap();
                }
            });
        }

        private void initMap() {
            this.clear();
        }

        private void increment(Object object) {
            Integer n = this.containsKey(object) ? (Integer)this.get(object) : new Integer(0);
            n = n + 1;
            this.put(object, n);
        }

        private void decrement(Object object) {
            if (this.containsKey(object)) {
                Integer n = (Integer)this.get(object);
                if (n == 1) {
                    this.remove(object);
                } else {
                    n = n - 1;
                    this.put(object, n);
                }
            }
        }

        private void markContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.increment(eObject);
                eObject = eObject.eContainer();
            }
        }

        private void unmarkContainers(MethodElement methodElement) {
            EObject eObject = methodElement.eContainer();
            while (eObject != null) {
                this.decrement(eObject);
                eObject = eObject.eContainer();
            }
        }
    }
}

