/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.library.configuration.ActivityDeepCopyConfigurator;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationEvent;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class ProcessTreeViewer
extends TreeViewer
implements IActionTypeProvider {
    private static final String COPY_TXT = AuthoringUIResources.copy_text;
    private static final String EXTEND_TXT = AuthoringUIResources.extend_text;
    private static final String DEEP_COPY_TXT = AuthoringUIResources.deepCopy_text;
    private int actionType = 1;
    private Menu actionTypePopup;
    private Point actionTypePopupLocation;
    private Command command;
    private IActionManager actionManager;

    private static String getActionText(int n) {
        switch (n) {
            case 1: {
                return COPY_TXT;
            }
            case 2: {
                return EXTEND_TXT;
            }
            case 3: {
                return DEEP_COPY_TXT;
            }
        }
        return null;
    }

    public ProcessTreeViewer(Composite composite, int n) {
        super(composite, n);
        final Tree tree = this.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        this.addTreeListener(new ITreeViewerListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
                ProcessTreeViewer.this.setItemProviderExpanded(treeExpansionEvent.getElement(), false);
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                ProcessTreeViewer.this.setItemProviderExpanded(treeExpansionEvent.getElement(), true);
            }
        });
        Accessible accessible = tree.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent accessibleEvent) {
                TreeItem[] treeItemArray;
                super.getName(accessibleEvent);
                if (accessibleEvent.childID >= 0 && (treeItemArray = tree.getSelection()) != null && treeItemArray.length == 1) {
                    String string = "";
                    TreeItem treeItem = treeItemArray[0];
                    if (treeItem != null) {
                        TreeColumn[] treeColumnArray = tree.getColumns();
                        int n = 0;
                        while (n < treeColumnArray.length) {
                            TreeColumn treeColumn = treeColumnArray[n];
                            string = String.valueOf(string) + treeColumn.getText() + " " + treeItem.getText(n);
                            ++n;
                        }
                        accessibleEvent.result = string;
                    }
                }
            }
        });
    }

    public void setupColumns(ColumnDescriptor[] columnDescriptorArray) {
        TreeColumn[] treeColumnArray = this.getTree().getColumns();
        int n = treeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            treeColumnArray[n2].dispose();
            ++n2;
        }
        String[] stringArray = new String[columnDescriptorArray.length];
        int n3 = 0;
        while (n3 < columnDescriptorArray.length) {
            stringArray[n3] = columnDescriptorArray[n3].id;
            TreeColumn treeColumn = new TreeColumn(this.getTree(), columnDescriptorArray[n3].alignment);
            treeColumn.setText(columnDescriptorArray[n3].label);
            treeColumn.setResizable(columnDescriptorArray[n3].resizable);
            treeColumn.setWidth(columnDescriptorArray[n3].width);
            ++n3;
        }
        this.setColumnProperties(stringArray);
    }

    private void setItemProviderExpanded(Object object, boolean bl) {
        Object object2 = this.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
        if (object2 instanceof IBSItemProvider) {
            ((IBSItemProvider)object2).setExpanded(Boolean.valueOf(bl));
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.getContentProvider() == null ? null : ((AdapterFactoryContentProvider)this.getContentProvider()).getAdapterFactory();
    }

    protected void setExpanded(Item item, boolean bl) {
        IBSItemProvider iBSItemProvider;
        super.setExpanded(item, bl);
        Object object = this.getAdapterFactory().adapt(item.getData(), ITreeItemContentProvider.class);
        if (object instanceof IBSItemProvider && (iBSItemProvider = (IBSItemProvider)object).isExpanded() == null) {
            iBSItemProvider.setExpanded(Boolean.valueOf(bl));
        }
    }

    private void setExpanded(Item item, Object object) {
        Boolean bl;
        ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)this.getAdapterFactory().adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider.hasChildren(object) && iTreeItemContentProvider instanceof IBSItemProvider && (bl = ((IBSItemProvider)iTreeItemContentProvider).isExpanded()) != null) {
            this.setExpandedState(item, bl);
        }
    }

    protected void internalRefresh(Widget widget, Object object, boolean bl, boolean bl2) {
        super.internalRefresh(widget, object, bl, bl2);
        if (bl) {
            this.preserveExpandedState(widget);
        }
    }

    private void preserveExpandedState(Widget widget) {
        if (widget instanceof Item) {
            Item item = (Item)widget;
            this.setExpanded(item, item.getData());
        } else {
            Item[] itemArray = this.getChildren(widget);
            int n = 0;
            while (n < itemArray.length) {
                Item item = itemArray[n];
                if (item instanceof Item) {
                    Item item2 = item;
                    this.setExpanded(item2, item2.getData());
                }
                ++n;
            }
        }
    }

    protected void internalInitializeTree(Control control) {
        super.internalInitializeTree(control);
        this.preserveExpandedState((Widget)control);
    }

    private void createActionTypePopup(int[] nArray) {
        this.actionTypePopup = new Menu(this.getControl());
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                MenuItem menuItem = (MenuItem)selectionEvent.getSource();
                String string = menuItem.getText();
                if (string == COPY_TXT) {
                    ProcessTreeViewer.this.actionType = 1;
                } else if (string == EXTEND_TXT) {
                    ProcessTreeViewer.this.actionType = 2;
                } else if (string == DEEP_COPY_TXT) {
                    ProcessTreeViewer.this.actionType = 3;
                }
                if (ProcessTreeViewer.this.command instanceof ActivityDropCommand) {
                    ActivityDropCommand activityDropCommand = (ActivityDropCommand)ProcessTreeViewer.this.command;
                    activityDropCommand.setType(ProcessTreeViewer.this.actionType);
                    activityDropCommand.setLabel(string);
                    if (ProcessTreeViewer.this.actionType == 3) {
                        activityDropCommand.setActivityDeepCopyConfigurator((IConfigurator)new ActivityDeepCopyConfigurator());
                    }
                }
                if (ProcessTreeViewer.this.actionManager != null && ProcessTreeViewer.this.command instanceof IResourceAwareCommand) {
                    ProcessTreeViewer.this.actionManager.execute((IResourceAwareCommand)ProcessTreeViewer.this.command);
                } else {
                    ProcessTreeViewer.this.command.execute();
                }
                ProcessTreeViewer.this.actionTypePopup.setVisible(false);
            }
        };
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            MenuItem menuItem = new MenuItem(this.actionTypePopup, 64);
            menuItem.setText(ProcessTreeViewer.getActionText(n3));
            menuItem.addSelectionListener((SelectionListener)selectionAdapter);
            ++n2;
        }
    }

    public void setInputData(Object object) {
        this.actionTypePopupLocation = (Point)object;
    }

    public void execute(Command command, int[] nArray) {
        this.createActionTypePopup(nArray);
        this.command = command;
        this.actionTypePopup.setLocation(this.actionTypePopupLocation);
        this.actionTypePopup.setVisible(true);
    }

    protected void hookEditingSupport(Control control) {
        try {
            TreeViewerEditor.create((TreeViewer)this, (ColumnViewerEditorActivationStrategy)new ColumnViewerEditorActivationStrategy((ColumnViewer)this){

                protected boolean isEditorActivationEvent(ColumnViewerEditorActivationEvent columnViewerEditorActivationEvent) {
                    return columnViewerEditorActivationEvent.eventType == 3 || columnViewerEditorActivationEvent.eventType == 4 || columnViewerEditorActivationEvent.eventType == 5;
                }
            }, (int)1);
        }
        catch (NullPointerException nullPointerException) {}
        super.hookEditingSupport(control);
    }

    public void setActionManager(IActionManager iActionManager) {
        this.actionManager = iActionManager;
    }
}

