/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.util.Iterator;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class NewPluginMainPage
extends BaseWizardPage {
    public static final String PAGE_NAME = NewPluginMainPage.class.getName();
    protected Text nameText;
    protected Text briefDescText;
    protected Text authorsText;
    protected CheckboxTableViewer referencedPluginsViewer;
    protected List<MethodPlugin> plugins;

    public NewPluginMainPage(String string) {
        super(string);
        this.setTitle(AuthoringUIResources.newPluginWizardPage_title);
        this.setDescription(AuthoringUIResources.newPluginWizardPage_text);
        this.setImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/wizban/New.gif"));
    }

    public NewPluginMainPage() {
        this(PAGE_NAME);
    }

    public void createControl(Composite composite) {
        Composite composite2 = NewPluginMainPage.createGridLayoutComposite((Composite)composite, (int)2);
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite2, (String)AuthoringUIText.NAME_TEXT);
        this.nameText = NewPluginMainPage.createEditableText((Composite)composite2);
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite2, (String)AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        this.briefDescText = NewPluginMainPage.createEditableText((Composite)composite2, (int)400, (int)80, (int)1);
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite2, (String)AuthoringUIText.AUTHORS_TEXT);
        this.authorsText = NewPluginMainPage.createEditableText((Composite)composite2, (int)400, (int)40, (int)1);
        NewPluginMainPage.createVerticallyAlignedLabel((Composite)composite2, (String)AuthoringUIText.REFERENCED_PLUGINS_SECTION_NAME);
        this.referencedPluginsViewer = CheckboxTableViewer.newCheckList((Composite)composite2, (int)2308);
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        this.referencedPluginsViewer.getTable().setLayoutData((Object)gridData);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite2);
    }

    protected void initControls() {
        String string = "new_plug-in";
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            string = TngUtil.getNextAvailableName((List)LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins(), (String)string);
        }
        this.nameText.setText(string);
        LabelProvider labelProvider = new LabelProvider(){

            public Image getImage(Object object) {
                return LibraryUIImages.IMG_METHOD_PLUGIN;
            }

            public String getText(Object object) {
                if (object instanceof MethodPlugin) {
                    return ((MethodPlugin)object).getName();
                }
                return object.toString();
            }
        };
        this.referencedPluginsViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.referencedPluginsViewer.setSorter(new ViewerSorter());
        this.plugins = ModelStorage.getBaseModels();
        String[] stringArray = new String[this.plugins.size()];
        int n = 0;
        while (n < this.plugins.size()) {
            MethodPlugin methodPlugin = this.plugins.get(n);
            stringArray[n] = methodPlugin.getName();
            ++n;
        }
        if (this.plugins != null) {
            Iterator<MethodPlugin> iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                this.referencedPluginsViewer.add((Object)iterator.next());
            }
        }
    }

    protected void addListeners() {
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                NewPluginMainPage.this.setPageComplete(NewPluginMainPage.this.isPageComplete());
                NewPluginMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public void onEnterPage(Object object) {
        if (this.nameText != null) {
            this.nameText.setFocus();
            this.nameText.selectAll();
        }
        this.setPageComplete(this.isPageComplete());
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        return this.validatePluginName(this.getPluginName());
    }

    protected boolean validatePluginName(String string) {
        String string2 = LibraryUtil.checkPluginName(null, (String)this.getPluginName());
        if (string2 != null) {
            string2 = string2.replaceAll("\n\n", " ");
        }
        this.setErrorMessage(string2);
        return string2 == null;
    }

    public String getPluginName() {
        return this.nameText.getText() != null ? this.nameText.getText().trim() : null;
    }

    public String getBriefDescription() {
        return this.briefDescText.getText();
    }

    public String getAuthors() {
        return this.authorsText.getText();
    }

    public Object[] getReferencedPlugins() {
        return this.referencedPluginsViewer.getCheckedElements();
    }
}

