/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import java.io.File;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;

public class ConfigurationSpecsExportService
extends BaseExportService {
    private ConfigurationExportData data;

    public ConfigurationSpecsExportService(ConfigurationExportData configurationExportData) {
        this.data = configurationExportData;
    }

    public void run(IProgressMonitor iProgressMonitor) {
        if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
            return;
        }
        iProgressMonitor.setTaskName(ExportResources.ConfigurationSpecsExportService_MSG0);
        String string = new File(this.data.llData.getParentFolder()).getAbsolutePath();
        File file = new File(string);
        if (!file.exists()) {
            file.mkdir();
        }
        MethodConfiguration methodConfiguration = (MethodConfiguration)this.data.selectedConfigs.get(0);
        MethodLibrary methodLibrary = (MethodLibrary)methodConfiguration.eContainer();
        URI uRI = methodLibrary.eResource().getURI();
        String string2 = uRI.toFileString();
        File file2 = new File(string2).getParentFile();
        this.getSelectedIds(this.data.selectedConfigs);
        LibraryDocument libraryDocument = this.processLibraryFile(new File(file2, "library.xmi"), new File(file, "export.xmi"));
        if (libraryDocument != null) {
            this.copyConfigurationFiles(libraryDocument, file2, file);
        }
        iProgressMonitor.setTaskName(ExportResources.ConfigurationSpecsExportService_MSG1);
    }

    private void copyConfigurationFiles(LibraryDocument libraryDocument, File file, File file2) {
        for (MethodConfiguration methodConfiguration : this.data.selectedConfigs) {
            Object object;
            String string = methodConfiguration.getGuid();
            String string2 = libraryDocument.getResourceUri(string);
            if (string2 == null) {
                object = methodConfiguration.eResource().getURI();
                string2 = "configurations" + File.separator + object.lastSegment();
                string2 = libraryDocument.decodeUri(string2);
            }
            if (string2 == null) continue;
            object = new File(file, string2);
            File file3 = new File(file2, string2);
            FileUtil.copyFile((File)object, (File)file3);
        }
    }

    private void getSelectedIds(List list) {
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        if (list == null || list.size() == 0) {
            return;
        }
        for (MethodConfiguration methodConfiguration : list) {
            String string = methodConfiguration.getGuid();
            if (this.selectedIds.contains(string)) continue;
            this.selectedIds.add(string);
            EList eList = methodConfiguration.eCrossReferences();
            for (Object e : eList) {
                if (e instanceof MethodPlugin || e instanceof MethodPackage) {
                    string = ((MethodElement)e).getGuid();
                    if (this.selectedIds.contains(string)) continue;
                    this.selectedIds.add(string);
                    continue;
                }
                ExportPlugin.getDefault().getLogger().logError("Unexpected element type '" + ((MethodElement)e).getType().getName() + "' in configuration '" + methodConfiguration.getName() + "'");
            }
        }
    }
}

