/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.library.edit.util.ConfigurationSetter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.uml2.uml.ActivityParameterNode;
import org.eclipse.uml2.uml.ActivityPartition;
import org.eclipse.uml2.uml.StructuredActivityNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyDiagramForDeepCopyCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Collection<?> elements;
    private Map<?, ?> copyToOriginalMap;
    private Collection<Diagram> copiedElements;
    private static final boolean DEBUG = DiagramCorePlugin.getDefault().isDebugging();
    private Process targetProcess;
    private DiagramManager mgr;
    private InternalTransactionalEditingDomain domain;
    private CopyHelper copyHelper;
    private MethodConfiguration config;
    private Process srcProcess;
    private HashMap<BreakdownElement, String> copyToWrapperPathMap;

    public CopyDiagramForDeepCopyCommand(Collection<?> collection, Map<?, ?> map, Process process, Process process2, CopyHelper copyHelper, MethodConfiguration methodConfiguration) {
        this.copyHelper = copyHelper;
        this.config = methodConfiguration;
        this.srcProcess = process;
        this.elements = collection;
        this.copyToOriginalMap = map;
        this.targetProcess = process2;
        this.mgr = DiagramManager.getInstance(process2, (Object)this);
        this.domain = this.mgr.getEditingDomain();
    }

    public void execute() {
        try {
            TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                public void run() {
                    CopyDiagramForDeepCopyCommand.this.doExecute();
                }
            });
        }
        catch (ExecutionException executionException) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)executionException);
        }
    }

    public void redo() {
        this.execute();
    }

    private void doExecute() {
        if (this.copiedElements == null) {
            this.copiedElements = new ArrayList<Diagram>();
        } else {
            this.copiedElements.clear();
        }
        this.copyToWrapperPathMap = new HashMap();
        if (this.copyHelper != null) {
            for (Map.Entry object2 : this.copyHelper.getWrapperPathToCopyMap().entrySet()) {
                this.copyToWrapperPathMap.put((BreakdownElement)object2.getValue(), (String)object2.getKey());
            }
        }
        DiagramService diagramService = new DiagramService();
        try {
            try {
                for (Iterator iterator : this.elements) {
                    Object obj = this.copyToOriginalMap.get(iterator);
                    if (obj == null || !(obj instanceof Activity) || iterator == null || !(iterator instanceof Activity)) continue;
                    Activity activity = (Activity)iterator;
                    Activity activity2 = (Activity)obj;
                    Collection<Diagram> collection = diagramService.getDiagrams(activity2);
                    if (collection == null || collection.isEmpty()) continue;
                    for (Diagram diagram : collection) {
                        if (diagram == null) continue;
                        Diagram diagram2 = DiagramHelper.copyDiagram((EditingDomain)this.domain, diagram);
                        this.updateReferences(diagram2, activity, activity2);
                        int n = DiagramHelper.getDiagramType(diagram2);
                        this.mgr.associate(diagram2, n, activity);
                        this.copiedElements.add(diagram2);
                    }
                }
            }
            catch (Exception exception) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                if (DEBUG) {
                    exception.printStackTrace();
                }
                diagramService.dispose();
            }
        }
        finally {
            diagramService.dispose();
        }
    }

    private void clearReadOnly(org.eclipse.epf.diagram.model.Node node) {
        node.setReadOnly(false);
        if (node instanceof NodeContainer) {
            for (org.eclipse.epf.diagram.model.Node node2 : ((NodeContainer)node).getNodes()) {
                node2.setReadOnly(false);
            }
        }
    }

    private BreakdownElementWrapperItemProvider getOriginalWrapper(Activity activity) {
        String string = this.copyToWrapperPathMap.get(activity);
        if (string == null) {
            return null;
        }
        if (this.srcProcess != null) {
            Suppression suppression = Suppression.getSuppression((Process)this.srcProcess);
            ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            ConfigurationSetter configurationSetter = new ConfigurationSetter((AdapterFactory)composedAdapterFactory);
            try {
                configurationSetter.set(this.config);
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    arrayList.add(stringTokenizer.nextToken());
                }
                String[] stringArray = new String[arrayList.size()];
                arrayList.toArray(stringArray);
                Object object = suppression.getObjectByPath(stringArray, (AdapterFactory)composedAdapterFactory);
                if (object instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)object;
                    return breakdownElementWrapperItemProvider;
                }
                System.out.println("CopyDiagramCommand.getOriginalWrapper(): invalid wrapper for copy activity: " + object);
            }
            finally {
                configurationSetter.restore();
            }
        }
        return null;
    }

    private Collection<BreakdownElement> getBreakdownElements(Activity activity, Activity activity2) {
        BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = this.getOriginalWrapper(activity2);
        BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider2 = breakdownElementWrapperItemProvider != null ? breakdownElementWrapperItemProvider : activity;
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ConfigurationSetter configurationSetter = new ConfigurationSetter((AdapterFactory)composedAdapterFactory);
        try {
            configurationSetter.set(this.config);
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)composedAdapterFactory.adapt((Object)breakdownElementWrapperItemProvider2, ITreeItemContentProvider.class);
            Collection collection = iTreeItemContentProvider.getChildren((Object)activity);
            ArrayList<BreakdownElement> arrayList = new ArrayList<BreakdownElement>();
            for (Object e : collection) {
                Object object = TngUtil.unwrap(e);
                if (!(object instanceof BreakdownElement)) continue;
                arrayList.add((BreakdownElement)object);
            }
            ArrayList<BreakdownElement> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            configurationSetter.restore();
        }
    }

    private static BreakdownElement getBreakdownElement(Collection<BreakdownElement> collection, Activity activity) {
        for (BreakdownElement breakdownElement : collection) {
            if (!(breakdownElement instanceof VariabilityElement)) continue;
            boolean bl = false;
            VariabilityElement variabilityElement = (VariabilityElement)breakdownElement;
            while (variabilityElement.getVariabilityBasedOnElement() != null) {
                if (variabilityElement.getVariabilityBasedOnElement() == activity) {
                    bl = true;
                    break;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
            if (!bl) continue;
            return breakdownElement;
        }
        return null;
    }

    public void updateReferences(Diagram diagram, Activity activity, Activity activity2) {
        EObject eObject;
        int n = DiagramHelper.getDiagramType(diagram);
        CopyFinder copyFinder = new CopyFinder(activity2, activity);
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : diagram.getChildren()) {
            eObject = node.getElement();
            arrayList.add(node);
            if (!(eObject instanceof ActivityPartition)) continue;
            arrayList.addAll((Collection<Node>)node.getChildren());
        }
        for (Node node : arrayList) {
            BreakdownElement breakdownElement;
            EModelElement eModelElement;
            MethodElement methodElement;
            eObject = node.getElement();
            if (n == 0) {
                if (!(eObject instanceof StructuredActivityNode) && !(eObject instanceof ActivityParameterNode) || !((methodElement = BridgeHelper.getMethodElementFromAnnotation(eModelElement = (EModelElement)eObject, this.targetProcess.eResource().getResourceSet())) instanceof BreakdownElement) || (breakdownElement = copyFinder.findCopy((BreakdownElement)methodElement)) == null) continue;
                BridgeHelper.addEAnnotation(eModelElement, (MethodElement)breakdownElement);
                continue;
            }
            if (n == 2) {
                if (eObject instanceof org.eclipse.epf.diagram.model.Node) {
                    this.clearReadOnly((org.eclipse.epf.diagram.model.Node)eObject);
                }
                if (!(eObject instanceof NodeContainer)) continue;
                eModelElement = (NodeContainer)eObject;
                methodElement = eModelElement.getLinkedElement();
                breakdownElement = null;
                if (methodElement instanceof BreakdownElement && (breakdownElement = copyFinder.findCopy((BreakdownElement)methodElement)) != null) {
                    eModelElement.setLinkedElement((MethodElement)breakdownElement);
                }
                EList eList = eModelElement.getNodes();
                int n2 = 0;
                while (n2 < eList.size()) {
                    NamedNode namedNode = (NamedNode)eList.get(n2);
                    methodElement = namedNode.getLinkedElement();
                    if (methodElement instanceof BreakdownElement && (breakdownElement = copyFinder.findCopy((BreakdownElement)methodElement)) != null) {
                        namedNode.setLinkedElement((MethodElement)breakdownElement);
                    }
                    ++n2;
                }
                continue;
            }
            if (n != 1) continue;
            if (eObject instanceof org.eclipse.epf.diagram.model.Node) {
                this.clearReadOnly((org.eclipse.epf.diagram.model.Node)eObject);
            }
            if (!(eObject instanceof NamedNode) || !((methodElement = (eModelElement = (NamedNode)eObject).getLinkedElement()) instanceof BreakdownElement) || (breakdownElement = copyFinder.findCopy((BreakdownElement)methodElement)) == null) continue;
            eModelElement.setLinkedElement((MethodElement)breakdownElement);
        }
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        block3: {
            if (this.copiedElements != null && !this.copiedElements.isEmpty()) {
                try {
                    TxUtil.runInTransaction((TransactionalEditingDomain)this.domain, (Runnable)new Runnable(){

                        public void run() {
                            try {
                                for (Diagram diagram : CopyDiagramForDeepCopyCommand.this.copiedElements) {
                                    CopyDiagramForDeepCopyCommand.this.mgr.getResource().getContents().remove((Object)diagram.getElement());
                                    CopyDiagramForDeepCopyCommand.this.mgr.getResource().getContents().remove((Object)diagram);
                                }
                            }
                            catch (CoreException coreException) {
                                throw new WrappedException((Exception)((Object)coreException));
                            }
                        }
                    });
                    this.copiedElements.clear();
                }
                catch (Exception exception) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
                    if (!DEBUG) break block3;
                    exception.printStackTrace();
                }
            }
        }
    }

    public Collection getModifiedResources() {
        if (this.copiedElements == null || this.copiedElements.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        HashSet<Resource> hashSet = new HashSet<Resource>();
        for (Diagram diagram : this.copiedElements) {
            if (diagram == null || diagram.eResource() == null) continue;
            hashSet.add(diagram.eResource());
        }
        return hashSet;
    }

    public void dispose() {
        if (this.mgr != null) {
            this.mgr.removeConsumer((Object)this);
        }
        super.dispose();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CopyFinder {
        private Activity origActivity;
        private Activity copyActivity;
        private Map<BreakdownElement, BreakdownElement> originalToCopyMap;
        private Collection<BreakdownElement> elements;

        private CopyFinder(Activity activity, Activity activity2) {
            this.origActivity = activity;
            this.copyActivity = activity2;
        }

        public Map<BreakdownElement, BreakdownElement> getOriginalToCopyMap() {
            if (this.originalToCopyMap == null) {
                this.originalToCopyMap = new HashMap<BreakdownElement, BreakdownElement>();
                for (BreakdownElement breakdownElement : this.copyActivity.getBreakdownElements()) {
                    BreakdownElement breakdownElement2 = (BreakdownElement)CopyDiagramForDeepCopyCommand.this.copyHelper.getOriginal((Object)breakdownElement);
                    this.originalToCopyMap.put(breakdownElement2, breakdownElement);
                }
            }
            return this.originalToCopyMap;
        }

        BreakdownElement findCopy(BreakdownElement breakdownElement) {
            BreakdownElement breakdownElement2 = this.getOriginalToCopyMap().get(breakdownElement);
            if (breakdownElement2 == null && breakdownElement instanceof Activity) {
                if (this.elements == null) {
                    this.elements = CopyDiagramForDeepCopyCommand.this.getBreakdownElements(this.origActivity, this.copyActivity);
                }
                breakdownElement2 = CopyDiagramForDeepCopyCommand.getBreakdownElement(this.elements, (Activity)breakdownElement);
            }
            return breakdownElement2;
        }
    }
}

