/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSynchronizer
implements IResourceChangeListener {
    protected boolean fIsInstalled = false;
    private Map fFileInfoMap = new HashMap();

    public FileSynchronizer() {
        this.install();
    }

    void updateModificationStamp(IFile iFile) {
        FileInfo fileInfo = this.getFileInfo(iFile);
        if (fileInfo != null) {
            fileInfo.fModificationStamp = FileSynchronizer.computeModificationStamp((IResource)iFile);
        }
    }

    protected FileInfo getFileInfo(Object object) {
        return (FileInfo)this.fFileInfoMap.get(object);
    }

    public void install() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.fIsInstalled = true;
    }

    public void uninstall() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.fIsInstalled = false;
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
        try {
            if (iResourceDelta != null && this.fIsInstalled) {
                ResourceDeltaVisistor resourceDeltaVisistor = new ResourceDeltaVisistor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisistor);
                Runnable runnable = resourceDeltaVisistor.getRunnable();
                if (runnable != null) {
                    this.update(runnable);
                }
            }
        }
        catch (CoreException coreException) {
            this.handleCoreException(coreException, EditorMessages.FileDocumentProvider_resourceChanged);
        }
    }

    protected void handleCoreException(CoreException coreException, String string) {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.ui");
        ILog iLog = Platform.getLog((Bundle)bundle);
        if (string != null) {
            iLog.log((IStatus)new Status(4, "org.eclipse.ui", 0, string, (Throwable)coreException));
        } else {
            iLog.log(coreException.getStatus());
        }
    }

    public static long computeModificationStamp(IResource iResource) {
        if (iResource == null) {
            System.err.println("FATAL ERROR: resource is null.");
            return 0L;
        }
        long l = iResource.getModificationStamp();
        IPath iPath = iResource.getLocation();
        if (iPath == null) {
            return l;
        }
        l = iPath.toFile().lastModified();
        return l;
    }

    protected void update(Runnable runnable) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow[] iWorkbenchWindowArray = iWorkbench.getWorkbenchWindows();
        if (iWorkbenchWindowArray != null && iWorkbenchWindowArray.length > 0) {
            Display display = iWorkbenchWindowArray[0].getShell().getDisplay();
            display.asyncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public void monitor(IFile iFile) {
        FileInfo fileInfo = (FileInfo)this.fFileInfoMap.get(iFile);
        if (fileInfo == null) {
            fileInfo = new FileInfo(iFile);
            fileInfo.fModificationStamp = FileSynchronizer.computeModificationStamp((IResource)iFile);
            this.fFileInfoMap.put(iFile, fileInfo);
        }
    }

    public void unmonitor(IFile iFile) {
        this.fFileInfoMap.remove(iFile);
    }

    protected void handleChanged(ResourceDeltaVisistor resourceDeltaVisistor) {
        if (!resourceDeltaVisistor.changedFiles.isEmpty()) {
            this.handleChangedFiles(resourceDeltaVisistor.changedFiles);
        }
        if (!resourceDeltaVisistor.movedFileToNewPathMap.isEmpty()) {
            this.handleMovedFiles(resourceDeltaVisistor.movedFileToNewPathMap);
        }
        if (!resourceDeltaVisistor.deletedFiles.isEmpty()) {
            this.handleDeletedFiles(resourceDeltaVisistor.deletedFiles);
        }
    }

    protected Collection handleDeletedFiles(Collection<IFile> collection) {
        return Collections.EMPTY_LIST;
    }

    protected Map<IFile, IPath> handleMovedFiles(Map<IFile, IPath> map) {
        return Collections.EMPTY_MAP;
    }

    protected Collection handleChangedFiles(Collection<IFile> collection) {
        return Collections.EMPTY_LIST;
    }

    protected class FileInfo {
        public long fModificationStamp = -1L;
        public boolean fCanBeSaved;
        public IFile fFile;

        public FileInfo(IFile iFile) {
            this.fFile = iFile;
        }
    }

    private class ResourceDeltaVisistor
    implements IResourceDeltaVisitor {
        private Collection<IFile> changedFiles = new ArrayList<IFile>();
        private Map<IFile, IPath> movedFileToNewPathMap = new HashMap<IFile, IPath>();
        private Collection<IFile> deletedFiles = new ArrayList<IFile>();

        private ResourceDeltaVisistor() {
        }

        public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
            if (iResourceDelta == null) {
                return false;
            }
            switch (iResourceDelta.getKind()) {
                case 4: {
                    boolean bl;
                    FileInfo fileInfo = FileSynchronizer.this.getFileInfo(iResourceDelta.getResource());
                    if (fileInfo == null || fileInfo.fCanBeSaved) break;
                    IFile iFile = (IFile)iResourceDelta.getResource();
                    boolean bl2 = bl = FileSynchronizer.computeModificationStamp((IResource)iFile) == fileInfo.fModificationStamp;
                    if (((0x100000 & iResourceDelta.getFlags()) == 0 || !bl) && ((0x100 & iResourceDelta.getFlags()) == 0 || bl)) break;
                    this.changedFiles.add(iFile);
                    break;
                }
                case 2: {
                    if ((0x2000 & iResourceDelta.getFlags()) != 0) {
                        FileInfo fileInfo = FileSynchronizer.this.getFileInfo(iResourceDelta.getResource());
                        if (fileInfo == null) break;
                        IPath iPath = iResourceDelta.getMovedToPath();
                        this.movedFileToNewPathMap.put((IFile)iResourceDelta.getResource(), iPath);
                        break;
                    }
                    FileInfo fileInfo = FileSynchronizer.this.getFileInfo(iResourceDelta.getResource());
                    if (fileInfo == null || fileInfo.fCanBeSaved) break;
                    this.deletedFiles.add((IFile)iResourceDelta.getResource());
                }
            }
            return true;
        }

        public Runnable getRunnable() {
            if (this.changedFiles.isEmpty() && this.movedFileToNewPathMap.isEmpty() && this.deletedFiles.isEmpty()) {
                return null;
            }
            return new Runnable(){

                public void run() {
                    FileSynchronizer.this.handleChanged(ResourceDeltaVisistor.this);
                }
            };
        }
    }
}

