/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.library.edit.command.UserInput;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UserInputsDialog
extends Dialog {
    IStructuredContentProvider contentProvider;
    ILabelProvider labelProvider;
    private String title;
    private String globalErrorTxt = "";
    private String message;
    private List userInputs;
    private boolean result = false;
    Label messageArea;
    Label errorArea;
    HashMap<Object, Object> oldInfoForCancel;
    private Color redColor;

    public UserInputsDialog(Shell shell, List list, String string, String string2) {
        super(shell);
        this.title = string;
        this.message = string2;
        this.userInputs = list;
        this.oldInfoForCancel = new HashMap();
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    protected void createTreeViewer(Composite composite, UserInput userInput) {
        TreeViewer treeViewer = !userInput.isMultiple() ? new TreeViewer(composite, 2820) : new TreeViewer(composite, 2818);
        GridData gridData = new GridData(1808);
        gridData.widthHint = 200;
        gridData.heightHint = 200;
        gridData.horizontalSpan = 3;
        treeViewer.getControl().setLayoutData((Object)gridData);
        treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            }
        });
        if (treeViewer != null) {
            treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            if (this.contentProvider != null) {
                treeViewer.setContentProvider((IContentProvider)this.contentProvider);
            } else {
                treeViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            }
            treeViewer.setUseHashlookup(true);
            treeViewer.setInput((Object)userInput.getChoices());
            treeViewer.getControl().setFont(composite.getFont());
        }
    }

    protected void createTableViewer(Composite composite, UserInput userInput) {
        TableViewer tableViewer = new TableViewer(composite);
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            }
        });
    }

    protected void createText(Composite composite, UserInput userInput) {
        final UserInput userInput2 = userInput;
        final IValidator iValidator = userInput.getValidator();
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 4, true, true));
        if (userInput.getInput() != null) {
            text.setText((String)userInput.getInput());
        }
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                UserInputsDialog.this.getButton(0).setEnabled(true);
                UserInputsDialog.this.errorArea.setText("");
                String string = "";
                if (iValidator != null) {
                    string = iValidator.isValid(text.getText());
                    if (string != null && string.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(string);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                    UserInputsDialog.this.globalErrorTxt = string;
                }
                if (string == null || string.length() <= 0) {
                    userInput2.setInput((Object)text.getText());
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = "";
                if (iValidator != null) {
                    string = iValidator.isValid(text.getText());
                    if (string != null && string.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(string);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                    UserInputsDialog.this.globalErrorTxt = string;
                }
                if (string == null || string.length() <= 0) {
                    userInput2.setInput((Object)text.getText());
                }
            }
        });
    }

    protected void setInput(UserInput userInput, Object object) {
        userInput.setInput(object);
    }

    protected void createComboViewer(Composite composite, UserInput userInput) {
        final UserInput userInput2 = userInput;
        final IValidator iValidator = userInput.getValidator();
        final ComboViewer comboViewer = new ComboViewer(composite);
        comboViewer.getCombo().setLayoutData((Object)new GridData(4, 4, true, true));
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        if (userInput.getLabelProvider() != null) {
            comboViewer.setLabelProvider((IBaseLabelProvider)userInput.getLabelProvider());
        }
        List list = userInput.getChoices();
        comboViewer.setInput((Object)list);
        if (list != null && list.size() > 0) {
            comboViewer.setSelection((ISelection)new StructuredSelection(list.get(0)));
            userInput2.setInput(list.get(0));
        }
        comboViewer.getCombo().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                String string = "";
                IStructuredSelection iStructuredSelection = (IStructuredSelection)comboViewer.getSelection();
                if (iValidator == null || iStructuredSelection == null) {
                    return;
                }
                IStatus iStatus = iValidator.isValid(iStructuredSelection.getFirstElement());
                if (iStatus.getSeverity() == 4) {
                    string = iStatus.getMessage();
                }
                if (string != null && string.length() > 0) {
                    UserInputsDialog.this.errorArea.setText(string);
                    UserInputsDialog.this.getButton(0).setEnabled(false);
                }
                if (UserInputsDialog.this.globalErrorTxt != null && UserInputsDialog.this.globalErrorTxt.length() > 0) {
                    UserInputsDialog.this.errorArea.setText(UserInputsDialog.this.globalErrorTxt);
                    UserInputsDialog.this.getButton(0).setEnabled(false);
                } else {
                    UserInputsDialog.this.errorArea.setText("");
                }
            }
        });
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                UserInputsDialog.this.getButton(0).setEnabled(true);
                UserInputsDialog.this.errorArea.setText("");
                IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
                Object object = iStructuredSelection.getFirstElement();
                String string = "";
                if (iValidator != null) {
                    IStatus iStatus = iValidator.isValid(object);
                    if (iStatus.getCode() == 4) {
                        string = iStatus.getMessage();
                    }
                    if (string != null && string.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(string);
                    } else if (UserInputsDialog.this.globalErrorTxt != null && UserInputsDialog.this.globalErrorTxt.length() > 0) {
                        UserInputsDialog.this.errorArea.setText(UserInputsDialog.this.globalErrorTxt);
                        UserInputsDialog.this.getButton(0).setEnabled(false);
                    } else {
                        UserInputsDialog.this.errorArea.setText("");
                    }
                }
                if (string == null || string.length() <= 0) {
                    userInput2.setInput(object);
                }
            }
        });
    }

    protected Label createMessageArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.messageArea = new Label(composite2, 64);
        if (this.message != null) {
            this.messageArea.setText(this.message);
        }
        gridData = new GridData(768);
        gridData.minimumWidth = 400;
        this.messageArea.setLayoutData((Object)gridData);
        UserInputsDialog.applyDialogFont((Control)this.messageArea);
        Label label = new Label(composite2, 258);
        GridData gridData2 = new GridData(768);
        gridData2.horizontalSpan = 2;
        label.setLayoutData((Object)gridData2);
        return this.messageArea;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        this.createMessageArea(composite2);
        Composite composite3 = new Composite(composite2, 0);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginLeft = 0;
        composite3.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        composite3.setLayoutData((Object)gridData);
        if (this.userInputs != null && this.userInputs.size() > 0) {
            for (Object e : this.userInputs) {
                if (!(e instanceof UserInput)) continue;
                UserInput userInput = (UserInput)e;
                this.oldInfoForCancel.put(userInput, userInput.getInput());
                Label label = new Label(composite3, 0);
                label.setText(userInput.getLabel());
                GridData gridData2 = new GridData(1);
                label.setLayoutData((Object)gridData2);
                if (userInput.getType() == 0) {
                    this.createText(composite3, userInput);
                    continue;
                }
                if (userInput.getType() != 1) continue;
                this.createComboViewer(composite3, userInput);
            }
        }
        this.createErrorArea(composite2);
        return composite2;
    }

    private void createErrorArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginLeft = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1808);
        composite2.setLayoutData((Object)gridData);
        this.errorArea = new Label(composite2, 64);
        this.redColor = new Color(null, new RGB(255, 0, 0));
        if (this.redColor != null) {
            this.errorArea.setForeground(this.redColor);
        }
        gridData = new GridData(1792);
        gridData.heightHint = 80;
        this.errorArea.setLayoutData((Object)gridData);
        UserInputsDialog.applyDialogFont((Control)this.errorArea);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void okPressed() {
        this.result = true;
        super.okPressed();
    }

    protected void cancelPressed() {
        if (this.userInputs != null && this.userInputs.size() > 0) {
            for (Object e : this.userInputs) {
                if (!(e instanceof UserInput)) continue;
                UserInput userInput = (UserInput)e;
                userInput.setInput(this.oldInfoForCancel.get(userInput));
            }
        }
        super.cancelPressed();
    }

    public boolean getResult() {
        return this.result;
    }

    public boolean close() {
        if (this.redColor != null) {
            this.redColor.dispose();
        }
        return super.close();
    }
}

