/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.internal.wizards;

import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryMainPage2;
import org.eclipse.epf.library.ui.internal.wizards.OpenLibraryWizardPageFactory;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.library.xmi.XMILibraryUtil;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class OpenLibraryWizard2
extends Wizard
implements INewWizard {
    public static final String WIZARD_ID = OpenLibraryWizard2.class.getName();
    private OpenLibraryMainPage2 mainPage;

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(LibraryUIResources.openLibraryWizard_title);
    }

    public void addPages() {
        this.mainPage = new OpenLibraryMainPage2();
        this.addPage((IWizardPage)this.mainPage);
        for (String string : LibraryManagerFactory.getInstance().getLibraryTypes().keySet()) {
            String string2 = String.valueOf(string) + "Page";
            OpenLibraryWizardPage openLibraryWizardPage = OpenLibraryWizardPageFactory.getInstance().createWizardPage(string2, string);
            if (openLibraryWizardPage == null) continue;
            openLibraryWizardPage.setImageDescriptor(LibraryUIPlugin.getDefault().getImageDescriptor("full/wizban/Open.gif"));
            this.addPage((IWizardPage)openLibraryWizardPage);
        }
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(LibraryUIPlugin.getDefault().getSharedImage("full/obj16/MethodLibrary.gif"));
    }

    public boolean canFinish() {
        if (this.mainPage.isPageComplete() && !this.mainPage.isOpenUnlistedLibrary()) {
            return true;
        }
        IWizardPage[] iWizardPageArray = this.getPages();
        int n = 1;
        while (n < iWizardPageArray.length) {
            if (!iWizardPageArray[n].isPageComplete()) {
                return false;
            }
            ++n;
        }
        return this.getContainer().getCurrentPage() != this.mainPage;
    }

    public boolean performFinish() {
        block12: {
            String string;
            block15: {
                Object object;
                block13: {
                    block14: {
                        String string2 = this.mainPage.getLibraryType();
                        OpenLibraryWizardPage openLibraryWizardPage = OpenLibraryWizardPageFactory.getInstance().getWizardPage(string2);
                        try {
                            string = null;
                            if (this.mainPage.isOpenUnlistedLibrary()) {
                                object = openLibraryWizardPage.getSelections();
                                string = (String)object.get("library.path");
                            } else {
                                string = this.mainPage.getLibraryPath();
                            }
                            if (string == null) break block12;
                            if (XMILibraryUtil.isValidLibrary((String)string, (boolean)true) != Status.OK_STATUS) break block13;
                            if (OpenLibraryWizard2.handleToolVersion(string, null)) break block14;
                            return false;
                        }
                        catch (Exception exception) {
                            object = exception.getMessage();
                            if (object == null) {
                                object = LibraryUIResources.openLibraryInternlError_reason;
                            }
                            object = String.valueOf(object) + "\n\n" + LibraryUIResources.openLibraryError_advice;
                            if (exception.getMessage() != null) {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, (String)object);
                            } else {
                                LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.openLibraryError_msg, (String)object, (Throwable)exception);
                            }
                            return false;
                        }
                    }
                    if (LibraryUIManager.getInstance().openLibrary(string)) {
                        this.addRecentlyOpenedLibrary();
                        return true;
                    }
                    break block12;
                }
                if (XMILibraryUtil.containsPluginOrConfigSpecExportFile((String)string)) {
                    throw new Exception(LibraryUIResources.openLibraryError_reason4);
                }
                object = LibraryUIPlugin.getDefault().getMsgDialog();
                boolean bl = object.displayConfirmation(LibraryUIResources.openLibraryWizard_title, NLS.bind((String)LibraryUIResources.openLibraryDialog_newLibrary_text, (Object[])new Object[]{string}));
                if (bl) break block15;
                return false;
            }
            if (!LibraryUIManager.getInstance().createLibrary(string)) break block12;
            this.addRecentlyOpenedLibrary();
            return true;
        }
        return true;
    }

    protected void addRecentlyOpenedLibrary() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary != null) {
            String string = LibraryService.getInstance().getLibraryManager(methodLibrary).getMethodLibraryURI().toString();
            LibraryUIPreferences.addOpenLibraryURI(string);
        }
    }

    public static boolean handleToolVersion(String string, UpgradeCallerInfo upgradeCallerInfo) {
        VersionUtil.VersionCheckInfo versionCheckInfo;
        String string2 = "library.xmi";
        if (upgradeCallerInfo != null && upgradeCallerInfo.getIsExportedPluginLib()) {
            string2 = "export.xmi";
        }
        if ((versionCheckInfo = VersionUtil.checkLibraryVersion((File)new File(string, string2))) != null && versionCheckInfo.result > 0) {
            String string3 = "";
            string3 = versionCheckInfo.toolID.equals(VersionUtil.getPrimaryToolID()) ? NLS.bind((String)LibraryUIResources.versionMismatchDialog_text, (Object[])new Object[]{Platform.getProduct().getName(), versionCheckInfo.toolVersion}) : NLS.bind((String)LibraryUIResources.versionMismatchDialog_text_unknown, (Object[])new Object[]{Platform.getProduct().getName()});
            if (!OpenLibraryWizard2.isUpgradeLibrary(upgradeCallerInfo)) {
                upgradeCallerInfo.setErrorMsg(string3);
                return false;
            }
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryUIResources.openLibraryWizard_title, string3);
            return false;
        }
        if (XMILibraryUtil.isMethodLibraryUpgradeRequired((String)string, (String)string2, (VersionUtil.VersionCheckInfo)versionCheckInfo)) {
            if (OpenLibraryWizard2.isUpgradeLibrary(upgradeCallerInfo) && !LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(LibraryUIResources.openLibraryWizard_title, LibraryUIResources.upgradeLibraryDialog_text)) {
                return false;
            }
            if (!OpenLibraryWizard2.isUpgradeLibrary(upgradeCallerInfo)) {
                upgradeCallerInfo.copyLibrary();
                if (upgradeCallerInfo.getCopiedLibFile() != null) {
                    string = upgradeCallerInfo.getCopiedLibFile().getParentFile().getAbsolutePath();
                }
            }
            if (!LibraryUIManager.upgradeLibrary(string, upgradeCallerInfo)) {
                return false;
            }
        }
        return true;
    }

    private static boolean isUpgradeLibrary(UpgradeCallerInfo upgradeCallerInfo) {
        return UpgradeCallerInfo.isUpgradeLibrary((UpgradeCallerInfo)upgradeCallerInfo);
    }
}

