/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.preferences;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.internal.base.remote.RemoteHelp;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class HelpContentPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button checkbox;
    private Group group;
    private Label hostLabel;
    private Text hostText;
    private Label pathLabel;
    private Text pathText;
    private Button radio1;
    private Button radio2;
    private Text portText;
    private Listener changeListener = new Listener(){

        public void handleEvent(Event event) {
            HelpContentPreferencePage.this.updateEnablement();
            HelpContentPreferencePage.this.updateValidity();
        }
    };

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.help.ui.prefPageHelpContent");
        Composite composite = this.createComposite(parent);
        this.createCheckbox(composite);
        this.createGroup(composite);
        this.applyDialogFont(composite);
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        boolean isOn = prefs.getBoolean("remoteHelpOn");
        String host = prefs.getString("remoteHelpHost");
        String path = prefs.getString("remoteHelpPath");
        boolean useDefaultPort = prefs.getBoolean("remoteHelpUseDefaultPort");
        int port = prefs.getInt("remoteHelpPort");
        this.setValues(isOn, host, path, useDefaultPort, port);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        boolean isOn = prefs.getDefaultBoolean("remoteHelpOn");
        String host = prefs.getDefaultString("remoteHelpHost");
        String path = prefs.getDefaultString("remoteHelpPath");
        boolean useDefaultPort = prefs.getDefaultBoolean("remoteHelpUseDefaultPort");
        int port = prefs.getDefaultInt("remoteHelpPort");
        this.setValues(isOn, host, path, useDefaultPort, port);
    }

    public boolean performOk() {
        Preferences prefs = HelpBasePlugin.getDefault().getPluginPreferences();
        prefs.setValue("remoteHelpOn", this.checkbox.getSelection());
        prefs.setValue("remoteHelpHost", this.hostText.getText().trim());
        prefs.setValue("remoteHelpPath", this.pathText.getText().trim());
        prefs.setValue("remoteHelpUseDefaultPort", this.radio1.getSelection());
        prefs.setValue("remoteHelpPort", this.portText.getText().trim());
        HelpBasePlugin.getDefault().savePluginPreferences();
        RemoteHelp.notifyPreferenceChange();
        return true;
    }

    private Composite createComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, false, false));
        return composite;
    }

    private void createCheckbox(Composite parent) {
        this.checkbox = new Button(parent, 32);
        this.checkbox.setText(Messages.HelpContentPreferencePage_remote);
        this.checkbox.addListener(13, this.changeListener);
    }

    private void createGroup(Composite parent) {
        this.group = new Group(parent, 0);
        this.group.setText(Messages.HelpContentPreferencePage_location);
        this.group.setLayout((Layout)new GridLayout(2, false));
        this.group.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.createHostSection((Composite)this.group);
        this.createPathSection((Composite)this.group);
        this.createPortSection((Composite)this.group);
    }

    private void createHostSection(Composite parent) {
        this.hostLabel = new Label(parent, 0);
        this.hostLabel.setText(Messages.HelpContentPreferencePage_host);
        this.hostText = new Text(parent, 2048);
        this.hostText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.hostText.addListener(24, this.changeListener);
    }

    private void createPathSection(Composite parent) {
        this.pathLabel = new Label(parent, 0);
        this.pathLabel.setText(Messages.HelpContentPreferencePage_path);
        this.pathText = new Text(parent, 2048);
        this.pathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pathText.addListener(24, this.changeListener);
    }

    private void createPortSection(Composite parent) {
        Composite portComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        portComposite.setLayout((Layout)layout);
        portComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 2, 1));
        this.radio1 = new Button(portComposite, 16);
        this.radio1.setText(Messages.HelpContentPreferencePage_portDefault);
        this.radio1.setLayoutData((Object)new GridData(1, 0x1000000, false, false, 2, 1));
        this.radio1.addListener(13, this.changeListener);
        this.radio2 = new Button(portComposite, 16);
        this.radio2.setText(Messages.HelpContentPreferencePage_port);
        this.radio2.addListener(13, this.changeListener);
        this.portText = new Text(portComposite, 2048);
        this.portText.setLayoutData((Object)new GridData(50, -1));
        this.portText.addListener(24, this.changeListener);
    }

    private void setValues(boolean isOn, String host, String path, boolean useDefaultPort, int port) {
        this.checkbox.setSelection(isOn);
        this.hostText.setText(host);
        this.pathText.setText(path);
        this.radio1.setSelection(useDefaultPort);
        this.radio2.setSelection(!useDefaultPort);
        this.portText.setText(String.valueOf(port));
        this.updateEnablement();
        this.updateValidity();
    }

    private void updateEnablement() {
        boolean isChecked = this.checkbox.getSelection();
        this.group.setEnabled(isChecked);
        this.hostLabel.setEnabled(isChecked);
        this.hostText.setEnabled(isChecked);
        this.pathLabel.setEnabled(isChecked);
        this.pathText.setEnabled(isChecked);
        this.radio1.setEnabled(isChecked);
        this.radio2.setEnabled(isChecked);
        this.portText.setEnabled(isChecked && this.radio2.getSelection());
    }

    private void updateValidity() {
        if (this.checkbox.getSelection()) {
            if (this.hostText.getText().trim().length() == 0) {
                this.setErrorMessage(Messages.HelpContentPreferencePage_error_host);
                this.setValid(false);
                return;
            }
            if (this.radio2.getSelection()) {
                try {
                    int port = Integer.parseInt(this.portText.getText());
                    if (port < 0 || port > 65535) {
                        this.setErrorMessage(Messages.HelpContentPreferencePage_error_port);
                        this.setValid(false);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    this.setErrorMessage(Messages.HelpContentPreferencePage_error_port);
                    this.setValid(false);
                    return;
                }
            }
        }
        this.setErrorMessage(null);
        this.setValid(true);
    }
}

