/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.common.service.versioning;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.epf.common.service.versioning.EPFVersion;
import org.osgi.framework.Version;

public class EPFVersions {
    public static final String TOOL_ID = "epf";
    private static String nsUri = "http://www.eclipse.org/epf";
    private static EPFVersion EPF_10 = new EPFVersion("1.0", "1.0.3.0", "1.0.0");
    private static EPFVersion EPF_11 = new EPFVersion("1.1", "1.0.4.0", "1.0.0");
    private static EPFVersion EPF_12;
    private static EPFVersion currentVersion;

    static {
        currentVersion = EPF_12 = new EPFVersion("1.2", "1.0.4.1", "1.0.1");
    }

    public EPFVersion getCurrentVersion() {
        return currentVersion;
    }

    public EPFVersion getVersion(String string) {
        if (string != null) {
            for (EPFVersion ePFVersion : this.getAllVersions()) {
                if (!ePFVersion.getToolVersion().equals((Object)new Version(string))) continue;
                return ePFVersion;
            }
        }
        return null;
    }

    public Collection getAllVersions() {
        ArrayList<EPFVersion> arrayList = new ArrayList<EPFVersion>();
        arrayList.add(EPF_10);
        arrayList.add(EPF_11);
        arrayList.add(EPF_12);
        return arrayList;
    }

    public EPFVersion getMinToolVersionForLibraryVersion(Version version) {
        for (EPFVersion ePFVersion : this.getAllVersions()) {
            if (ePFVersion.getLibraryVersion().compareTo((Object)version) != 0) continue;
            return ePFVersion;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentLibraryVersion() {
        Version version = this.getCurrentVersion().getLibraryVersion();
        return this.getMinToolVersionForLibraryVersion(version);
    }

    public EPFVersion getMinToolVersionForXMLSchemaVersion(Version version) {
        for (EPFVersion ePFVersion : this.getAllVersions()) {
            if (ePFVersion.getXMLSchemaVersion().compareTo((Object)version) != 0) continue;
            return ePFVersion;
        }
        return null;
    }

    public EPFVersion getMinToolVersionForCurrentXMLSchemaVersion() {
        Version version = this.getCurrentVersion().getXMLSchemaVersion();
        return this.getMinToolVersionForXMLSchemaVersion(version);
    }

    public String getNsURI() {
        return nsUri;
    }
}

